/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFacetRequest extends CloudDirectoryRequest implements
        ToCopyableBuilder<UpdateFacetRequest.Builder, UpdateFacetRequest> {
    private static final SdkField<String> SCHEMA_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaArn").getter(getter(UpdateFacetRequest::schemaArn)).setter(setter(Builder::schemaArn))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-data-partition").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateFacetRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<FacetAttributeUpdate>> ATTRIBUTE_UPDATES_FIELD = SdkField
            .<List<FacetAttributeUpdate>> builder(MarshallingType.LIST)
            .memberName("AttributeUpdates")
            .getter(getter(UpdateFacetRequest::attributeUpdates))
            .setter(setter(Builder::attributeUpdates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeUpdates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FacetAttributeUpdate> builder(MarshallingType.SDK_POJO)
                                            .constructor(FacetAttributeUpdate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> OBJECT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ObjectType").getter(getter(UpdateFacetRequest::objectTypeAsString)).setter(setter(Builder::objectType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_ARN_FIELD, NAME_FIELD,
            ATTRIBUTE_UPDATES_FIELD, OBJECT_TYPE_FIELD));

    private final String schemaArn;

    private final String name;

    private final List<FacetAttributeUpdate> attributeUpdates;

    private final String objectType;

    private UpdateFacetRequest(BuilderImpl builder) {
        super(builder);
        this.schemaArn = builder.schemaArn;
        this.name = builder.name;
        this.attributeUpdates = builder.attributeUpdates;
        this.objectType = builder.objectType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that is associated with the <a>Facet</a>. For more information, see <a>arns</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that is associated with the <a>Facet</a>. For more information, see
     *         <a>arns</a>.
     */
    public final String schemaArn() {
        return schemaArn;
    }

    /**
     * <p>
     * The name of the facet.
     * </p>
     * 
     * @return The name of the facet.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns true if the AttributeUpdates property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasAttributeUpdates() {
        return attributeUpdates != null && !(attributeUpdates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of attributes that need to be updated in a given schema <a>Facet</a>. Each attribute is followed by
     * <code>AttributeAction</code>, which specifies the type of update operation to perform.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttributeUpdates()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of attributes that need to be updated in a given schema <a>Facet</a>. Each attribute is followed by
     *         <code>AttributeAction</code>, which specifies the type of update operation to perform.
     */
    public final List<FacetAttributeUpdate> attributeUpdates() {
        return attributeUpdates;
    }

    /**
     * <p>
     * The object type that is associated with the facet. See <a>CreateFacetRequest$ObjectType</a> for more details.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #objectType} will
     * return {@link ObjectType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #objectTypeAsString}.
     * </p>
     * 
     * @return The object type that is associated with the facet. See <a>CreateFacetRequest$ObjectType</a> for more
     *         details.
     * @see ObjectType
     */
    public final ObjectType objectType() {
        return ObjectType.fromValue(objectType);
    }

    /**
     * <p>
     * The object type that is associated with the facet. See <a>CreateFacetRequest$ObjectType</a> for more details.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #objectType} will
     * return {@link ObjectType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #objectTypeAsString}.
     * </p>
     * 
     * @return The object type that is associated with the facet. See <a>CreateFacetRequest$ObjectType</a> for more
     *         details.
     * @see ObjectType
     */
    public final String objectTypeAsString() {
        return objectType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(schemaArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributeUpdates() ? attributeUpdates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(objectTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFacetRequest)) {
            return false;
        }
        UpdateFacetRequest other = (UpdateFacetRequest) obj;
        return Objects.equals(schemaArn(), other.schemaArn()) && Objects.equals(name(), other.name())
                && hasAttributeUpdates() == other.hasAttributeUpdates()
                && Objects.equals(attributeUpdates(), other.attributeUpdates())
                && Objects.equals(objectTypeAsString(), other.objectTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFacetRequest").add("SchemaArn", schemaArn()).add("Name", name())
                .add("AttributeUpdates", hasAttributeUpdates() ? attributeUpdates() : null)
                .add("ObjectType", objectTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SchemaArn":
            return Optional.ofNullable(clazz.cast(schemaArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "AttributeUpdates":
            return Optional.ofNullable(clazz.cast(attributeUpdates()));
        case "ObjectType":
            return Optional.ofNullable(clazz.cast(objectTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFacetRequest, T> g) {
        return obj -> g.apply((UpdateFacetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudDirectoryRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateFacetRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that is associated with the <a>Facet</a>. For more information, see
         * <a>arns</a>.
         * </p>
         * 
         * @param schemaArn
         *        The Amazon Resource Name (ARN) that is associated with the <a>Facet</a>. For more information, see
         *        <a>arns</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaArn(String schemaArn);

        /**
         * <p>
         * The name of the facet.
         * </p>
         * 
         * @param name
         *        The name of the facet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * List of attributes that need to be updated in a given schema <a>Facet</a>. Each attribute is followed by
         * <code>AttributeAction</code>, which specifies the type of update operation to perform.
         * </p>
         * 
         * @param attributeUpdates
         *        List of attributes that need to be updated in a given schema <a>Facet</a>. Each attribute is followed
         *        by <code>AttributeAction</code>, which specifies the type of update operation to perform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeUpdates(Collection<FacetAttributeUpdate> attributeUpdates);

        /**
         * <p>
         * List of attributes that need to be updated in a given schema <a>Facet</a>. Each attribute is followed by
         * <code>AttributeAction</code>, which specifies the type of update operation to perform.
         * </p>
         * 
         * @param attributeUpdates
         *        List of attributes that need to be updated in a given schema <a>Facet</a>. Each attribute is followed
         *        by <code>AttributeAction</code>, which specifies the type of update operation to perform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeUpdates(FacetAttributeUpdate... attributeUpdates);

        /**
         * <p>
         * List of attributes that need to be updated in a given schema <a>Facet</a>. Each attribute is followed by
         * <code>AttributeAction</code>, which specifies the type of update operation to perform.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FacetAttributeUpdate>.Builder} avoiding the
         * need to create one manually via {@link List<FacetAttributeUpdate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FacetAttributeUpdate>.Builder#build()} is called immediately
         * and its result is passed to {@link #attributeUpdates(List<FacetAttributeUpdate>)}.
         * 
         * @param attributeUpdates
         *        a consumer that will call methods on {@link List<FacetAttributeUpdate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributeUpdates(List<FacetAttributeUpdate>)
         */
        Builder attributeUpdates(Consumer<FacetAttributeUpdate.Builder>... attributeUpdates);

        /**
         * <p>
         * The object type that is associated with the facet. See <a>CreateFacetRequest$ObjectType</a> for more details.
         * </p>
         * 
         * @param objectType
         *        The object type that is associated with the facet. See <a>CreateFacetRequest$ObjectType</a> for more
         *        details.
         * @see ObjectType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectType
         */
        Builder objectType(String objectType);

        /**
         * <p>
         * The object type that is associated with the facet. See <a>CreateFacetRequest$ObjectType</a> for more details.
         * </p>
         * 
         * @param objectType
         *        The object type that is associated with the facet. See <a>CreateFacetRequest$ObjectType</a> for more
         *        details.
         * @see ObjectType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectType
         */
        Builder objectType(ObjectType objectType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudDirectoryRequest.BuilderImpl implements Builder {
        private String schemaArn;

        private String name;

        private List<FacetAttributeUpdate> attributeUpdates = DefaultSdkAutoConstructList.getInstance();

        private String objectType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFacetRequest model) {
            super(model);
            schemaArn(model.schemaArn);
            name(model.name);
            attributeUpdates(model.attributeUpdates);
            objectType(model.objectType);
        }

        public final String getSchemaArn() {
            return schemaArn;
        }

        @Override
        public final Builder schemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
            return this;
        }

        public final void setSchemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<FacetAttributeUpdate.Builder> getAttributeUpdates() {
            if (attributeUpdates instanceof SdkAutoConstructList) {
                return null;
            }
            return attributeUpdates != null ? attributeUpdates.stream().map(FacetAttributeUpdate::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributeUpdates(Collection<FacetAttributeUpdate> attributeUpdates) {
            this.attributeUpdates = FacetAttributeUpdateListCopier.copy(attributeUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeUpdates(FacetAttributeUpdate... attributeUpdates) {
            attributeUpdates(Arrays.asList(attributeUpdates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeUpdates(Consumer<FacetAttributeUpdate.Builder>... attributeUpdates) {
            attributeUpdates(Stream.of(attributeUpdates).map(c -> FacetAttributeUpdate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAttributeUpdates(Collection<FacetAttributeUpdate.BuilderImpl> attributeUpdates) {
            this.attributeUpdates = FacetAttributeUpdateListCopier.copyFromBuilder(attributeUpdates);
        }

        public final String getObjectType() {
            return objectType;
        }

        @Override
        public final Builder objectType(String objectType) {
            this.objectType = objectType;
            return this;
        }

        @Override
        public final Builder objectType(ObjectType objectType) {
            this.objectType(objectType == null ? null : objectType.toString());
            return this;
        }

        public final void setObjectType(String objectType) {
            this.objectType = objectType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFacetRequest build() {
            return new UpdateFacetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
