/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the typed links structure and its attributes. To create a typed link facet, use the
 * <a>CreateTypedLinkFacet</a> API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TypedLinkFacet implements SdkPojo, Serializable, ToCopyableBuilder<TypedLinkFacet.Builder, TypedLinkFacet> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(TypedLinkFacet::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<TypedLinkAttributeDefinition>> ATTRIBUTES_FIELD = SdkField
            .<List<TypedLinkAttributeDefinition>> builder(MarshallingType.LIST)
            .memberName("Attributes")
            .getter(getter(TypedLinkFacet::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TypedLinkAttributeDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(TypedLinkAttributeDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> IDENTITY_ATTRIBUTE_ORDER_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("IdentityAttributeOrder")
            .getter(getter(TypedLinkFacet::identityAttributeOrder))
            .setter(setter(Builder::identityAttributeOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityAttributeOrder").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ATTRIBUTES_FIELD,
            IDENTITY_ATTRIBUTE_ORDER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<TypedLinkAttributeDefinition> attributes;

    private final List<String> identityAttributeOrder;

    private TypedLinkFacet(BuilderImpl builder) {
        this.name = builder.name;
        this.attributes = builder.attributes;
        this.identityAttributeOrder = builder.identityAttributeOrder;
    }

    /**
     * <p>
     * The unique name of the typed link facet.
     * </p>
     * 
     * @return The unique name of the typed link facet.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns true if the Attributes property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A set of key-value pairs associated with the typed link. Typed link attributes are used when you have data values
     * that are related to the link itself, and not to one of the two objects being linked. Identity attributes also
     * serve to distinguish the link from others of the same type between the same objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A set of key-value pairs associated with the typed link. Typed link attributes are used when you have
     *         data values that are related to the link itself, and not to one of the two objects being linked. Identity
     *         attributes also serve to distinguish the link from others of the same type between the same objects.
     */
    public final List<TypedLinkAttributeDefinition> attributes() {
        return attributes;
    }

    /**
     * Returns true if the IdentityAttributeOrder property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasIdentityAttributeOrder() {
        return identityAttributeOrder != null && !(identityAttributeOrder instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The set of attributes that distinguish links made from this facet from each other, in the order of significance.
     * Listing typed links can filter on the values of these attributes. See <a>ListOutgoingTypedLinks</a> and
     * <a>ListIncomingTypedLinks</a> for details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIdentityAttributeOrder()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The set of attributes that distinguish links made from this facet from each other, in the order of
     *         significance. Listing typed links can filter on the values of these attributes. See
     *         <a>ListOutgoingTypedLinks</a> and <a>ListIncomingTypedLinks</a> for details.
     */
    public final List<String> identityAttributeOrder() {
        return identityAttributeOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasIdentityAttributeOrder() ? identityAttributeOrder() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypedLinkFacet)) {
            return false;
        }
        TypedLinkFacet other = (TypedLinkFacet) obj;
        return Objects.equals(name(), other.name()) && hasAttributes() == other.hasAttributes()
                && Objects.equals(attributes(), other.attributes())
                && hasIdentityAttributeOrder() == other.hasIdentityAttributeOrder()
                && Objects.equals(identityAttributeOrder(), other.identityAttributeOrder());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TypedLinkFacet").add("Name", name()).add("Attributes", hasAttributes() ? attributes() : null)
                .add("IdentityAttributeOrder", hasIdentityAttributeOrder() ? identityAttributeOrder() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "IdentityAttributeOrder":
            return Optional.ofNullable(clazz.cast(identityAttributeOrder()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TypedLinkFacet, T> g) {
        return obj -> g.apply((TypedLinkFacet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TypedLinkFacet> {
        /**
         * <p>
         * The unique name of the typed link facet.
         * </p>
         * 
         * @param name
         *        The unique name of the typed link facet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A set of key-value pairs associated with the typed link. Typed link attributes are used when you have data
         * values that are related to the link itself, and not to one of the two objects being linked. Identity
         * attributes also serve to distinguish the link from others of the same type between the same objects.
         * </p>
         * 
         * @param attributes
         *        A set of key-value pairs associated with the typed link. Typed link attributes are used when you have
         *        data values that are related to the link itself, and not to one of the two objects being linked.
         *        Identity attributes also serve to distinguish the link from others of the same type between the same
         *        objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Collection<TypedLinkAttributeDefinition> attributes);

        /**
         * <p>
         * A set of key-value pairs associated with the typed link. Typed link attributes are used when you have data
         * values that are related to the link itself, and not to one of the two objects being linked. Identity
         * attributes also serve to distinguish the link from others of the same type between the same objects.
         * </p>
         * 
         * @param attributes
         *        A set of key-value pairs associated with the typed link. Typed link attributes are used when you have
         *        data values that are related to the link itself, and not to one of the two objects being linked.
         *        Identity attributes also serve to distinguish the link from others of the same type between the same
         *        objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(TypedLinkAttributeDefinition... attributes);

        /**
         * <p>
         * A set of key-value pairs associated with the typed link. Typed link attributes are used when you have data
         * values that are related to the link itself, and not to one of the two objects being linked. Identity
         * attributes also serve to distinguish the link from others of the same type between the same objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TypedLinkAttributeDefinition>.Builder}
         * avoiding the need to create one manually via {@link List<TypedLinkAttributeDefinition>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TypedLinkAttributeDefinition>.Builder#build()} is called
         * immediately and its result is passed to {@link #attributes(List<TypedLinkAttributeDefinition>)}.
         * 
         * @param attributes
         *        a consumer that will call methods on {@link List<TypedLinkAttributeDefinition>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributes(List<TypedLinkAttributeDefinition>)
         */
        Builder attributes(Consumer<TypedLinkAttributeDefinition.Builder>... attributes);

        /**
         * <p>
         * The set of attributes that distinguish links made from this facet from each other, in the order of
         * significance. Listing typed links can filter on the values of these attributes. See
         * <a>ListOutgoingTypedLinks</a> and <a>ListIncomingTypedLinks</a> for details.
         * </p>
         * 
         * @param identityAttributeOrder
         *        The set of attributes that distinguish links made from this facet from each other, in the order of
         *        significance. Listing typed links can filter on the values of these attributes. See
         *        <a>ListOutgoingTypedLinks</a> and <a>ListIncomingTypedLinks</a> for details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityAttributeOrder(Collection<String> identityAttributeOrder);

        /**
         * <p>
         * The set of attributes that distinguish links made from this facet from each other, in the order of
         * significance. Listing typed links can filter on the values of these attributes. See
         * <a>ListOutgoingTypedLinks</a> and <a>ListIncomingTypedLinks</a> for details.
         * </p>
         * 
         * @param identityAttributeOrder
         *        The set of attributes that distinguish links made from this facet from each other, in the order of
         *        significance. Listing typed links can filter on the values of these attributes. See
         *        <a>ListOutgoingTypedLinks</a> and <a>ListIncomingTypedLinks</a> for details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityAttributeOrder(String... identityAttributeOrder);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<TypedLinkAttributeDefinition> attributes = DefaultSdkAutoConstructList.getInstance();

        private List<String> identityAttributeOrder = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TypedLinkFacet model) {
            name(model.name);
            attributes(model.attributes);
            identityAttributeOrder(model.identityAttributeOrder);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<TypedLinkAttributeDefinition.Builder> getAttributes() {
            if (attributes instanceof SdkAutoConstructList) {
                return null;
            }
            return attributes != null ? attributes.stream().map(TypedLinkAttributeDefinition::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributes(Collection<TypedLinkAttributeDefinition> attributes) {
            this.attributes = TypedLinkAttributeDefinitionListCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(TypedLinkAttributeDefinition... attributes) {
            attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<TypedLinkAttributeDefinition.Builder>... attributes) {
            attributes(Stream.of(attributes).map(c -> TypedLinkAttributeDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAttributes(Collection<TypedLinkAttributeDefinition.BuilderImpl> attributes) {
            this.attributes = TypedLinkAttributeDefinitionListCopier.copyFromBuilder(attributes);
        }

        public final Collection<String> getIdentityAttributeOrder() {
            if (identityAttributeOrder instanceof SdkAutoConstructList) {
                return null;
            }
            return identityAttributeOrder;
        }

        @Override
        public final Builder identityAttributeOrder(Collection<String> identityAttributeOrder) {
            this.identityAttributeOrder = AttributeNameListCopier.copy(identityAttributeOrder);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityAttributeOrder(String... identityAttributeOrder) {
            identityAttributeOrder(Arrays.asList(identityAttributeOrder));
            return this;
        }

        public final void setIdentityAttributeOrder(Collection<String> identityAttributeOrder) {
            this.identityAttributeOrder = AttributeNameListCopier.copy(identityAttributeOrder);
        }

        @Override
        public TypedLinkFacet build() {
            return new TypedLinkFacet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
