/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A facet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SchemaFacet implements SdkPojo, Serializable, ToCopyableBuilder<SchemaFacet.Builder, SchemaFacet> {
    private static final SdkField<String> SCHEMA_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaArn").getter(getter(SchemaFacet::schemaArn)).setter(setter(Builder::schemaArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaArn").build()).build();

    private static final SdkField<String> FACET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FacetName").getter(getter(SchemaFacet::facetName)).setter(setter(Builder::facetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FacetName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_ARN_FIELD,
            FACET_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String schemaArn;

    private final String facetName;

    private SchemaFacet(BuilderImpl builder) {
        this.schemaArn = builder.schemaArn;
        this.facetName = builder.facetName;
    }

    /**
     * <p>
     * The ARN of the schema that contains the facet with no minor component. See <a>arns</a> and <a
     * href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_inplaceschemaupgrade.html"
     * >In-Place Schema Upgrade</a> for a description of when to provide minor versions.
     * </p>
     * 
     * @return The ARN of the schema that contains the facet with no minor component. See <a>arns</a> and <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_inplaceschemaupgrade.html"
     *         >In-Place Schema Upgrade</a> for a description of when to provide minor versions.
     */
    public final String schemaArn() {
        return schemaArn;
    }

    /**
     * <p>
     * The name of the facet.
     * </p>
     * 
     * @return The name of the facet.
     */
    public final String facetName() {
        return facetName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(schemaArn());
        hashCode = 31 * hashCode + Objects.hashCode(facetName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaFacet)) {
            return false;
        }
        SchemaFacet other = (SchemaFacet) obj;
        return Objects.equals(schemaArn(), other.schemaArn()) && Objects.equals(facetName(), other.facetName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SchemaFacet").add("SchemaArn", schemaArn()).add("FacetName", facetName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SchemaArn":
            return Optional.ofNullable(clazz.cast(schemaArn()));
        case "FacetName":
            return Optional.ofNullable(clazz.cast(facetName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SchemaFacet, T> g) {
        return obj -> g.apply((SchemaFacet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SchemaFacet> {
        /**
         * <p>
         * The ARN of the schema that contains the facet with no minor component. See <a>arns</a> and <a
         * href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_inplaceschemaupgrade.html"
         * >In-Place Schema Upgrade</a> for a description of when to provide minor versions.
         * </p>
         * 
         * @param schemaArn
         *        The ARN of the schema that contains the facet with no minor component. See <a>arns</a> and <a href=
         *        "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_inplaceschemaupgrade.html"
         *        >In-Place Schema Upgrade</a> for a description of when to provide minor versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaArn(String schemaArn);

        /**
         * <p>
         * The name of the facet.
         * </p>
         * 
         * @param facetName
         *        The name of the facet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder facetName(String facetName);
    }

    static final class BuilderImpl implements Builder {
        private String schemaArn;

        private String facetName;

        private BuilderImpl() {
        }

        private BuilderImpl(SchemaFacet model) {
            schemaArn(model.schemaArn);
            facetName(model.facetName);
        }

        public final String getSchemaArn() {
            return schemaArn;
        }

        @Override
        public final Builder schemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
            return this;
        }

        public final void setSchemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
        }

        public final String getFacetName() {
            return facetName;
        }

        @Override
        public final Builder facetName(String facetName) {
            this.facetName = facetName;
            return this;
        }

        public final void setFacetName(String facetName) {
            this.facetName = facetName;
        }

        @Override
        public SchemaFacet build() {
            return new SchemaFacet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
