/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListObjectParentsResponse extends CloudDirectoryResponse implements
        ToCopyableBuilder<ListObjectParentsResponse.Builder, ListObjectParentsResponse> {
    private static final SdkField<Map<String, String>> PARENTS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Parents")
            .getter(getter(ListObjectParentsResponse::parents))
            .setter(setter(Builder::parents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parents").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListObjectParentsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<ObjectIdentifierAndLinkNameTuple>> PARENT_LINKS_FIELD = SdkField
            .<List<ObjectIdentifierAndLinkNameTuple>> builder(MarshallingType.LIST)
            .memberName("ParentLinks")
            .getter(getter(ListObjectParentsResponse::parentLinks))
            .setter(setter(Builder::parentLinks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentLinks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ObjectIdentifierAndLinkNameTuple> builder(MarshallingType.SDK_POJO)
                                            .constructor(ObjectIdentifierAndLinkNameTuple::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARENTS_FIELD,
            NEXT_TOKEN_FIELD, PARENT_LINKS_FIELD));

    private final Map<String, String> parents;

    private final String nextToken;

    private final List<ObjectIdentifierAndLinkNameTuple> parentLinks;

    private ListObjectParentsResponse(BuilderImpl builder) {
        super(builder);
        this.parents = builder.parents;
        this.nextToken = builder.nextToken;
        this.parentLinks = builder.parentLinks;
    }

    /**
     * Returns true if the Parents property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasParents() {
        return parents != null && !(parents instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The parent structure, which is a map with key as the <code>ObjectIdentifier</code> and LinkName as the value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasParents()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The parent structure, which is a map with key as the <code>ObjectIdentifier</code> and LinkName as the
     *         value.
     */
    public final Map<String, String> parents() {
        return parents;
    }

    /**
     * <p>
     * The pagination token.
     * </p>
     * 
     * @return The pagination token.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the ParentLinks property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasParentLinks() {
        return parentLinks != null && !(parentLinks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns a list of parent reference and LinkName Tuples.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasParentLinks()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Returns a list of parent reference and LinkName Tuples.
     */
    public final List<ObjectIdentifierAndLinkNameTuple> parentLinks() {
        return parentLinks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasParents() ? parents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasParentLinks() ? parentLinks() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListObjectParentsResponse)) {
            return false;
        }
        ListObjectParentsResponse other = (ListObjectParentsResponse) obj;
        return hasParents() == other.hasParents() && Objects.equals(parents(), other.parents())
                && Objects.equals(nextToken(), other.nextToken()) && hasParentLinks() == other.hasParentLinks()
                && Objects.equals(parentLinks(), other.parentLinks());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListObjectParentsResponse").add("Parents", hasParents() ? parents() : null)
                .add("NextToken", nextToken()).add("ParentLinks", hasParentLinks() ? parentLinks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Parents":
            return Optional.ofNullable(clazz.cast(parents()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ParentLinks":
            return Optional.ofNullable(clazz.cast(parentLinks()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListObjectParentsResponse, T> g) {
        return obj -> g.apply((ListObjectParentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudDirectoryResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListObjectParentsResponse> {
        /**
         * <p>
         * The parent structure, which is a map with key as the <code>ObjectIdentifier</code> and LinkName as the value.
         * </p>
         * 
         * @param parents
         *        The parent structure, which is a map with key as the <code>ObjectIdentifier</code> and LinkName as the
         *        value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parents(Map<String, String> parents);

        /**
         * <p>
         * The pagination token.
         * </p>
         * 
         * @param nextToken
         *        The pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Returns a list of parent reference and LinkName Tuples.
         * </p>
         * 
         * @param parentLinks
         *        Returns a list of parent reference and LinkName Tuples.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentLinks(Collection<ObjectIdentifierAndLinkNameTuple> parentLinks);

        /**
         * <p>
         * Returns a list of parent reference and LinkName Tuples.
         * </p>
         * 
         * @param parentLinks
         *        Returns a list of parent reference and LinkName Tuples.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentLinks(ObjectIdentifierAndLinkNameTuple... parentLinks);

        /**
         * <p>
         * Returns a list of parent reference and LinkName Tuples.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ObjectIdentifierAndLinkNameTuple>.Builder}
         * avoiding the need to create one manually via {@link List<ObjectIdentifierAndLinkNameTuple>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ObjectIdentifierAndLinkNameTuple>.Builder#build()} is called
         * immediately and its result is passed to {@link #parentLinks(List<ObjectIdentifierAndLinkNameTuple>)}.
         * 
         * @param parentLinks
         *        a consumer that will call methods on {@link List<ObjectIdentifierAndLinkNameTuple>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parentLinks(List<ObjectIdentifierAndLinkNameTuple>)
         */
        Builder parentLinks(Consumer<ObjectIdentifierAndLinkNameTuple.Builder>... parentLinks);
    }

    static final class BuilderImpl extends CloudDirectoryResponse.BuilderImpl implements Builder {
        private Map<String, String> parents = DefaultSdkAutoConstructMap.getInstance();

        private String nextToken;

        private List<ObjectIdentifierAndLinkNameTuple> parentLinks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListObjectParentsResponse model) {
            super(model);
            parents(model.parents);
            nextToken(model.nextToken);
            parentLinks(model.parentLinks);
        }

        public final Map<String, String> getParents() {
            if (parents instanceof SdkAutoConstructMap) {
                return null;
            }
            return parents;
        }

        @Override
        public final Builder parents(Map<String, String> parents) {
            this.parents = ObjectIdentifierToLinkNameMapCopier.copy(parents);
            return this;
        }

        public final void setParents(Map<String, String> parents) {
            this.parents = ObjectIdentifierToLinkNameMapCopier.copy(parents);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<ObjectIdentifierAndLinkNameTuple.Builder> getParentLinks() {
            if (parentLinks instanceof SdkAutoConstructList) {
                return null;
            }
            return parentLinks != null ? parentLinks.stream().map(ObjectIdentifierAndLinkNameTuple::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parentLinks(Collection<ObjectIdentifierAndLinkNameTuple> parentLinks) {
            this.parentLinks = ObjectIdentifierAndLinkNameListCopier.copy(parentLinks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parentLinks(ObjectIdentifierAndLinkNameTuple... parentLinks) {
            parentLinks(Arrays.asList(parentLinks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parentLinks(Consumer<ObjectIdentifierAndLinkNameTuple.Builder>... parentLinks) {
            parentLinks(Stream.of(parentLinks).map(c -> ObjectIdentifierAndLinkNameTuple.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setParentLinks(Collection<ObjectIdentifierAndLinkNameTuple.BuilderImpl> parentLinks) {
            this.parentLinks = ObjectIdentifierAndLinkNameListCopier.copyFromBuilder(parentLinks);
        }

        @Override
        public ListObjectParentsResponse build() {
            return new ListObjectParentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
