/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListIndexRequest extends CloudDirectoryRequest implements
        ToCopyableBuilder<ListIndexRequest.Builder, ListIndexRequest> {
    private static final SdkField<String> DIRECTORY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryArn").getter(getter(ListIndexRequest::directoryArn)).setter(setter(Builder::directoryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-data-partition").build())
            .build();

    private static final SdkField<List<ObjectAttributeRange>> RANGES_ON_INDEXED_VALUES_FIELD = SdkField
            .<List<ObjectAttributeRange>> builder(MarshallingType.LIST)
            .memberName("RangesOnIndexedValues")
            .getter(getter(ListIndexRequest::rangesOnIndexedValues))
            .setter(setter(Builder::rangesOnIndexedValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RangesOnIndexedValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ObjectAttributeRange> builder(MarshallingType.SDK_POJO)
                                            .constructor(ObjectAttributeRange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ObjectReference> INDEX_REFERENCE_FIELD = SdkField
            .<ObjectReference> builder(MarshallingType.SDK_POJO).memberName("IndexReference")
            .getter(getter(ListIndexRequest::indexReference)).setter(setter(Builder::indexReference))
            .constructor(ObjectReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexReference").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListIndexRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListIndexRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> CONSISTENCY_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConsistencyLevel").getter(getter(ListIndexRequest::consistencyLevelAsString))
            .setter(setter(Builder::consistencyLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-consistency-level").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ARN_FIELD,
            RANGES_ON_INDEXED_VALUES_FIELD, INDEX_REFERENCE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, CONSISTENCY_LEVEL_FIELD));

    private final String directoryArn;

    private final List<ObjectAttributeRange> rangesOnIndexedValues;

    private final ObjectReference indexReference;

    private final Integer maxResults;

    private final String nextToken;

    private final String consistencyLevel;

    private ListIndexRequest(BuilderImpl builder) {
        super(builder);
        this.directoryArn = builder.directoryArn;
        this.rangesOnIndexedValues = builder.rangesOnIndexedValues;
        this.indexReference = builder.indexReference;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.consistencyLevel = builder.consistencyLevel;
    }

    /**
     * <p>
     * The ARN of the directory that the index exists in.
     * </p>
     * 
     * @return The ARN of the directory that the index exists in.
     */
    public final String directoryArn() {
        return directoryArn;
    }

    /**
     * Returns true if the RangesOnIndexedValues property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasRangesOnIndexedValues() {
        return rangesOnIndexedValues != null && !(rangesOnIndexedValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the ranges of indexed values that you want to query.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRangesOnIndexedValues()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies the ranges of indexed values that you want to query.
     */
    public final List<ObjectAttributeRange> rangesOnIndexedValues() {
        return rangesOnIndexedValues;
    }

    /**
     * <p>
     * The reference to the index to list.
     * </p>
     * 
     * @return The reference to the index to list.
     */
    public final ObjectReference indexReference() {
        return indexReference;
    }

    /**
     * <p>
     * The maximum number of objects in a single page to retrieve from the index during a request. For more information,
     * see <a href="http://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Amazon Cloud Directory
     * Limits</a>.
     * </p>
     * 
     * @return The maximum number of objects in a single page to retrieve from the index during a request. For more
     *         information, see <a
     *         href="http://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Amazon Cloud Directory
     *         Limits</a>.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The pagination token.
     * </p>
     * 
     * @return The pagination token.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The consistency level to execute the request at.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #consistencyLevel}
     * will return {@link ConsistencyLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #consistencyLevelAsString}.
     * </p>
     * 
     * @return The consistency level to execute the request at.
     * @see ConsistencyLevel
     */
    public final ConsistencyLevel consistencyLevel() {
        return ConsistencyLevel.fromValue(consistencyLevel);
    }

    /**
     * <p>
     * The consistency level to execute the request at.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #consistencyLevel}
     * will return {@link ConsistencyLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #consistencyLevelAsString}.
     * </p>
     * 
     * @return The consistency level to execute the request at.
     * @see ConsistencyLevel
     */
    public final String consistencyLevelAsString() {
        return consistencyLevel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasRangesOnIndexedValues() ? rangesOnIndexedValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(indexReference());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(consistencyLevelAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIndexRequest)) {
            return false;
        }
        ListIndexRequest other = (ListIndexRequest) obj;
        return Objects.equals(directoryArn(), other.directoryArn())
                && hasRangesOnIndexedValues() == other.hasRangesOnIndexedValues()
                && Objects.equals(rangesOnIndexedValues(), other.rangesOnIndexedValues())
                && Objects.equals(indexReference(), other.indexReference()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(consistencyLevelAsString(), other.consistencyLevelAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListIndexRequest").add("DirectoryArn", directoryArn())
                .add("RangesOnIndexedValues", hasRangesOnIndexedValues() ? rangesOnIndexedValues() : null)
                .add("IndexReference", indexReference()).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("ConsistencyLevel", consistencyLevelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryArn":
            return Optional.ofNullable(clazz.cast(directoryArn()));
        case "RangesOnIndexedValues":
            return Optional.ofNullable(clazz.cast(rangesOnIndexedValues()));
        case "IndexReference":
            return Optional.ofNullable(clazz.cast(indexReference()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ConsistencyLevel":
            return Optional.ofNullable(clazz.cast(consistencyLevelAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListIndexRequest, T> g) {
        return obj -> g.apply((ListIndexRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudDirectoryRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListIndexRequest> {
        /**
         * <p>
         * The ARN of the directory that the index exists in.
         * </p>
         * 
         * @param directoryArn
         *        The ARN of the directory that the index exists in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryArn(String directoryArn);

        /**
         * <p>
         * Specifies the ranges of indexed values that you want to query.
         * </p>
         * 
         * @param rangesOnIndexedValues
         *        Specifies the ranges of indexed values that you want to query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rangesOnIndexedValues(Collection<ObjectAttributeRange> rangesOnIndexedValues);

        /**
         * <p>
         * Specifies the ranges of indexed values that you want to query.
         * </p>
         * 
         * @param rangesOnIndexedValues
         *        Specifies the ranges of indexed values that you want to query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rangesOnIndexedValues(ObjectAttributeRange... rangesOnIndexedValues);

        /**
         * <p>
         * Specifies the ranges of indexed values that you want to query.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ObjectAttributeRange>.Builder} avoiding the
         * need to create one manually via {@link List<ObjectAttributeRange>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ObjectAttributeRange>.Builder#build()} is called immediately
         * and its result is passed to {@link #rangesOnIndexedValues(List<ObjectAttributeRange>)}.
         * 
         * @param rangesOnIndexedValues
         *        a consumer that will call methods on {@link List<ObjectAttributeRange>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rangesOnIndexedValues(List<ObjectAttributeRange>)
         */
        Builder rangesOnIndexedValues(Consumer<ObjectAttributeRange.Builder>... rangesOnIndexedValues);

        /**
         * <p>
         * The reference to the index to list.
         * </p>
         * 
         * @param indexReference
         *        The reference to the index to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexReference(ObjectReference indexReference);

        /**
         * <p>
         * The reference to the index to list.
         * </p>
         * This is a convenience that creates an instance of the {@link ObjectReference.Builder} avoiding the need to
         * create one manually via {@link ObjectReference#builder()}.
         *
         * When the {@link Consumer} completes, {@link ObjectReference.Builder#build()} is called immediately and its
         * result is passed to {@link #indexReference(ObjectReference)}.
         * 
         * @param indexReference
         *        a consumer that will call methods on {@link ObjectReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #indexReference(ObjectReference)
         */
        default Builder indexReference(Consumer<ObjectReference.Builder> indexReference) {
            return indexReference(ObjectReference.builder().applyMutation(indexReference).build());
        }

        /**
         * <p>
         * The maximum number of objects in a single page to retrieve from the index during a request. For more
         * information, see <a href="http://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Amazon
         * Cloud Directory Limits</a>.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of objects in a single page to retrieve from the index during a request. For more
         *        information, see <a
         *        href="http://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Amazon Cloud
         *        Directory Limits</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The pagination token.
         * </p>
         * 
         * @param nextToken
         *        The pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The consistency level to execute the request at.
         * </p>
         * 
         * @param consistencyLevel
         *        The consistency level to execute the request at.
         * @see ConsistencyLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConsistencyLevel
         */
        Builder consistencyLevel(String consistencyLevel);

        /**
         * <p>
         * The consistency level to execute the request at.
         * </p>
         * 
         * @param consistencyLevel
         *        The consistency level to execute the request at.
         * @see ConsistencyLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConsistencyLevel
         */
        Builder consistencyLevel(ConsistencyLevel consistencyLevel);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudDirectoryRequest.BuilderImpl implements Builder {
        private String directoryArn;

        private List<ObjectAttributeRange> rangesOnIndexedValues = DefaultSdkAutoConstructList.getInstance();

        private ObjectReference indexReference;

        private Integer maxResults;

        private String nextToken;

        private String consistencyLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIndexRequest model) {
            super(model);
            directoryArn(model.directoryArn);
            rangesOnIndexedValues(model.rangesOnIndexedValues);
            indexReference(model.indexReference);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            consistencyLevel(model.consistencyLevel);
        }

        public final String getDirectoryArn() {
            return directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        public final Collection<ObjectAttributeRange.Builder> getRangesOnIndexedValues() {
            if (rangesOnIndexedValues instanceof SdkAutoConstructList) {
                return null;
            }
            return rangesOnIndexedValues != null ? rangesOnIndexedValues.stream().map(ObjectAttributeRange::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rangesOnIndexedValues(Collection<ObjectAttributeRange> rangesOnIndexedValues) {
            this.rangesOnIndexedValues = ObjectAttributeRangeListCopier.copy(rangesOnIndexedValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rangesOnIndexedValues(ObjectAttributeRange... rangesOnIndexedValues) {
            rangesOnIndexedValues(Arrays.asList(rangesOnIndexedValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rangesOnIndexedValues(Consumer<ObjectAttributeRange.Builder>... rangesOnIndexedValues) {
            rangesOnIndexedValues(Stream.of(rangesOnIndexedValues)
                    .map(c -> ObjectAttributeRange.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRangesOnIndexedValues(Collection<ObjectAttributeRange.BuilderImpl> rangesOnIndexedValues) {
            this.rangesOnIndexedValues = ObjectAttributeRangeListCopier.copyFromBuilder(rangesOnIndexedValues);
        }

        public final ObjectReference.Builder getIndexReference() {
            return indexReference != null ? indexReference.toBuilder() : null;
        }

        @Override
        public final Builder indexReference(ObjectReference indexReference) {
            this.indexReference = indexReference;
            return this;
        }

        public final void setIndexReference(ObjectReference.BuilderImpl indexReference) {
            this.indexReference = indexReference != null ? indexReference.build() : null;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getConsistencyLevel() {
            return consistencyLevel;
        }

        @Override
        public final Builder consistencyLevel(String consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
            return this;
        }

        @Override
        public final Builder consistencyLevel(ConsistencyLevel consistencyLevel) {
            this.consistencyLevel(consistencyLevel == null ? null : consistencyLevel.toString());
            return this;
        }

        public final void setConsistencyLevel(String consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListIndexRequest build() {
            return new ListIndexRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
