/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateIndexRequest extends CloudDirectoryRequest implements
        ToCopyableBuilder<CreateIndexRequest.Builder, CreateIndexRequest> {
    private static final SdkField<String> DIRECTORY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryArn").getter(getter(CreateIndexRequest::directoryArn)).setter(setter(Builder::directoryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-data-partition").build())
            .build();

    private static final SdkField<List<AttributeKey>> ORDERED_INDEXED_ATTRIBUTE_LIST_FIELD = SdkField
            .<List<AttributeKey>> builder(MarshallingType.LIST)
            .memberName("OrderedIndexedAttributeList")
            .getter(getter(CreateIndexRequest::orderedIndexedAttributeList))
            .setter(setter(Builder::orderedIndexedAttributeList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderedIndexedAttributeList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttributeKey> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeKey::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> IS_UNIQUE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsUnique").getter(getter(CreateIndexRequest::isUnique)).setter(setter(Builder::isUnique))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsUnique").build()).build();

    private static final SdkField<ObjectReference> PARENT_REFERENCE_FIELD = SdkField
            .<ObjectReference> builder(MarshallingType.SDK_POJO).memberName("ParentReference")
            .getter(getter(CreateIndexRequest::parentReference)).setter(setter(Builder::parentReference))
            .constructor(ObjectReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentReference").build()).build();

    private static final SdkField<String> LINK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LinkName").getter(getter(CreateIndexRequest::linkName)).setter(setter(Builder::linkName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ARN_FIELD,
            ORDERED_INDEXED_ATTRIBUTE_LIST_FIELD, IS_UNIQUE_FIELD, PARENT_REFERENCE_FIELD, LINK_NAME_FIELD));

    private final String directoryArn;

    private final List<AttributeKey> orderedIndexedAttributeList;

    private final Boolean isUnique;

    private final ObjectReference parentReference;

    private final String linkName;

    private CreateIndexRequest(BuilderImpl builder) {
        super(builder);
        this.directoryArn = builder.directoryArn;
        this.orderedIndexedAttributeList = builder.orderedIndexedAttributeList;
        this.isUnique = builder.isUnique;
        this.parentReference = builder.parentReference;
        this.linkName = builder.linkName;
    }

    /**
     * <p>
     * The ARN of the directory where the index should be created.
     * </p>
     * 
     * @return The ARN of the directory where the index should be created.
     */
    public final String directoryArn() {
        return directoryArn;
    }

    /**
     * Returns true if the OrderedIndexedAttributeList property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasOrderedIndexedAttributeList() {
        return orderedIndexedAttributeList != null && !(orderedIndexedAttributeList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the attributes that should be indexed on. Currently only a single attribute is supported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOrderedIndexedAttributeList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies the attributes that should be indexed on. Currently only a single attribute is supported.
     */
    public final List<AttributeKey> orderedIndexedAttributeList() {
        return orderedIndexedAttributeList;
    }

    /**
     * <p>
     * Indicates whether the attribute that is being indexed has unique values or not.
     * </p>
     * 
     * @return Indicates whether the attribute that is being indexed has unique values or not.
     */
    public final Boolean isUnique() {
        return isUnique;
    }

    /**
     * <p>
     * A reference to the parent object that contains the index object.
     * </p>
     * 
     * @return A reference to the parent object that contains the index object.
     */
    public final ObjectReference parentReference() {
        return parentReference;
    }

    /**
     * <p>
     * The name of the link between the parent object and the index object.
     * </p>
     * 
     * @return The name of the link between the parent object and the index object.
     */
    public final String linkName() {
        return linkName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasOrderedIndexedAttributeList() ? orderedIndexedAttributeList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(isUnique());
        hashCode = 31 * hashCode + Objects.hashCode(parentReference());
        hashCode = 31 * hashCode + Objects.hashCode(linkName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIndexRequest)) {
            return false;
        }
        CreateIndexRequest other = (CreateIndexRequest) obj;
        return Objects.equals(directoryArn(), other.directoryArn())
                && hasOrderedIndexedAttributeList() == other.hasOrderedIndexedAttributeList()
                && Objects.equals(orderedIndexedAttributeList(), other.orderedIndexedAttributeList())
                && Objects.equals(isUnique(), other.isUnique()) && Objects.equals(parentReference(), other.parentReference())
                && Objects.equals(linkName(), other.linkName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateIndexRequest").add("DirectoryArn", directoryArn())
                .add("OrderedIndexedAttributeList", hasOrderedIndexedAttributeList() ? orderedIndexedAttributeList() : null)
                .add("IsUnique", isUnique()).add("ParentReference", parentReference()).add("LinkName", linkName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryArn":
            return Optional.ofNullable(clazz.cast(directoryArn()));
        case "OrderedIndexedAttributeList":
            return Optional.ofNullable(clazz.cast(orderedIndexedAttributeList()));
        case "IsUnique":
            return Optional.ofNullable(clazz.cast(isUnique()));
        case "ParentReference":
            return Optional.ofNullable(clazz.cast(parentReference()));
        case "LinkName":
            return Optional.ofNullable(clazz.cast(linkName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateIndexRequest, T> g) {
        return obj -> g.apply((CreateIndexRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudDirectoryRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateIndexRequest> {
        /**
         * <p>
         * The ARN of the directory where the index should be created.
         * </p>
         * 
         * @param directoryArn
         *        The ARN of the directory where the index should be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryArn(String directoryArn);

        /**
         * <p>
         * Specifies the attributes that should be indexed on. Currently only a single attribute is supported.
         * </p>
         * 
         * @param orderedIndexedAttributeList
         *        Specifies the attributes that should be indexed on. Currently only a single attribute is supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderedIndexedAttributeList(Collection<AttributeKey> orderedIndexedAttributeList);

        /**
         * <p>
         * Specifies the attributes that should be indexed on. Currently only a single attribute is supported.
         * </p>
         * 
         * @param orderedIndexedAttributeList
         *        Specifies the attributes that should be indexed on. Currently only a single attribute is supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderedIndexedAttributeList(AttributeKey... orderedIndexedAttributeList);

        /**
         * <p>
         * Specifies the attributes that should be indexed on. Currently only a single attribute is supported.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AttributeKey>.Builder} avoiding the need to
         * create one manually via {@link List<AttributeKey>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AttributeKey>.Builder#build()} is called immediately and its
         * result is passed to {@link #orderedIndexedAttributeList(List<AttributeKey>)}.
         * 
         * @param orderedIndexedAttributeList
         *        a consumer that will call methods on {@link List<AttributeKey>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #orderedIndexedAttributeList(List<AttributeKey>)
         */
        Builder orderedIndexedAttributeList(Consumer<AttributeKey.Builder>... orderedIndexedAttributeList);

        /**
         * <p>
         * Indicates whether the attribute that is being indexed has unique values or not.
         * </p>
         * 
         * @param isUnique
         *        Indicates whether the attribute that is being indexed has unique values or not.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isUnique(Boolean isUnique);

        /**
         * <p>
         * A reference to the parent object that contains the index object.
         * </p>
         * 
         * @param parentReference
         *        A reference to the parent object that contains the index object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentReference(ObjectReference parentReference);

        /**
         * <p>
         * A reference to the parent object that contains the index object.
         * </p>
         * This is a convenience that creates an instance of the {@link ObjectReference.Builder} avoiding the need to
         * create one manually via {@link ObjectReference#builder()}.
         *
         * When the {@link Consumer} completes, {@link ObjectReference.Builder#build()} is called immediately and its
         * result is passed to {@link #parentReference(ObjectReference)}.
         * 
         * @param parentReference
         *        a consumer that will call methods on {@link ObjectReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parentReference(ObjectReference)
         */
        default Builder parentReference(Consumer<ObjectReference.Builder> parentReference) {
            return parentReference(ObjectReference.builder().applyMutation(parentReference).build());
        }

        /**
         * <p>
         * The name of the link between the parent object and the index object.
         * </p>
         * 
         * @param linkName
         *        The name of the link between the parent object and the index object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkName(String linkName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudDirectoryRequest.BuilderImpl implements Builder {
        private String directoryArn;

        private List<AttributeKey> orderedIndexedAttributeList = DefaultSdkAutoConstructList.getInstance();

        private Boolean isUnique;

        private ObjectReference parentReference;

        private String linkName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIndexRequest model) {
            super(model);
            directoryArn(model.directoryArn);
            orderedIndexedAttributeList(model.orderedIndexedAttributeList);
            isUnique(model.isUnique);
            parentReference(model.parentReference);
            linkName(model.linkName);
        }

        public final String getDirectoryArn() {
            return directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        public final Collection<AttributeKey.Builder> getOrderedIndexedAttributeList() {
            if (orderedIndexedAttributeList instanceof SdkAutoConstructList) {
                return null;
            }
            return orderedIndexedAttributeList != null ? orderedIndexedAttributeList.stream().map(AttributeKey::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder orderedIndexedAttributeList(Collection<AttributeKey> orderedIndexedAttributeList) {
            this.orderedIndexedAttributeList = AttributeKeyListCopier.copy(orderedIndexedAttributeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderedIndexedAttributeList(AttributeKey... orderedIndexedAttributeList) {
            orderedIndexedAttributeList(Arrays.asList(orderedIndexedAttributeList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderedIndexedAttributeList(Consumer<AttributeKey.Builder>... orderedIndexedAttributeList) {
            orderedIndexedAttributeList(Stream.of(orderedIndexedAttributeList)
                    .map(c -> AttributeKey.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOrderedIndexedAttributeList(Collection<AttributeKey.BuilderImpl> orderedIndexedAttributeList) {
            this.orderedIndexedAttributeList = AttributeKeyListCopier.copyFromBuilder(orderedIndexedAttributeList);
        }

        public final Boolean getIsUnique() {
            return isUnique;
        }

        @Override
        public final Builder isUnique(Boolean isUnique) {
            this.isUnique = isUnique;
            return this;
        }

        public final void setIsUnique(Boolean isUnique) {
            this.isUnique = isUnique;
        }

        public final ObjectReference.Builder getParentReference() {
            return parentReference != null ? parentReference.toBuilder() : null;
        }

        @Override
        public final Builder parentReference(ObjectReference parentReference) {
            this.parentReference = parentReference;
            return this;
        }

        public final void setParentReference(ObjectReference.BuilderImpl parentReference) {
            this.parentReference = parentReference != null ? parentReference.build() : null;
        }

        public final String getLinkName() {
            return linkName;
        }

        @Override
        public final Builder linkName(String linkName) {
            this.linkName = linkName;
            return this;
        }

        public final void setLinkName(String linkName) {
            this.linkName = linkName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIndexRequest build() {
            return new CreateIndexRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
