/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A batch operation to remove a facet from an object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchRemoveFacetFromObject implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchRemoveFacetFromObject.Builder, BatchRemoveFacetFromObject> {
    private static final SdkField<SchemaFacet> SCHEMA_FACET_FIELD = SdkField.<SchemaFacet> builder(MarshallingType.SDK_POJO)
            .memberName("SchemaFacet").getter(getter(BatchRemoveFacetFromObject::schemaFacet))
            .setter(setter(Builder::schemaFacet)).constructor(SchemaFacet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaFacet").build()).build();

    private static final SdkField<ObjectReference> OBJECT_REFERENCE_FIELD = SdkField
            .<ObjectReference> builder(MarshallingType.SDK_POJO).memberName("ObjectReference")
            .getter(getter(BatchRemoveFacetFromObject::objectReference)).setter(setter(Builder::objectReference))
            .constructor(ObjectReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectReference").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_FACET_FIELD,
            OBJECT_REFERENCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final SchemaFacet schemaFacet;

    private final ObjectReference objectReference;

    private BatchRemoveFacetFromObject(BuilderImpl builder) {
        this.schemaFacet = builder.schemaFacet;
        this.objectReference = builder.objectReference;
    }

    /**
     * <p>
     * The facet to remove from the object.
     * </p>
     * 
     * @return The facet to remove from the object.
     */
    public final SchemaFacet schemaFacet() {
        return schemaFacet;
    }

    /**
     * <p>
     * A reference to the object whose facet will be removed.
     * </p>
     * 
     * @return A reference to the object whose facet will be removed.
     */
    public final ObjectReference objectReference() {
        return objectReference;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(schemaFacet());
        hashCode = 31 * hashCode + Objects.hashCode(objectReference());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchRemoveFacetFromObject)) {
            return false;
        }
        BatchRemoveFacetFromObject other = (BatchRemoveFacetFromObject) obj;
        return Objects.equals(schemaFacet(), other.schemaFacet()) && Objects.equals(objectReference(), other.objectReference());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchRemoveFacetFromObject").add("SchemaFacet", schemaFacet())
                .add("ObjectReference", objectReference()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SchemaFacet":
            return Optional.ofNullable(clazz.cast(schemaFacet()));
        case "ObjectReference":
            return Optional.ofNullable(clazz.cast(objectReference()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchRemoveFacetFromObject, T> g) {
        return obj -> g.apply((BatchRemoveFacetFromObject) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchRemoveFacetFromObject> {
        /**
         * <p>
         * The facet to remove from the object.
         * </p>
         * 
         * @param schemaFacet
         *        The facet to remove from the object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaFacet(SchemaFacet schemaFacet);

        /**
         * <p>
         * The facet to remove from the object.
         * </p>
         * This is a convenience that creates an instance of the {@link SchemaFacet.Builder} avoiding the need to create
         * one manually via {@link SchemaFacet#builder()}.
         *
         * When the {@link Consumer} completes, {@link SchemaFacet.Builder#build()} is called immediately and its result
         * is passed to {@link #schemaFacet(SchemaFacet)}.
         * 
         * @param schemaFacet
         *        a consumer that will call methods on {@link SchemaFacet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schemaFacet(SchemaFacet)
         */
        default Builder schemaFacet(Consumer<SchemaFacet.Builder> schemaFacet) {
            return schemaFacet(SchemaFacet.builder().applyMutation(schemaFacet).build());
        }

        /**
         * <p>
         * A reference to the object whose facet will be removed.
         * </p>
         * 
         * @param objectReference
         *        A reference to the object whose facet will be removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectReference(ObjectReference objectReference);

        /**
         * <p>
         * A reference to the object whose facet will be removed.
         * </p>
         * This is a convenience that creates an instance of the {@link ObjectReference.Builder} avoiding the need to
         * create one manually via {@link ObjectReference#builder()}.
         *
         * When the {@link Consumer} completes, {@link ObjectReference.Builder#build()} is called immediately and its
         * result is passed to {@link #objectReference(ObjectReference)}.
         * 
         * @param objectReference
         *        a consumer that will call methods on {@link ObjectReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #objectReference(ObjectReference)
         */
        default Builder objectReference(Consumer<ObjectReference.Builder> objectReference) {
            return objectReference(ObjectReference.builder().applyMutation(objectReference).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SchemaFacet schemaFacet;

        private ObjectReference objectReference;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchRemoveFacetFromObject model) {
            schemaFacet(model.schemaFacet);
            objectReference(model.objectReference);
        }

        public final SchemaFacet.Builder getSchemaFacet() {
            return schemaFacet != null ? schemaFacet.toBuilder() : null;
        }

        @Override
        public final Builder schemaFacet(SchemaFacet schemaFacet) {
            this.schemaFacet = schemaFacet;
            return this;
        }

        public final void setSchemaFacet(SchemaFacet.BuilderImpl schemaFacet) {
            this.schemaFacet = schemaFacet != null ? schemaFacet.build() : null;
        }

        public final ObjectReference.Builder getObjectReference() {
            return objectReference != null ? objectReference.toBuilder() : null;
        }

        @Override
        public final Builder objectReference(ObjectReference objectReference) {
            this.objectReference = objectReference;
            return this;
        }

        public final void setObjectReference(ObjectReference.BuilderImpl objectReference) {
            this.objectReference = objectReference != null ? objectReference.build() : null;
        }

        @Override
        public BatchRemoveFacetFromObject build() {
            return new BatchRemoveFacetFromObject(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
