/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchReadResponse extends CloudDirectoryResponse implements
        ToCopyableBuilder<BatchReadResponse.Builder, BatchReadResponse> {
    private static final SdkField<List<BatchReadOperationResponse>> RESPONSES_FIELD = SdkField
            .<List<BatchReadOperationResponse>> builder(MarshallingType.LIST)
            .memberName("Responses")
            .getter(getter(BatchReadResponse::responses))
            .setter(setter(Builder::responses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Responses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchReadOperationResponse> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchReadOperationResponse::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESPONSES_FIELD));

    private final List<BatchReadOperationResponse> responses;

    private BatchReadResponse(BuilderImpl builder) {
        super(builder);
        this.responses = builder.responses;
    }

    /**
     * Returns true if the Responses property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasResponses() {
        return responses != null && !(responses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of all the responses for each batch read.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResponses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of all the responses for each batch read.
     */
    public final List<BatchReadOperationResponse> responses() {
        return responses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasResponses() ? responses() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchReadResponse)) {
            return false;
        }
        BatchReadResponse other = (BatchReadResponse) obj;
        return hasResponses() == other.hasResponses() && Objects.equals(responses(), other.responses());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchReadResponse").add("Responses", hasResponses() ? responses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Responses":
            return Optional.ofNullable(clazz.cast(responses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchReadResponse, T> g) {
        return obj -> g.apply((BatchReadResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudDirectoryResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchReadResponse> {
        /**
         * <p>
         * A list of all the responses for each batch read.
         * </p>
         * 
         * @param responses
         *        A list of all the responses for each batch read.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responses(Collection<BatchReadOperationResponse> responses);

        /**
         * <p>
         * A list of all the responses for each batch read.
         * </p>
         * 
         * @param responses
         *        A list of all the responses for each batch read.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responses(BatchReadOperationResponse... responses);

        /**
         * <p>
         * A list of all the responses for each batch read.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BatchReadOperationResponse>.Builder}
         * avoiding the need to create one manually via {@link List<BatchReadOperationResponse>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BatchReadOperationResponse>.Builder#build()} is called
         * immediately and its result is passed to {@link #responses(List<BatchReadOperationResponse>)}.
         * 
         * @param responses
         *        a consumer that will call methods on {@link List<BatchReadOperationResponse>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #responses(List<BatchReadOperationResponse>)
         */
        Builder responses(Consumer<BatchReadOperationResponse.Builder>... responses);
    }

    static final class BuilderImpl extends CloudDirectoryResponse.BuilderImpl implements Builder {
        private List<BatchReadOperationResponse> responses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchReadResponse model) {
            super(model);
            responses(model.responses);
        }

        public final Collection<BatchReadOperationResponse.Builder> getResponses() {
            if (responses instanceof SdkAutoConstructList) {
                return null;
            }
            return responses != null ? responses.stream().map(BatchReadOperationResponse::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder responses(Collection<BatchReadOperationResponse> responses) {
            this.responses = BatchReadOperationResponseListCopier.copy(responses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responses(BatchReadOperationResponse... responses) {
            responses(Arrays.asList(responses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responses(Consumer<BatchReadOperationResponse.Builder>... responses) {
            responses(Stream.of(responses).map(c -> BatchReadOperationResponse.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setResponses(Collection<BatchReadOperationResponse.BuilderImpl> responses) {
            this.responses = BatchReadOperationResponseListCopier.copyFromBuilder(responses);
        }

        @Override
        public BatchReadResponse build() {
            return new BatchReadResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
