/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <a>ListObjectAttributes</a> response operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchListObjectAttributesResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchListObjectAttributesResponse.Builder, BatchListObjectAttributesResponse> {
    private static final SdkField<List<AttributeKeyAndValue>> ATTRIBUTES_FIELD = SdkField
            .<List<AttributeKeyAndValue>> builder(MarshallingType.LIST)
            .memberName("Attributes")
            .getter(getter(BatchListObjectAttributesResponse::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttributeKeyAndValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeKeyAndValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(BatchListObjectAttributesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AttributeKeyAndValue> attributes;

    private final String nextToken;

    private BatchListObjectAttributesResponse(BuilderImpl builder) {
        this.attributes = builder.attributes;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Attributes property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The attributes map that is associated with the object. <code>AttributeArn</code> is the key; attribute value is
     * the value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The attributes map that is associated with the object. <code>AttributeArn</code> is the key; attribute
     *         value is the value.
     */
    public final List<AttributeKeyAndValue> attributes() {
        return attributes;
    }

    /**
     * <p>
     * The pagination token.
     * </p>
     * 
     * @return The pagination token.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchListObjectAttributesResponse)) {
            return false;
        }
        BatchListObjectAttributesResponse other = (BatchListObjectAttributesResponse) obj;
        return hasAttributes() == other.hasAttributes() && Objects.equals(attributes(), other.attributes())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchListObjectAttributesResponse").add("Attributes", hasAttributes() ? attributes() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchListObjectAttributesResponse, T> g) {
        return obj -> g.apply((BatchListObjectAttributesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchListObjectAttributesResponse> {
        /**
         * <p>
         * The attributes map that is associated with the object. <code>AttributeArn</code> is the key; attribute value
         * is the value.
         * </p>
         * 
         * @param attributes
         *        The attributes map that is associated with the object. <code>AttributeArn</code> is the key; attribute
         *        value is the value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Collection<AttributeKeyAndValue> attributes);

        /**
         * <p>
         * The attributes map that is associated with the object. <code>AttributeArn</code> is the key; attribute value
         * is the value.
         * </p>
         * 
         * @param attributes
         *        The attributes map that is associated with the object. <code>AttributeArn</code> is the key; attribute
         *        value is the value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(AttributeKeyAndValue... attributes);

        /**
         * <p>
         * The attributes map that is associated with the object. <code>AttributeArn</code> is the key; attribute value
         * is the value.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AttributeKeyAndValue>.Builder} avoiding the
         * need to create one manually via {@link List<AttributeKeyAndValue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AttributeKeyAndValue>.Builder#build()} is called immediately
         * and its result is passed to {@link #attributes(List<AttributeKeyAndValue>)}.
         * 
         * @param attributes
         *        a consumer that will call methods on {@link List<AttributeKeyAndValue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributes(List<AttributeKeyAndValue>)
         */
        Builder attributes(Consumer<AttributeKeyAndValue.Builder>... attributes);

        /**
         * <p>
         * The pagination token.
         * </p>
         * 
         * @param nextToken
         *        The pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<AttributeKeyAndValue> attributes = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchListObjectAttributesResponse model) {
            attributes(model.attributes);
            nextToken(model.nextToken);
        }

        public final Collection<AttributeKeyAndValue.Builder> getAttributes() {
            if (attributes instanceof SdkAutoConstructList) {
                return null;
            }
            return attributes != null ? attributes.stream().map(AttributeKeyAndValue::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder attributes(Collection<AttributeKeyAndValue> attributes) {
            this.attributes = AttributeKeyAndValueListCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(AttributeKeyAndValue... attributes) {
            attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<AttributeKeyAndValue.Builder>... attributes) {
            attributes(Stream.of(attributes).map(c -> AttributeKeyAndValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAttributes(Collection<AttributeKeyAndValue.BuilderImpl> attributes) {
            this.attributes = AttributeKeyAndValueListCopier.copyFromBuilder(attributes);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public BatchListObjectAttributesResponse build() {
            return new BatchListObjectAttributesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
