/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <a>ListIndex</a> response operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchListIndexResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchListIndexResponse.Builder, BatchListIndexResponse> {
    private static final SdkField<List<IndexAttachment>> INDEX_ATTACHMENTS_FIELD = SdkField
            .<List<IndexAttachment>> builder(MarshallingType.LIST)
            .memberName("IndexAttachments")
            .getter(getter(BatchListIndexResponse::indexAttachments))
            .setter(setter(Builder::indexAttachments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexAttachments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IndexAttachment> builder(MarshallingType.SDK_POJO)
                                            .constructor(IndexAttachment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(BatchListIndexResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_ATTACHMENTS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<IndexAttachment> indexAttachments;

    private final String nextToken;

    private BatchListIndexResponse(BuilderImpl builder) {
        this.indexAttachments = builder.indexAttachments;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the IndexAttachments property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasIndexAttachments() {
        return indexAttachments != null && !(indexAttachments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The objects and indexed values attached to the index.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIndexAttachments()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The objects and indexed values attached to the index.
     */
    public final List<IndexAttachment> indexAttachments() {
        return indexAttachments;
    }

    /**
     * <p>
     * The pagination token.
     * </p>
     * 
     * @return The pagination token.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasIndexAttachments() ? indexAttachments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchListIndexResponse)) {
            return false;
        }
        BatchListIndexResponse other = (BatchListIndexResponse) obj;
        return hasIndexAttachments() == other.hasIndexAttachments()
                && Objects.equals(indexAttachments(), other.indexAttachments()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchListIndexResponse")
                .add("IndexAttachments", hasIndexAttachments() ? indexAttachments() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexAttachments":
            return Optional.ofNullable(clazz.cast(indexAttachments()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchListIndexResponse, T> g) {
        return obj -> g.apply((BatchListIndexResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchListIndexResponse> {
        /**
         * <p>
         * The objects and indexed values attached to the index.
         * </p>
         * 
         * @param indexAttachments
         *        The objects and indexed values attached to the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexAttachments(Collection<IndexAttachment> indexAttachments);

        /**
         * <p>
         * The objects and indexed values attached to the index.
         * </p>
         * 
         * @param indexAttachments
         *        The objects and indexed values attached to the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexAttachments(IndexAttachment... indexAttachments);

        /**
         * <p>
         * The objects and indexed values attached to the index.
         * </p>
         * This is a convenience that creates an instance of the {@link List<IndexAttachment>.Builder} avoiding the need
         * to create one manually via {@link List<IndexAttachment>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IndexAttachment>.Builder#build()} is called immediately and
         * its result is passed to {@link #indexAttachments(List<IndexAttachment>)}.
         * 
         * @param indexAttachments
         *        a consumer that will call methods on {@link List<IndexAttachment>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #indexAttachments(List<IndexAttachment>)
         */
        Builder indexAttachments(Consumer<IndexAttachment.Builder>... indexAttachments);

        /**
         * <p>
         * The pagination token.
         * </p>
         * 
         * @param nextToken
         *        The pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<IndexAttachment> indexAttachments = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchListIndexResponse model) {
            indexAttachments(model.indexAttachments);
            nextToken(model.nextToken);
        }

        public final Collection<IndexAttachment.Builder> getIndexAttachments() {
            if (indexAttachments instanceof SdkAutoConstructList) {
                return null;
            }
            return indexAttachments != null ? indexAttachments.stream().map(IndexAttachment::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder indexAttachments(Collection<IndexAttachment> indexAttachments) {
            this.indexAttachments = IndexAttachmentListCopier.copy(indexAttachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder indexAttachments(IndexAttachment... indexAttachments) {
            indexAttachments(Arrays.asList(indexAttachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder indexAttachments(Consumer<IndexAttachment.Builder>... indexAttachments) {
            indexAttachments(Stream.of(indexAttachments).map(c -> IndexAttachment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setIndexAttachments(Collection<IndexAttachment.BuilderImpl> indexAttachments) {
            this.indexAttachments = IndexAttachmentListCopier.copyFromBuilder(indexAttachments);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public BatchListIndexResponse build() {
            return new BatchListIndexResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
