/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <a>CreateObject</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchCreateObject implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchCreateObject.Builder, BatchCreateObject> {
    private static final SdkField<List<SchemaFacet>> SCHEMA_FACET_FIELD = SdkField
            .<List<SchemaFacet>> builder(MarshallingType.LIST)
            .memberName("SchemaFacet")
            .getter(getter(BatchCreateObject::schemaFacet))
            .setter(setter(Builder::schemaFacet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaFacet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SchemaFacet> builder(MarshallingType.SDK_POJO)
                                            .constructor(SchemaFacet::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AttributeKeyAndValue>> OBJECT_ATTRIBUTE_LIST_FIELD = SdkField
            .<List<AttributeKeyAndValue>> builder(MarshallingType.LIST)
            .memberName("ObjectAttributeList")
            .getter(getter(BatchCreateObject::objectAttributeList))
            .setter(setter(Builder::objectAttributeList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectAttributeList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttributeKeyAndValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeKeyAndValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ObjectReference> PARENT_REFERENCE_FIELD = SdkField
            .<ObjectReference> builder(MarshallingType.SDK_POJO).memberName("ParentReference")
            .getter(getter(BatchCreateObject::parentReference)).setter(setter(Builder::parentReference))
            .constructor(ObjectReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentReference").build()).build();

    private static final SdkField<String> LINK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LinkName").getter(getter(BatchCreateObject::linkName)).setter(setter(Builder::linkName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkName").build()).build();

    private static final SdkField<String> BATCH_REFERENCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BatchReferenceName").getter(getter(BatchCreateObject::batchReferenceName))
            .setter(setter(Builder::batchReferenceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchReferenceName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_FACET_FIELD,
            OBJECT_ATTRIBUTE_LIST_FIELD, PARENT_REFERENCE_FIELD, LINK_NAME_FIELD, BATCH_REFERENCE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<SchemaFacet> schemaFacet;

    private final List<AttributeKeyAndValue> objectAttributeList;

    private final ObjectReference parentReference;

    private final String linkName;

    private final String batchReferenceName;

    private BatchCreateObject(BuilderImpl builder) {
        this.schemaFacet = builder.schemaFacet;
        this.objectAttributeList = builder.objectAttributeList;
        this.parentReference = builder.parentReference;
        this.linkName = builder.linkName;
        this.batchReferenceName = builder.batchReferenceName;
    }

    /**
     * Returns true if the SchemaFacet property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSchemaFacet() {
        return schemaFacet != null && !(schemaFacet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>FacetArns</code> that will be associated with the object. For more information, see <a>arns</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSchemaFacet()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of <code>FacetArns</code> that will be associated with the object. For more information, see
     *         <a>arns</a>.
     */
    public final List<SchemaFacet> schemaFacet() {
        return schemaFacet;
    }

    /**
     * Returns true if the ObjectAttributeList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasObjectAttributeList() {
        return objectAttributeList != null && !(objectAttributeList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An attribute map, which contains an attribute ARN as the key and attribute value as the map value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasObjectAttributeList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An attribute map, which contains an attribute ARN as the key and attribute value as the map value.
     */
    public final List<AttributeKeyAndValue> objectAttributeList() {
        return objectAttributeList;
    }

    /**
     * <p>
     * If specified, the parent reference to which this object will be attached.
     * </p>
     * 
     * @return If specified, the parent reference to which this object will be attached.
     */
    public final ObjectReference parentReference() {
        return parentReference;
    }

    /**
     * <p>
     * The name of the link.
     * </p>
     * 
     * @return The name of the link.
     */
    public final String linkName() {
        return linkName;
    }

    /**
     * <p>
     * The batch reference name. See <a
     * href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/transaction_support.html">Transaction
     * Support</a> for more information.
     * </p>
     * 
     * @return The batch reference name. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/transaction_support.html"
     *         >Transaction Support</a> for more information.
     */
    public final String batchReferenceName() {
        return batchReferenceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSchemaFacet() ? schemaFacet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasObjectAttributeList() ? objectAttributeList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(parentReference());
        hashCode = 31 * hashCode + Objects.hashCode(linkName());
        hashCode = 31 * hashCode + Objects.hashCode(batchReferenceName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateObject)) {
            return false;
        }
        BatchCreateObject other = (BatchCreateObject) obj;
        return hasSchemaFacet() == other.hasSchemaFacet() && Objects.equals(schemaFacet(), other.schemaFacet())
                && hasObjectAttributeList() == other.hasObjectAttributeList()
                && Objects.equals(objectAttributeList(), other.objectAttributeList())
                && Objects.equals(parentReference(), other.parentReference()) && Objects.equals(linkName(), other.linkName())
                && Objects.equals(batchReferenceName(), other.batchReferenceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchCreateObject").add("SchemaFacet", hasSchemaFacet() ? schemaFacet() : null)
                .add("ObjectAttributeList", hasObjectAttributeList() ? objectAttributeList() : null)
                .add("ParentReference", parentReference()).add("LinkName", linkName())
                .add("BatchReferenceName", batchReferenceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SchemaFacet":
            return Optional.ofNullable(clazz.cast(schemaFacet()));
        case "ObjectAttributeList":
            return Optional.ofNullable(clazz.cast(objectAttributeList()));
        case "ParentReference":
            return Optional.ofNullable(clazz.cast(parentReference()));
        case "LinkName":
            return Optional.ofNullable(clazz.cast(linkName()));
        case "BatchReferenceName":
            return Optional.ofNullable(clazz.cast(batchReferenceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchCreateObject, T> g) {
        return obj -> g.apply((BatchCreateObject) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchCreateObject> {
        /**
         * <p>
         * A list of <code>FacetArns</code> that will be associated with the object. For more information, see
         * <a>arns</a>.
         * </p>
         * 
         * @param schemaFacet
         *        A list of <code>FacetArns</code> that will be associated with the object. For more information, see
         *        <a>arns</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaFacet(Collection<SchemaFacet> schemaFacet);

        /**
         * <p>
         * A list of <code>FacetArns</code> that will be associated with the object. For more information, see
         * <a>arns</a>.
         * </p>
         * 
         * @param schemaFacet
         *        A list of <code>FacetArns</code> that will be associated with the object. For more information, see
         *        <a>arns</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaFacet(SchemaFacet... schemaFacet);

        /**
         * <p>
         * A list of <code>FacetArns</code> that will be associated with the object. For more information, see
         * <a>arns</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SchemaFacet>.Builder} avoiding the need to
         * create one manually via {@link List<SchemaFacet>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SchemaFacet>.Builder#build()} is called immediately and its
         * result is passed to {@link #schemaFacet(List<SchemaFacet>)}.
         * 
         * @param schemaFacet
         *        a consumer that will call methods on {@link List<SchemaFacet>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schemaFacet(List<SchemaFacet>)
         */
        Builder schemaFacet(Consumer<SchemaFacet.Builder>... schemaFacet);

        /**
         * <p>
         * An attribute map, which contains an attribute ARN as the key and attribute value as the map value.
         * </p>
         * 
         * @param objectAttributeList
         *        An attribute map, which contains an attribute ARN as the key and attribute value as the map value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectAttributeList(Collection<AttributeKeyAndValue> objectAttributeList);

        /**
         * <p>
         * An attribute map, which contains an attribute ARN as the key and attribute value as the map value.
         * </p>
         * 
         * @param objectAttributeList
         *        An attribute map, which contains an attribute ARN as the key and attribute value as the map value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectAttributeList(AttributeKeyAndValue... objectAttributeList);

        /**
         * <p>
         * An attribute map, which contains an attribute ARN as the key and attribute value as the map value.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AttributeKeyAndValue>.Builder} avoiding the
         * need to create one manually via {@link List<AttributeKeyAndValue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AttributeKeyAndValue>.Builder#build()} is called immediately
         * and its result is passed to {@link #objectAttributeList(List<AttributeKeyAndValue>)}.
         * 
         * @param objectAttributeList
         *        a consumer that will call methods on {@link List<AttributeKeyAndValue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #objectAttributeList(List<AttributeKeyAndValue>)
         */
        Builder objectAttributeList(Consumer<AttributeKeyAndValue.Builder>... objectAttributeList);

        /**
         * <p>
         * If specified, the parent reference to which this object will be attached.
         * </p>
         * 
         * @param parentReference
         *        If specified, the parent reference to which this object will be attached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentReference(ObjectReference parentReference);

        /**
         * <p>
         * If specified, the parent reference to which this object will be attached.
         * </p>
         * This is a convenience that creates an instance of the {@link ObjectReference.Builder} avoiding the need to
         * create one manually via {@link ObjectReference#builder()}.
         *
         * When the {@link Consumer} completes, {@link ObjectReference.Builder#build()} is called immediately and its
         * result is passed to {@link #parentReference(ObjectReference)}.
         * 
         * @param parentReference
         *        a consumer that will call methods on {@link ObjectReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parentReference(ObjectReference)
         */
        default Builder parentReference(Consumer<ObjectReference.Builder> parentReference) {
            return parentReference(ObjectReference.builder().applyMutation(parentReference).build());
        }

        /**
         * <p>
         * The name of the link.
         * </p>
         * 
         * @param linkName
         *        The name of the link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkName(String linkName);

        /**
         * <p>
         * The batch reference name. See <a
         * href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/transaction_support.html">Transaction
         * Support</a> for more information.
         * </p>
         * 
         * @param batchReferenceName
         *        The batch reference name. See <a
         *        href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/transaction_support.html"
         *        >Transaction Support</a> for more information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchReferenceName(String batchReferenceName);
    }

    static final class BuilderImpl implements Builder {
        private List<SchemaFacet> schemaFacet = DefaultSdkAutoConstructList.getInstance();

        private List<AttributeKeyAndValue> objectAttributeList = DefaultSdkAutoConstructList.getInstance();

        private ObjectReference parentReference;

        private String linkName;

        private String batchReferenceName;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreateObject model) {
            schemaFacet(model.schemaFacet);
            objectAttributeList(model.objectAttributeList);
            parentReference(model.parentReference);
            linkName(model.linkName);
            batchReferenceName(model.batchReferenceName);
        }

        public final Collection<SchemaFacet.Builder> getSchemaFacet() {
            if (schemaFacet instanceof SdkAutoConstructList) {
                return null;
            }
            return schemaFacet != null ? schemaFacet.stream().map(SchemaFacet::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder schemaFacet(Collection<SchemaFacet> schemaFacet) {
            this.schemaFacet = SchemaFacetListCopier.copy(schemaFacet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemaFacet(SchemaFacet... schemaFacet) {
            schemaFacet(Arrays.asList(schemaFacet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemaFacet(Consumer<SchemaFacet.Builder>... schemaFacet) {
            schemaFacet(Stream.of(schemaFacet).map(c -> SchemaFacet.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSchemaFacet(Collection<SchemaFacet.BuilderImpl> schemaFacet) {
            this.schemaFacet = SchemaFacetListCopier.copyFromBuilder(schemaFacet);
        }

        public final Collection<AttributeKeyAndValue.Builder> getObjectAttributeList() {
            if (objectAttributeList instanceof SdkAutoConstructList) {
                return null;
            }
            return objectAttributeList != null ? objectAttributeList.stream().map(AttributeKeyAndValue::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder objectAttributeList(Collection<AttributeKeyAndValue> objectAttributeList) {
            this.objectAttributeList = AttributeKeyAndValueListCopier.copy(objectAttributeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectAttributeList(AttributeKeyAndValue... objectAttributeList) {
            objectAttributeList(Arrays.asList(objectAttributeList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectAttributeList(Consumer<AttributeKeyAndValue.Builder>... objectAttributeList) {
            objectAttributeList(Stream.of(objectAttributeList).map(c -> AttributeKeyAndValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setObjectAttributeList(Collection<AttributeKeyAndValue.BuilderImpl> objectAttributeList) {
            this.objectAttributeList = AttributeKeyAndValueListCopier.copyFromBuilder(objectAttributeList);
        }

        public final ObjectReference.Builder getParentReference() {
            return parentReference != null ? parentReference.toBuilder() : null;
        }

        @Override
        public final Builder parentReference(ObjectReference parentReference) {
            this.parentReference = parentReference;
            return this;
        }

        public final void setParentReference(ObjectReference.BuilderImpl parentReference) {
            this.parentReference = parentReference != null ? parentReference.build() : null;
        }

        public final String getLinkName() {
            return linkName;
        }

        @Override
        public final Builder linkName(String linkName) {
            this.linkName = linkName;
            return this;
        }

        public final void setLinkName(String linkName) {
            this.linkName = linkName;
        }

        public final String getBatchReferenceName() {
            return batchReferenceName;
        }

        @Override
        public final Builder batchReferenceName(String batchReferenceName) {
            this.batchReferenceName = batchReferenceName;
            return this;
        }

        public final void setBatchReferenceName(String batchReferenceName) {
            this.batchReferenceName = batchReferenceName;
        }

        @Override
        public BatchCreateObject build() {
            return new BatchCreateObject(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
