/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifies the attribute name and value for a typed link.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttributeNameAndValue implements SdkPojo, Serializable,
        ToCopyableBuilder<AttributeNameAndValue.Builder, AttributeNameAndValue> {
    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttributeName").getter(getter(AttributeNameAndValue::attributeName))
            .setter(setter(Builder::attributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").build()).build();

    private static final SdkField<TypedAttributeValue> VALUE_FIELD = SdkField
            .<TypedAttributeValue> builder(MarshallingType.SDK_POJO).memberName("Value")
            .getter(getter(AttributeNameAndValue::value)).setter(setter(Builder::value))
            .constructor(TypedAttributeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_NAME_FIELD,
            VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String attributeName;

    private final TypedAttributeValue value;

    private AttributeNameAndValue(BuilderImpl builder) {
        this.attributeName = builder.attributeName;
        this.value = builder.value;
    }

    /**
     * <p>
     * The attribute name of the typed link.
     * </p>
     * 
     * @return The attribute name of the typed link.
     */
    public final String attributeName() {
        return attributeName;
    }

    /**
     * <p>
     * The value for the typed link.
     * </p>
     * 
     * @return The value for the typed link.
     */
    public final TypedAttributeValue value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeNameAndValue)) {
            return false;
        }
        AttributeNameAndValue other = (AttributeNameAndValue) obj;
        return Objects.equals(attributeName(), other.attributeName()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AttributeNameAndValue").add("AttributeName", attributeName()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttributeName":
            return Optional.ofNullable(clazz.cast(attributeName()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttributeNameAndValue, T> g) {
        return obj -> g.apply((AttributeNameAndValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AttributeNameAndValue> {
        /**
         * <p>
         * The attribute name of the typed link.
         * </p>
         * 
         * @param attributeName
         *        The attribute name of the typed link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeName(String attributeName);

        /**
         * <p>
         * The value for the typed link.
         * </p>
         * 
         * @param value
         *        The value for the typed link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(TypedAttributeValue value);

        /**
         * <p>
         * The value for the typed link.
         * </p>
         * This is a convenience that creates an instance of the {@link TypedAttributeValue.Builder} avoiding the need
         * to create one manually via {@link TypedAttributeValue#builder()}.
         *
         * When the {@link Consumer} completes, {@link TypedAttributeValue.Builder#build()} is called immediately and
         * its result is passed to {@link #value(TypedAttributeValue)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link TypedAttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(TypedAttributeValue)
         */
        default Builder value(Consumer<TypedAttributeValue.Builder> value) {
            return value(TypedAttributeValue.builder().applyMutation(value).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String attributeName;

        private TypedAttributeValue value;

        private BuilderImpl() {
        }

        private BuilderImpl(AttributeNameAndValue model) {
            attributeName(model.attributeName);
            value(model.value);
        }

        public final String getAttributeName() {
            return attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public final TypedAttributeValue.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        @Override
        public final Builder value(TypedAttributeValue value) {
            this.value = value;
            return this;
        }

        public final void setValue(TypedAttributeValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public AttributeNameAndValue build() {
            return new AttributeNameAndValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
