/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttachTypedLinkRequest extends CloudDirectoryRequest implements
        ToCopyableBuilder<AttachTypedLinkRequest.Builder, AttachTypedLinkRequest> {
    private static final SdkField<String> DIRECTORY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryArn").getter(getter(AttachTypedLinkRequest::directoryArn))
            .setter(setter(Builder::directoryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-data-partition").build())
            .build();

    private static final SdkField<ObjectReference> SOURCE_OBJECT_REFERENCE_FIELD = SdkField
            .<ObjectReference> builder(MarshallingType.SDK_POJO).memberName("SourceObjectReference")
            .getter(getter(AttachTypedLinkRequest::sourceObjectReference)).setter(setter(Builder::sourceObjectReference))
            .constructor(ObjectReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceObjectReference").build())
            .build();

    private static final SdkField<ObjectReference> TARGET_OBJECT_REFERENCE_FIELD = SdkField
            .<ObjectReference> builder(MarshallingType.SDK_POJO).memberName("TargetObjectReference")
            .getter(getter(AttachTypedLinkRequest::targetObjectReference)).setter(setter(Builder::targetObjectReference))
            .constructor(ObjectReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetObjectReference").build())
            .build();

    private static final SdkField<TypedLinkSchemaAndFacetName> TYPED_LINK_FACET_FIELD = SdkField
            .<TypedLinkSchemaAndFacetName> builder(MarshallingType.SDK_POJO).memberName("TypedLinkFacet")
            .getter(getter(AttachTypedLinkRequest::typedLinkFacet)).setter(setter(Builder::typedLinkFacet))
            .constructor(TypedLinkSchemaAndFacetName::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypedLinkFacet").build()).build();

    private static final SdkField<List<AttributeNameAndValue>> ATTRIBUTES_FIELD = SdkField
            .<List<AttributeNameAndValue>> builder(MarshallingType.LIST)
            .memberName("Attributes")
            .getter(getter(AttachTypedLinkRequest::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttributeNameAndValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeNameAndValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ARN_FIELD,
            SOURCE_OBJECT_REFERENCE_FIELD, TARGET_OBJECT_REFERENCE_FIELD, TYPED_LINK_FACET_FIELD, ATTRIBUTES_FIELD));

    private final String directoryArn;

    private final ObjectReference sourceObjectReference;

    private final ObjectReference targetObjectReference;

    private final TypedLinkSchemaAndFacetName typedLinkFacet;

    private final List<AttributeNameAndValue> attributes;

    private AttachTypedLinkRequest(BuilderImpl builder) {
        super(builder);
        this.directoryArn = builder.directoryArn;
        this.sourceObjectReference = builder.sourceObjectReference;
        this.targetObjectReference = builder.targetObjectReference;
        this.typedLinkFacet = builder.typedLinkFacet;
        this.attributes = builder.attributes;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the directory where you want to attach the typed link.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the directory where you want to attach the typed link.
     */
    public final String directoryArn() {
        return directoryArn;
    }

    /**
     * <p>
     * Identifies the source object that the typed link will attach to.
     * </p>
     * 
     * @return Identifies the source object that the typed link will attach to.
     */
    public final ObjectReference sourceObjectReference() {
        return sourceObjectReference;
    }

    /**
     * <p>
     * Identifies the target object that the typed link will attach to.
     * </p>
     * 
     * @return Identifies the target object that the typed link will attach to.
     */
    public final ObjectReference targetObjectReference() {
        return targetObjectReference;
    }

    /**
     * <p>
     * Identifies the typed link facet that is associated with the typed link.
     * </p>
     * 
     * @return Identifies the typed link facet that is associated with the typed link.
     */
    public final TypedLinkSchemaAndFacetName typedLinkFacet() {
        return typedLinkFacet;
    }

    /**
     * Returns true if the Attributes property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A set of attributes that are associated with the typed link.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A set of attributes that are associated with the typed link.
     */
    public final List<AttributeNameAndValue> attributes() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceObjectReference());
        hashCode = 31 * hashCode + Objects.hashCode(targetObjectReference());
        hashCode = 31 * hashCode + Objects.hashCode(typedLinkFacet());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachTypedLinkRequest)) {
            return false;
        }
        AttachTypedLinkRequest other = (AttachTypedLinkRequest) obj;
        return Objects.equals(directoryArn(), other.directoryArn())
                && Objects.equals(sourceObjectReference(), other.sourceObjectReference())
                && Objects.equals(targetObjectReference(), other.targetObjectReference())
                && Objects.equals(typedLinkFacet(), other.typedLinkFacet()) && hasAttributes() == other.hasAttributes()
                && Objects.equals(attributes(), other.attributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AttachTypedLinkRequest").add("DirectoryArn", directoryArn())
                .add("SourceObjectReference", sourceObjectReference()).add("TargetObjectReference", targetObjectReference())
                .add("TypedLinkFacet", typedLinkFacet()).add("Attributes", hasAttributes() ? attributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryArn":
            return Optional.ofNullable(clazz.cast(directoryArn()));
        case "SourceObjectReference":
            return Optional.ofNullable(clazz.cast(sourceObjectReference()));
        case "TargetObjectReference":
            return Optional.ofNullable(clazz.cast(targetObjectReference()));
        case "TypedLinkFacet":
            return Optional.ofNullable(clazz.cast(typedLinkFacet()));
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttachTypedLinkRequest, T> g) {
        return obj -> g.apply((AttachTypedLinkRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudDirectoryRequest.Builder, SdkPojo, CopyableBuilder<Builder, AttachTypedLinkRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the directory where you want to attach the typed link.
         * </p>
         * 
         * @param directoryArn
         *        The Amazon Resource Name (ARN) of the directory where you want to attach the typed link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryArn(String directoryArn);

        /**
         * <p>
         * Identifies the source object that the typed link will attach to.
         * </p>
         * 
         * @param sourceObjectReference
         *        Identifies the source object that the typed link will attach to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceObjectReference(ObjectReference sourceObjectReference);

        /**
         * <p>
         * Identifies the source object that the typed link will attach to.
         * </p>
         * This is a convenience that creates an instance of the {@link ObjectReference.Builder} avoiding the need to
         * create one manually via {@link ObjectReference#builder()}.
         *
         * When the {@link Consumer} completes, {@link ObjectReference.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceObjectReference(ObjectReference)}.
         * 
         * @param sourceObjectReference
         *        a consumer that will call methods on {@link ObjectReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceObjectReference(ObjectReference)
         */
        default Builder sourceObjectReference(Consumer<ObjectReference.Builder> sourceObjectReference) {
            return sourceObjectReference(ObjectReference.builder().applyMutation(sourceObjectReference).build());
        }

        /**
         * <p>
         * Identifies the target object that the typed link will attach to.
         * </p>
         * 
         * @param targetObjectReference
         *        Identifies the target object that the typed link will attach to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetObjectReference(ObjectReference targetObjectReference);

        /**
         * <p>
         * Identifies the target object that the typed link will attach to.
         * </p>
         * This is a convenience that creates an instance of the {@link ObjectReference.Builder} avoiding the need to
         * create one manually via {@link ObjectReference#builder()}.
         *
         * When the {@link Consumer} completes, {@link ObjectReference.Builder#build()} is called immediately and its
         * result is passed to {@link #targetObjectReference(ObjectReference)}.
         * 
         * @param targetObjectReference
         *        a consumer that will call methods on {@link ObjectReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetObjectReference(ObjectReference)
         */
        default Builder targetObjectReference(Consumer<ObjectReference.Builder> targetObjectReference) {
            return targetObjectReference(ObjectReference.builder().applyMutation(targetObjectReference).build());
        }

        /**
         * <p>
         * Identifies the typed link facet that is associated with the typed link.
         * </p>
         * 
         * @param typedLinkFacet
         *        Identifies the typed link facet that is associated with the typed link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typedLinkFacet(TypedLinkSchemaAndFacetName typedLinkFacet);

        /**
         * <p>
         * Identifies the typed link facet that is associated with the typed link.
         * </p>
         * This is a convenience that creates an instance of the {@link TypedLinkSchemaAndFacetName.Builder} avoiding
         * the need to create one manually via {@link TypedLinkSchemaAndFacetName#builder()}.
         *
         * When the {@link Consumer} completes, {@link TypedLinkSchemaAndFacetName.Builder#build()} is called
         * immediately and its result is passed to {@link #typedLinkFacet(TypedLinkSchemaAndFacetName)}.
         * 
         * @param typedLinkFacet
         *        a consumer that will call methods on {@link TypedLinkSchemaAndFacetName.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #typedLinkFacet(TypedLinkSchemaAndFacetName)
         */
        default Builder typedLinkFacet(Consumer<TypedLinkSchemaAndFacetName.Builder> typedLinkFacet) {
            return typedLinkFacet(TypedLinkSchemaAndFacetName.builder().applyMutation(typedLinkFacet).build());
        }

        /**
         * <p>
         * A set of attributes that are associated with the typed link.
         * </p>
         * 
         * @param attributes
         *        A set of attributes that are associated with the typed link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Collection<AttributeNameAndValue> attributes);

        /**
         * <p>
         * A set of attributes that are associated with the typed link.
         * </p>
         * 
         * @param attributes
         *        A set of attributes that are associated with the typed link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(AttributeNameAndValue... attributes);

        /**
         * <p>
         * A set of attributes that are associated with the typed link.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AttributeNameAndValue>.Builder} avoiding
         * the need to create one manually via {@link List<AttributeNameAndValue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AttributeNameAndValue>.Builder#build()} is called
         * immediately and its result is passed to {@link #attributes(List<AttributeNameAndValue>)}.
         * 
         * @param attributes
         *        a consumer that will call methods on {@link List<AttributeNameAndValue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributes(List<AttributeNameAndValue>)
         */
        Builder attributes(Consumer<AttributeNameAndValue.Builder>... attributes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudDirectoryRequest.BuilderImpl implements Builder {
        private String directoryArn;

        private ObjectReference sourceObjectReference;

        private ObjectReference targetObjectReference;

        private TypedLinkSchemaAndFacetName typedLinkFacet;

        private List<AttributeNameAndValue> attributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AttachTypedLinkRequest model) {
            super(model);
            directoryArn(model.directoryArn);
            sourceObjectReference(model.sourceObjectReference);
            targetObjectReference(model.targetObjectReference);
            typedLinkFacet(model.typedLinkFacet);
            attributes(model.attributes);
        }

        public final String getDirectoryArn() {
            return directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        public final ObjectReference.Builder getSourceObjectReference() {
            return sourceObjectReference != null ? sourceObjectReference.toBuilder() : null;
        }

        @Override
        public final Builder sourceObjectReference(ObjectReference sourceObjectReference) {
            this.sourceObjectReference = sourceObjectReference;
            return this;
        }

        public final void setSourceObjectReference(ObjectReference.BuilderImpl sourceObjectReference) {
            this.sourceObjectReference = sourceObjectReference != null ? sourceObjectReference.build() : null;
        }

        public final ObjectReference.Builder getTargetObjectReference() {
            return targetObjectReference != null ? targetObjectReference.toBuilder() : null;
        }

        @Override
        public final Builder targetObjectReference(ObjectReference targetObjectReference) {
            this.targetObjectReference = targetObjectReference;
            return this;
        }

        public final void setTargetObjectReference(ObjectReference.BuilderImpl targetObjectReference) {
            this.targetObjectReference = targetObjectReference != null ? targetObjectReference.build() : null;
        }

        public final TypedLinkSchemaAndFacetName.Builder getTypedLinkFacet() {
            return typedLinkFacet != null ? typedLinkFacet.toBuilder() : null;
        }

        @Override
        public final Builder typedLinkFacet(TypedLinkSchemaAndFacetName typedLinkFacet) {
            this.typedLinkFacet = typedLinkFacet;
            return this;
        }

        public final void setTypedLinkFacet(TypedLinkSchemaAndFacetName.BuilderImpl typedLinkFacet) {
            this.typedLinkFacet = typedLinkFacet != null ? typedLinkFacet.build() : null;
        }

        public final Collection<AttributeNameAndValue.Builder> getAttributes() {
            if (attributes instanceof SdkAutoConstructList) {
                return null;
            }
            return attributes != null ? attributes.stream().map(AttributeNameAndValue::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder attributes(Collection<AttributeNameAndValue> attributes) {
            this.attributes = AttributeNameAndValueListCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(AttributeNameAndValue... attributes) {
            attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<AttributeNameAndValue.Builder>... attributes) {
            attributes(Stream.of(attributes).map(c -> AttributeNameAndValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAttributes(Collection<AttributeNameAndValue.BuilderImpl> attributes) {
            this.attributes = AttributeNameAndValueListCopier.copyFromBuilder(attributes);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AttachTypedLinkRequest build() {
            return new AttachTypedLinkRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
