/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddFacetToObjectRequest extends CloudDirectoryRequest implements
        ToCopyableBuilder<AddFacetToObjectRequest.Builder, AddFacetToObjectRequest> {
    private static final SdkField<String> DIRECTORY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryArn").getter(getter(AddFacetToObjectRequest::directoryArn))
            .setter(setter(Builder::directoryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-data-partition").build())
            .build();

    private static final SdkField<SchemaFacet> SCHEMA_FACET_FIELD = SdkField.<SchemaFacet> builder(MarshallingType.SDK_POJO)
            .memberName("SchemaFacet").getter(getter(AddFacetToObjectRequest::schemaFacet)).setter(setter(Builder::schemaFacet))
            .constructor(SchemaFacet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaFacet").build()).build();

    private static final SdkField<List<AttributeKeyAndValue>> OBJECT_ATTRIBUTE_LIST_FIELD = SdkField
            .<List<AttributeKeyAndValue>> builder(MarshallingType.LIST)
            .memberName("ObjectAttributeList")
            .getter(getter(AddFacetToObjectRequest::objectAttributeList))
            .setter(setter(Builder::objectAttributeList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectAttributeList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttributeKeyAndValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeKeyAndValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ObjectReference> OBJECT_REFERENCE_FIELD = SdkField
            .<ObjectReference> builder(MarshallingType.SDK_POJO).memberName("ObjectReference")
            .getter(getter(AddFacetToObjectRequest::objectReference)).setter(setter(Builder::objectReference))
            .constructor(ObjectReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectReference").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ARN_FIELD,
            SCHEMA_FACET_FIELD, OBJECT_ATTRIBUTE_LIST_FIELD, OBJECT_REFERENCE_FIELD));

    private final String directoryArn;

    private final SchemaFacet schemaFacet;

    private final List<AttributeKeyAndValue> objectAttributeList;

    private final ObjectReference objectReference;

    private AddFacetToObjectRequest(BuilderImpl builder) {
        super(builder);
        this.directoryArn = builder.directoryArn;
        this.schemaFacet = builder.schemaFacet;
        this.objectAttributeList = builder.objectAttributeList;
        this.objectReference = builder.objectReference;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that is associated with the <a>Directory</a> where the object resides. For more
     * information, see <a>arns</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that is associated with the <a>Directory</a> where the object resides. For
     *         more information, see <a>arns</a>.
     */
    public final String directoryArn() {
        return directoryArn;
    }

    /**
     * <p>
     * Identifiers for the facet that you are adding to the object. See <a>SchemaFacet</a> for details.
     * </p>
     * 
     * @return Identifiers for the facet that you are adding to the object. See <a>SchemaFacet</a> for details.
     */
    public final SchemaFacet schemaFacet() {
        return schemaFacet;
    }

    /**
     * Returns true if the ObjectAttributeList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasObjectAttributeList() {
        return objectAttributeList != null && !(objectAttributeList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Attributes on the facet that you are adding to the object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasObjectAttributeList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Attributes on the facet that you are adding to the object.
     */
    public final List<AttributeKeyAndValue> objectAttributeList() {
        return objectAttributeList;
    }

    /**
     * <p>
     * A reference to the object you are adding the specified facet to.
     * </p>
     * 
     * @return A reference to the object you are adding the specified facet to.
     */
    public final ObjectReference objectReference() {
        return objectReference;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(schemaFacet());
        hashCode = 31 * hashCode + Objects.hashCode(hasObjectAttributeList() ? objectAttributeList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(objectReference());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddFacetToObjectRequest)) {
            return false;
        }
        AddFacetToObjectRequest other = (AddFacetToObjectRequest) obj;
        return Objects.equals(directoryArn(), other.directoryArn()) && Objects.equals(schemaFacet(), other.schemaFacet())
                && hasObjectAttributeList() == other.hasObjectAttributeList()
                && Objects.equals(objectAttributeList(), other.objectAttributeList())
                && Objects.equals(objectReference(), other.objectReference());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddFacetToObjectRequest").add("DirectoryArn", directoryArn()).add("SchemaFacet", schemaFacet())
                .add("ObjectAttributeList", hasObjectAttributeList() ? objectAttributeList() : null)
                .add("ObjectReference", objectReference()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryArn":
            return Optional.ofNullable(clazz.cast(directoryArn()));
        case "SchemaFacet":
            return Optional.ofNullable(clazz.cast(schemaFacet()));
        case "ObjectAttributeList":
            return Optional.ofNullable(clazz.cast(objectAttributeList()));
        case "ObjectReference":
            return Optional.ofNullable(clazz.cast(objectReference()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddFacetToObjectRequest, T> g) {
        return obj -> g.apply((AddFacetToObjectRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudDirectoryRequest.Builder, SdkPojo, CopyableBuilder<Builder, AddFacetToObjectRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that is associated with the <a>Directory</a> where the object resides. For
         * more information, see <a>arns</a>.
         * </p>
         * 
         * @param directoryArn
         *        The Amazon Resource Name (ARN) that is associated with the <a>Directory</a> where the object resides.
         *        For more information, see <a>arns</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryArn(String directoryArn);

        /**
         * <p>
         * Identifiers for the facet that you are adding to the object. See <a>SchemaFacet</a> for details.
         * </p>
         * 
         * @param schemaFacet
         *        Identifiers for the facet that you are adding to the object. See <a>SchemaFacet</a> for details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaFacet(SchemaFacet schemaFacet);

        /**
         * <p>
         * Identifiers for the facet that you are adding to the object. See <a>SchemaFacet</a> for details.
         * </p>
         * This is a convenience that creates an instance of the {@link SchemaFacet.Builder} avoiding the need to create
         * one manually via {@link SchemaFacet#builder()}.
         *
         * When the {@link Consumer} completes, {@link SchemaFacet.Builder#build()} is called immediately and its result
         * is passed to {@link #schemaFacet(SchemaFacet)}.
         * 
         * @param schemaFacet
         *        a consumer that will call methods on {@link SchemaFacet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schemaFacet(SchemaFacet)
         */
        default Builder schemaFacet(Consumer<SchemaFacet.Builder> schemaFacet) {
            return schemaFacet(SchemaFacet.builder().applyMutation(schemaFacet).build());
        }

        /**
         * <p>
         * Attributes on the facet that you are adding to the object.
         * </p>
         * 
         * @param objectAttributeList
         *        Attributes on the facet that you are adding to the object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectAttributeList(Collection<AttributeKeyAndValue> objectAttributeList);

        /**
         * <p>
         * Attributes on the facet that you are adding to the object.
         * </p>
         * 
         * @param objectAttributeList
         *        Attributes on the facet that you are adding to the object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectAttributeList(AttributeKeyAndValue... objectAttributeList);

        /**
         * <p>
         * Attributes on the facet that you are adding to the object.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AttributeKeyAndValue>.Builder} avoiding the
         * need to create one manually via {@link List<AttributeKeyAndValue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AttributeKeyAndValue>.Builder#build()} is called immediately
         * and its result is passed to {@link #objectAttributeList(List<AttributeKeyAndValue>)}.
         * 
         * @param objectAttributeList
         *        a consumer that will call methods on {@link List<AttributeKeyAndValue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #objectAttributeList(List<AttributeKeyAndValue>)
         */
        Builder objectAttributeList(Consumer<AttributeKeyAndValue.Builder>... objectAttributeList);

        /**
         * <p>
         * A reference to the object you are adding the specified facet to.
         * </p>
         * 
         * @param objectReference
         *        A reference to the object you are adding the specified facet to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectReference(ObjectReference objectReference);

        /**
         * <p>
         * A reference to the object you are adding the specified facet to.
         * </p>
         * This is a convenience that creates an instance of the {@link ObjectReference.Builder} avoiding the need to
         * create one manually via {@link ObjectReference#builder()}.
         *
         * When the {@link Consumer} completes, {@link ObjectReference.Builder#build()} is called immediately and its
         * result is passed to {@link #objectReference(ObjectReference)}.
         * 
         * @param objectReference
         *        a consumer that will call methods on {@link ObjectReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #objectReference(ObjectReference)
         */
        default Builder objectReference(Consumer<ObjectReference.Builder> objectReference) {
            return objectReference(ObjectReference.builder().applyMutation(objectReference).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudDirectoryRequest.BuilderImpl implements Builder {
        private String directoryArn;

        private SchemaFacet schemaFacet;

        private List<AttributeKeyAndValue> objectAttributeList = DefaultSdkAutoConstructList.getInstance();

        private ObjectReference objectReference;

        private BuilderImpl() {
        }

        private BuilderImpl(AddFacetToObjectRequest model) {
            super(model);
            directoryArn(model.directoryArn);
            schemaFacet(model.schemaFacet);
            objectAttributeList(model.objectAttributeList);
            objectReference(model.objectReference);
        }

        public final String getDirectoryArn() {
            return directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        public final SchemaFacet.Builder getSchemaFacet() {
            return schemaFacet != null ? schemaFacet.toBuilder() : null;
        }

        @Override
        public final Builder schemaFacet(SchemaFacet schemaFacet) {
            this.schemaFacet = schemaFacet;
            return this;
        }

        public final void setSchemaFacet(SchemaFacet.BuilderImpl schemaFacet) {
            this.schemaFacet = schemaFacet != null ? schemaFacet.build() : null;
        }

        public final Collection<AttributeKeyAndValue.Builder> getObjectAttributeList() {
            if (objectAttributeList instanceof SdkAutoConstructList) {
                return null;
            }
            return objectAttributeList != null ? objectAttributeList.stream().map(AttributeKeyAndValue::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder objectAttributeList(Collection<AttributeKeyAndValue> objectAttributeList) {
            this.objectAttributeList = AttributeKeyAndValueListCopier.copy(objectAttributeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectAttributeList(AttributeKeyAndValue... objectAttributeList) {
            objectAttributeList(Arrays.asList(objectAttributeList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectAttributeList(Consumer<AttributeKeyAndValue.Builder>... objectAttributeList) {
            objectAttributeList(Stream.of(objectAttributeList).map(c -> AttributeKeyAndValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setObjectAttributeList(Collection<AttributeKeyAndValue.BuilderImpl> objectAttributeList) {
            this.objectAttributeList = AttributeKeyAndValueListCopier.copyFromBuilder(objectAttributeList);
        }

        public final ObjectReference.Builder getObjectReference() {
            return objectReference != null ? objectReference.toBuilder() : null;
        }

        @Override
        public final Builder objectReference(ObjectReference objectReference) {
            this.objectReference = objectReference;
            return this;
        }

        public final void setObjectReference(ObjectReference.BuilderImpl objectReference) {
            this.objectReference = objectReference != null ? objectReference.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddFacetToObjectRequest build() {
            return new AddFacetToObjectRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
