/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.BatchWriteOperation;
import software.amazon.awssdk.services.clouddirectory.model.BatchWriteOperationListCopier;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchWriteRequest
extends CloudDirectoryRequest
implements ToCopyableBuilder<Builder, BatchWriteRequest> {
    private static final SdkField<String> DIRECTORY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryArn").getter(BatchWriteRequest.getter(BatchWriteRequest::directoryArn)).setter(BatchWriteRequest.setter(Builder::directoryArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-data-partition").build()}).build();
    private static final SdkField<List<BatchWriteOperation>> OPERATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Operations").getter(BatchWriteRequest.getter(BatchWriteRequest::operations)).setter(BatchWriteRequest.setter(Builder::operations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchWriteOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ARN_FIELD, OPERATIONS_FIELD));
    private final String directoryArn;
    private final List<BatchWriteOperation> operations;

    private BatchWriteRequest(BuilderImpl builder) {
        super(builder);
        this.directoryArn = builder.directoryArn;
        this.operations = builder.operations;
    }

    public String directoryArn() {
        return this.directoryArn;
    }

    public boolean hasOperations() {
        return this.operations != null && !(this.operations instanceof SdkAutoConstructList);
    }

    public List<BatchWriteOperation> operations() {
        return this.operations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOperations() ? this.operations() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchWriteRequest)) {
            return false;
        }
        BatchWriteRequest other = (BatchWriteRequest)((Object)obj);
        return Objects.equals(this.directoryArn(), other.directoryArn()) && this.hasOperations() == other.hasOperations() && Objects.equals(this.operations(), other.operations());
    }

    public String toString() {
        return ToString.builder((String)"BatchWriteRequest").add("DirectoryArn", (Object)this.directoryArn()).add("Operations", this.hasOperations() ? this.operations() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryArn": {
                return Optional.ofNullable(clazz.cast(this.directoryArn()));
            }
            case "Operations": {
                return Optional.ofNullable(clazz.cast(this.operations()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchWriteRequest, T> g) {
        return obj -> g.apply((BatchWriteRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudDirectoryRequest.BuilderImpl
    implements Builder {
        private String directoryArn;
        private List<BatchWriteOperation> operations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchWriteRequest model) {
            super(model);
            this.directoryArn(model.directoryArn);
            this.operations(model.operations);
        }

        public final String getDirectoryArn() {
            return this.directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        public final Collection<BatchWriteOperation.Builder> getOperations() {
            if (this.operations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.operations != null ? (Collection)this.operations.stream().map(BatchWriteOperation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder operations(Collection<BatchWriteOperation> operations) {
            this.operations = BatchWriteOperationListCopier.copy(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(BatchWriteOperation ... operations) {
            this.operations(Arrays.asList(operations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(Consumer<BatchWriteOperation.Builder> ... operations) {
            this.operations(Stream.of(operations).map(c -> (BatchWriteOperation)((BatchWriteOperation.Builder)BatchWriteOperation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOperations(Collection<BatchWriteOperation.BuilderImpl> operations) {
            this.operations = BatchWriteOperationListCopier.copyFromBuilder(operations);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchWriteRequest build() {
            return new BatchWriteRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudDirectoryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchWriteRequest> {
        public Builder directoryArn(String var1);

        public Builder operations(Collection<BatchWriteOperation> var1);

        public Builder operations(BatchWriteOperation ... var1);

        public Builder operations(Consumer<BatchWriteOperation.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

