/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.AttributeKeyAndValue;
import software.amazon.awssdk.services.clouddirectory.model.AttributeKeyAndValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchListObjectAttributesResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchListObjectAttributesResponse> {
    private static final SdkField<List<AttributeKeyAndValue>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Attributes").getter(BatchListObjectAttributesResponse.getter(BatchListObjectAttributesResponse::attributes)).setter(BatchListObjectAttributesResponse.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeKeyAndValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(BatchListObjectAttributesResponse.getter(BatchListObjectAttributesResponse::nextToken)).setter(BatchListObjectAttributesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_FIELD, NEXT_TOKEN_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<AttributeKeyAndValue> attributes;
    private final String nextToken;

    private BatchListObjectAttributesResponse(BuilderImpl builder) {
        this.attributes = builder.attributes;
        this.nextToken = builder.nextToken;
    }

    public boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructList);
    }

    public List<AttributeKeyAndValue> attributes() {
        return this.attributes;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchListObjectAttributesResponse)) {
            return false;
        }
        BatchListObjectAttributesResponse other = (BatchListObjectAttributesResponse)obj;
        return this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"BatchListObjectAttributesResponse").add("Attributes", this.hasAttributes() ? this.attributes() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchListObjectAttributesResponse, T> g) {
        return obj -> g.apply((BatchListObjectAttributesResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AttributeKeyAndValue> attributes = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchListObjectAttributesResponse model) {
            this.attributes(model.attributes);
            this.nextToken(model.nextToken);
        }

        public final Collection<AttributeKeyAndValue.Builder> getAttributes() {
            if (this.attributes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.attributes != null ? (Collection)this.attributes.stream().map(AttributeKeyAndValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributes(Collection<AttributeKeyAndValue> attributes) {
            this.attributes = AttributeKeyAndValueListCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(AttributeKeyAndValue ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<AttributeKeyAndValue.Builder> ... attributes) {
            this.attributes(Stream.of(attributes).map(c -> (AttributeKeyAndValue)((AttributeKeyAndValue.Builder)AttributeKeyAndValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttributes(Collection<AttributeKeyAndValue.BuilderImpl> attributes) {
            this.attributes = AttributeKeyAndValueListCopier.copyFromBuilder(attributes);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public BatchListObjectAttributesResponse build() {
            return new BatchListObjectAttributesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchListObjectAttributesResponse> {
        public Builder attributes(Collection<AttributeKeyAndValue> var1);

        public Builder attributes(AttributeKeyAndValue ... var1);

        public Builder attributes(Consumer<AttributeKeyAndValue.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

