/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkSpecifier;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkSpecifierListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchListOutgoingTypedLinksResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchListOutgoingTypedLinksResponse> {
    private static final SdkField<List<TypedLinkSpecifier>> TYPED_LINK_SPECIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TypedLinkSpecifiers").getter(BatchListOutgoingTypedLinksResponse.getter(BatchListOutgoingTypedLinksResponse::typedLinkSpecifiers)).setter(BatchListOutgoingTypedLinksResponse.setter(Builder::typedLinkSpecifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypedLinkSpecifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TypedLinkSpecifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(BatchListOutgoingTypedLinksResponse.getter(BatchListOutgoingTypedLinksResponse::nextToken)).setter(BatchListOutgoingTypedLinksResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPED_LINK_SPECIFIERS_FIELD, NEXT_TOKEN_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<TypedLinkSpecifier> typedLinkSpecifiers;
    private final String nextToken;

    private BatchListOutgoingTypedLinksResponse(BuilderImpl builder) {
        this.typedLinkSpecifiers = builder.typedLinkSpecifiers;
        this.nextToken = builder.nextToken;
    }

    public boolean hasTypedLinkSpecifiers() {
        return this.typedLinkSpecifiers != null && !(this.typedLinkSpecifiers instanceof SdkAutoConstructList);
    }

    public List<TypedLinkSpecifier> typedLinkSpecifiers() {
        return this.typedLinkSpecifiers;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTypedLinkSpecifiers() ? this.typedLinkSpecifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchListOutgoingTypedLinksResponse)) {
            return false;
        }
        BatchListOutgoingTypedLinksResponse other = (BatchListOutgoingTypedLinksResponse)obj;
        return this.hasTypedLinkSpecifiers() == other.hasTypedLinkSpecifiers() && Objects.equals(this.typedLinkSpecifiers(), other.typedLinkSpecifiers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"BatchListOutgoingTypedLinksResponse").add("TypedLinkSpecifiers", this.hasTypedLinkSpecifiers() ? this.typedLinkSpecifiers() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TypedLinkSpecifiers": {
                return Optional.ofNullable(clazz.cast(this.typedLinkSpecifiers()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchListOutgoingTypedLinksResponse, T> g) {
        return obj -> g.apply((BatchListOutgoingTypedLinksResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<TypedLinkSpecifier> typedLinkSpecifiers = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchListOutgoingTypedLinksResponse model) {
            this.typedLinkSpecifiers(model.typedLinkSpecifiers);
            this.nextToken(model.nextToken);
        }

        public final Collection<TypedLinkSpecifier.Builder> getTypedLinkSpecifiers() {
            if (this.typedLinkSpecifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.typedLinkSpecifiers != null ? (Collection)this.typedLinkSpecifiers.stream().map(TypedLinkSpecifier::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder typedLinkSpecifiers(Collection<TypedLinkSpecifier> typedLinkSpecifiers) {
            this.typedLinkSpecifiers = TypedLinkSpecifierListCopier.copy(typedLinkSpecifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder typedLinkSpecifiers(TypedLinkSpecifier ... typedLinkSpecifiers) {
            this.typedLinkSpecifiers(Arrays.asList(typedLinkSpecifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder typedLinkSpecifiers(Consumer<TypedLinkSpecifier.Builder> ... typedLinkSpecifiers) {
            this.typedLinkSpecifiers(Stream.of(typedLinkSpecifiers).map(c -> (TypedLinkSpecifier)((TypedLinkSpecifier.Builder)TypedLinkSpecifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTypedLinkSpecifiers(Collection<TypedLinkSpecifier.BuilderImpl> typedLinkSpecifiers) {
            this.typedLinkSpecifiers = TypedLinkSpecifierListCopier.copyFromBuilder(typedLinkSpecifiers);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public BatchListOutgoingTypedLinksResponse build() {
            return new BatchListOutgoingTypedLinksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchListOutgoingTypedLinksResponse> {
        public Builder typedLinkSpecifiers(Collection<TypedLinkSpecifier> var1);

        public Builder typedLinkSpecifiers(TypedLinkSpecifier ... var1);

        public Builder typedLinkSpecifiers(Consumer<TypedLinkSpecifier.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

