/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryRequest;
import software.amazon.awssdk.services.clouddirectory.model.ConsistencyLevel;
import software.amazon.awssdk.services.clouddirectory.model.ObjectAttributeRange;
import software.amazon.awssdk.services.clouddirectory.model.ObjectAttributeRangeListCopier;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListIndexRequest
extends CloudDirectoryRequest
implements ToCopyableBuilder<Builder, ListIndexRequest> {
    private static final SdkField<String> DIRECTORY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryArn").getter(ListIndexRequest.getter(ListIndexRequest::directoryArn)).setter(ListIndexRequest.setter(Builder::directoryArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-data-partition").build()}).build();
    private static final SdkField<List<ObjectAttributeRange>> RANGES_ON_INDEXED_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RangesOnIndexedValues").getter(ListIndexRequest.getter(ListIndexRequest::rangesOnIndexedValues)).setter(ListIndexRequest.setter(Builder::rangesOnIndexedValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RangesOnIndexedValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ObjectAttributeRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ObjectReference> INDEX_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IndexReference").getter(ListIndexRequest.getter(ListIndexRequest::indexReference)).setter(ListIndexRequest.setter(Builder::indexReference)).constructor(ObjectReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexReference").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListIndexRequest.getter(ListIndexRequest::maxResults)).setter(ListIndexRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListIndexRequest.getter(ListIndexRequest::nextToken)).setter(ListIndexRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> CONSISTENCY_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConsistencyLevel").getter(ListIndexRequest.getter(ListIndexRequest::consistencyLevelAsString)).setter(ListIndexRequest.setter(Builder::consistencyLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-consistency-level").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ARN_FIELD, RANGES_ON_INDEXED_VALUES_FIELD, INDEX_REFERENCE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, CONSISTENCY_LEVEL_FIELD));
    private final String directoryArn;
    private final List<ObjectAttributeRange> rangesOnIndexedValues;
    private final ObjectReference indexReference;
    private final Integer maxResults;
    private final String nextToken;
    private final String consistencyLevel;

    private ListIndexRequest(BuilderImpl builder) {
        super(builder);
        this.directoryArn = builder.directoryArn;
        this.rangesOnIndexedValues = builder.rangesOnIndexedValues;
        this.indexReference = builder.indexReference;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.consistencyLevel = builder.consistencyLevel;
    }

    public String directoryArn() {
        return this.directoryArn;
    }

    public boolean hasRangesOnIndexedValues() {
        return this.rangesOnIndexedValues != null && !(this.rangesOnIndexedValues instanceof SdkAutoConstructList);
    }

    public List<ObjectAttributeRange> rangesOnIndexedValues() {
        return this.rangesOnIndexedValues;
    }

    public ObjectReference indexReference() {
        return this.indexReference;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public ConsistencyLevel consistencyLevel() {
        return ConsistencyLevel.fromValue(this.consistencyLevel);
    }

    public String consistencyLevelAsString() {
        return this.consistencyLevel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.rangesOnIndexedValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.consistencyLevelAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIndexRequest)) {
            return false;
        }
        ListIndexRequest other = (ListIndexRequest)((Object)obj);
        return Objects.equals(this.directoryArn(), other.directoryArn()) && Objects.equals(this.rangesOnIndexedValues(), other.rangesOnIndexedValues()) && Objects.equals(this.indexReference(), other.indexReference()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.consistencyLevelAsString(), other.consistencyLevelAsString());
    }

    public String toString() {
        return ToString.builder((String)"ListIndexRequest").add("DirectoryArn", (Object)this.directoryArn()).add("RangesOnIndexedValues", this.rangesOnIndexedValues()).add("IndexReference", (Object)this.indexReference()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("ConsistencyLevel", (Object)this.consistencyLevelAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryArn": {
                return Optional.ofNullable(clazz.cast(this.directoryArn()));
            }
            case "RangesOnIndexedValues": {
                return Optional.ofNullable(clazz.cast(this.rangesOnIndexedValues()));
            }
            case "IndexReference": {
                return Optional.ofNullable(clazz.cast(this.indexReference()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ConsistencyLevel": {
                return Optional.ofNullable(clazz.cast(this.consistencyLevelAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListIndexRequest, T> g) {
        return obj -> g.apply((ListIndexRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudDirectoryRequest.BuilderImpl
    implements Builder {
        private String directoryArn;
        private List<ObjectAttributeRange> rangesOnIndexedValues = DefaultSdkAutoConstructList.getInstance();
        private ObjectReference indexReference;
        private Integer maxResults;
        private String nextToken;
        private String consistencyLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIndexRequest model) {
            super(model);
            this.directoryArn(model.directoryArn);
            this.rangesOnIndexedValues(model.rangesOnIndexedValues);
            this.indexReference(model.indexReference);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.consistencyLevel(model.consistencyLevel);
        }

        public final String getDirectoryArn() {
            return this.directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        public final Collection<ObjectAttributeRange.Builder> getRangesOnIndexedValues() {
            return this.rangesOnIndexedValues != null ? (Collection)this.rangesOnIndexedValues.stream().map(ObjectAttributeRange::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rangesOnIndexedValues(Collection<ObjectAttributeRange> rangesOnIndexedValues) {
            this.rangesOnIndexedValues = ObjectAttributeRangeListCopier.copy(rangesOnIndexedValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rangesOnIndexedValues(ObjectAttributeRange ... rangesOnIndexedValues) {
            this.rangesOnIndexedValues(Arrays.asList(rangesOnIndexedValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rangesOnIndexedValues(Consumer<ObjectAttributeRange.Builder> ... rangesOnIndexedValues) {
            this.rangesOnIndexedValues(Stream.of(rangesOnIndexedValues).map(c -> (ObjectAttributeRange)((ObjectAttributeRange.Builder)ObjectAttributeRange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRangesOnIndexedValues(Collection<ObjectAttributeRange.BuilderImpl> rangesOnIndexedValues) {
            this.rangesOnIndexedValues = ObjectAttributeRangeListCopier.copyFromBuilder(rangesOnIndexedValues);
        }

        public final ObjectReference.Builder getIndexReference() {
            return this.indexReference != null ? this.indexReference.toBuilder() : null;
        }

        @Override
        public final Builder indexReference(ObjectReference indexReference) {
            this.indexReference = indexReference;
            return this;
        }

        public final void setIndexReference(ObjectReference.BuilderImpl indexReference) {
            this.indexReference = indexReference != null ? indexReference.build() : null;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getConsistencyLevel() {
            return this.consistencyLevel;
        }

        @Override
        public final Builder consistencyLevel(String consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
            return this;
        }

        @Override
        public final Builder consistencyLevel(ConsistencyLevel consistencyLevel) {
            this.consistencyLevel(consistencyLevel == null ? null : consistencyLevel.toString());
            return this;
        }

        public final void setConsistencyLevel(String consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListIndexRequest build() {
            return new ListIndexRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudDirectoryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListIndexRequest> {
        public Builder directoryArn(String var1);

        public Builder rangesOnIndexedValues(Collection<ObjectAttributeRange> var1);

        public Builder rangesOnIndexedValues(ObjectAttributeRange ... var1);

        public Builder rangesOnIndexedValues(Consumer<ObjectAttributeRange.Builder> ... var1);

        public Builder indexReference(ObjectReference var1);

        default public Builder indexReference(Consumer<ObjectReference.Builder> indexReference) {
            return this.indexReference((ObjectReference)((ObjectReference.Builder)ObjectReference.builder().applyMutation(indexReference)).build());
        }

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder consistencyLevel(String var1);

        public Builder consistencyLevel(ConsistencyLevel var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

