/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.AttributeKeyAndValue;
import software.amazon.awssdk.services.clouddirectory.model.AttributeKeyAndValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetObjectAttributesResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchGetObjectAttributesResponse> {
    private static final SdkField<List<AttributeKeyAndValue>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Attributes").getter(BatchGetObjectAttributesResponse.getter(BatchGetObjectAttributesResponse::attributes)).setter(BatchGetObjectAttributesResponse.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeKeyAndValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<AttributeKeyAndValue> attributes;

    private BatchGetObjectAttributesResponse(BuilderImpl builder) {
        this.attributes = builder.attributes;
    }

    public boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructList);
    }

    public List<AttributeKeyAndValue> attributes() {
        return this.attributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetObjectAttributesResponse)) {
            return false;
        }
        BatchGetObjectAttributesResponse other = (BatchGetObjectAttributesResponse)obj;
        return Objects.equals(this.attributes(), other.attributes());
    }

    public String toString() {
        return ToString.builder((String)"BatchGetObjectAttributesResponse").add("Attributes", this.attributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetObjectAttributesResponse, T> g) {
        return obj -> g.apply((BatchGetObjectAttributesResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AttributeKeyAndValue> attributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetObjectAttributesResponse model) {
            this.attributes(model.attributes);
        }

        public final Collection<AttributeKeyAndValue.Builder> getAttributes() {
            return this.attributes != null ? (Collection)this.attributes.stream().map(AttributeKeyAndValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributes(Collection<AttributeKeyAndValue> attributes) {
            this.attributes = AttributeKeyAndValueListCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(AttributeKeyAndValue ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<AttributeKeyAndValue.Builder> ... attributes) {
            this.attributes(Stream.of(attributes).map(c -> (AttributeKeyAndValue)((AttributeKeyAndValue.Builder)AttributeKeyAndValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttributes(Collection<AttributeKeyAndValue.BuilderImpl> attributes) {
            this.attributes = AttributeKeyAndValueListCopier.copyFromBuilder(attributes);
        }

        public BatchGetObjectAttributesResponse build() {
            return new BatchGetObjectAttributesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchGetObjectAttributesResponse> {
        public Builder attributes(Collection<AttributeKeyAndValue> var1);

        public Builder attributes(AttributeKeyAndValue ... var1);

        public Builder attributes(Consumer<AttributeKeyAndValue.Builder> ... var1);
    }
}

