/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.AttributeNameAndValue;
import software.amazon.awssdk.services.clouddirectory.model.AttributeNameAndValueListCopier;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkSchemaAndFacetName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TypedLinkSpecifier
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TypedLinkSpecifier> {
    private static final SdkField<TypedLinkSchemaAndFacetName> TYPED_LINK_FACET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TypedLinkFacet").getter(TypedLinkSpecifier.getter(TypedLinkSpecifier::typedLinkFacet)).setter(TypedLinkSpecifier.setter(Builder::typedLinkFacet)).constructor(TypedLinkSchemaAndFacetName::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypedLinkFacet").build()}).build();
    private static final SdkField<ObjectReference> SOURCE_OBJECT_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceObjectReference").getter(TypedLinkSpecifier.getter(TypedLinkSpecifier::sourceObjectReference)).setter(TypedLinkSpecifier.setter(Builder::sourceObjectReference)).constructor(ObjectReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceObjectReference").build()}).build();
    private static final SdkField<ObjectReference> TARGET_OBJECT_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TargetObjectReference").getter(TypedLinkSpecifier.getter(TypedLinkSpecifier::targetObjectReference)).setter(TypedLinkSpecifier.setter(Builder::targetObjectReference)).constructor(ObjectReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetObjectReference").build()}).build();
    private static final SdkField<List<AttributeNameAndValue>> IDENTITY_ATTRIBUTE_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IdentityAttributeValues").getter(TypedLinkSpecifier.getter(TypedLinkSpecifier::identityAttributeValues)).setter(TypedLinkSpecifier.setter(Builder::identityAttributeValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityAttributeValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeNameAndValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPED_LINK_FACET_FIELD, SOURCE_OBJECT_REFERENCE_FIELD, TARGET_OBJECT_REFERENCE_FIELD, IDENTITY_ATTRIBUTE_VALUES_FIELD));
    private static final long serialVersionUID = 1L;
    private final TypedLinkSchemaAndFacetName typedLinkFacet;
    private final ObjectReference sourceObjectReference;
    private final ObjectReference targetObjectReference;
    private final List<AttributeNameAndValue> identityAttributeValues;

    private TypedLinkSpecifier(BuilderImpl builder) {
        this.typedLinkFacet = builder.typedLinkFacet;
        this.sourceObjectReference = builder.sourceObjectReference;
        this.targetObjectReference = builder.targetObjectReference;
        this.identityAttributeValues = builder.identityAttributeValues;
    }

    public TypedLinkSchemaAndFacetName typedLinkFacet() {
        return this.typedLinkFacet;
    }

    public ObjectReference sourceObjectReference() {
        return this.sourceObjectReference;
    }

    public ObjectReference targetObjectReference() {
        return this.targetObjectReference;
    }

    public boolean hasIdentityAttributeValues() {
        return this.identityAttributeValues != null && !(this.identityAttributeValues instanceof SdkAutoConstructList);
    }

    public List<AttributeNameAndValue> identityAttributeValues() {
        return this.identityAttributeValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typedLinkFacet());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceObjectReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetObjectReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityAttributeValues());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypedLinkSpecifier)) {
            return false;
        }
        TypedLinkSpecifier other = (TypedLinkSpecifier)obj;
        return Objects.equals(this.typedLinkFacet(), other.typedLinkFacet()) && Objects.equals(this.sourceObjectReference(), other.sourceObjectReference()) && Objects.equals(this.targetObjectReference(), other.targetObjectReference()) && Objects.equals(this.identityAttributeValues(), other.identityAttributeValues());
    }

    public String toString() {
        return ToString.builder((String)"TypedLinkSpecifier").add("TypedLinkFacet", (Object)this.typedLinkFacet()).add("SourceObjectReference", (Object)this.sourceObjectReference()).add("TargetObjectReference", (Object)this.targetObjectReference()).add("IdentityAttributeValues", this.identityAttributeValues()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TypedLinkFacet": {
                return Optional.ofNullable(clazz.cast(this.typedLinkFacet()));
            }
            case "SourceObjectReference": {
                return Optional.ofNullable(clazz.cast(this.sourceObjectReference()));
            }
            case "TargetObjectReference": {
                return Optional.ofNullable(clazz.cast(this.targetObjectReference()));
            }
            case "IdentityAttributeValues": {
                return Optional.ofNullable(clazz.cast(this.identityAttributeValues()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TypedLinkSpecifier, T> g) {
        return obj -> g.apply((TypedLinkSpecifier)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private TypedLinkSchemaAndFacetName typedLinkFacet;
        private ObjectReference sourceObjectReference;
        private ObjectReference targetObjectReference;
        private List<AttributeNameAndValue> identityAttributeValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TypedLinkSpecifier model) {
            this.typedLinkFacet(model.typedLinkFacet);
            this.sourceObjectReference(model.sourceObjectReference);
            this.targetObjectReference(model.targetObjectReference);
            this.identityAttributeValues(model.identityAttributeValues);
        }

        public final TypedLinkSchemaAndFacetName.Builder getTypedLinkFacet() {
            return this.typedLinkFacet != null ? this.typedLinkFacet.toBuilder() : null;
        }

        @Override
        public final Builder typedLinkFacet(TypedLinkSchemaAndFacetName typedLinkFacet) {
            this.typedLinkFacet = typedLinkFacet;
            return this;
        }

        public final void setTypedLinkFacet(TypedLinkSchemaAndFacetName.BuilderImpl typedLinkFacet) {
            this.typedLinkFacet = typedLinkFacet != null ? typedLinkFacet.build() : null;
        }

        public final ObjectReference.Builder getSourceObjectReference() {
            return this.sourceObjectReference != null ? this.sourceObjectReference.toBuilder() : null;
        }

        @Override
        public final Builder sourceObjectReference(ObjectReference sourceObjectReference) {
            this.sourceObjectReference = sourceObjectReference;
            return this;
        }

        public final void setSourceObjectReference(ObjectReference.BuilderImpl sourceObjectReference) {
            this.sourceObjectReference = sourceObjectReference != null ? sourceObjectReference.build() : null;
        }

        public final ObjectReference.Builder getTargetObjectReference() {
            return this.targetObjectReference != null ? this.targetObjectReference.toBuilder() : null;
        }

        @Override
        public final Builder targetObjectReference(ObjectReference targetObjectReference) {
            this.targetObjectReference = targetObjectReference;
            return this;
        }

        public final void setTargetObjectReference(ObjectReference.BuilderImpl targetObjectReference) {
            this.targetObjectReference = targetObjectReference != null ? targetObjectReference.build() : null;
        }

        public final Collection<AttributeNameAndValue.Builder> getIdentityAttributeValues() {
            return this.identityAttributeValues != null ? (Collection)this.identityAttributeValues.stream().map(AttributeNameAndValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder identityAttributeValues(Collection<AttributeNameAndValue> identityAttributeValues) {
            this.identityAttributeValues = AttributeNameAndValueListCopier.copy(identityAttributeValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityAttributeValues(AttributeNameAndValue ... identityAttributeValues) {
            this.identityAttributeValues(Arrays.asList(identityAttributeValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityAttributeValues(Consumer<AttributeNameAndValue.Builder> ... identityAttributeValues) {
            this.identityAttributeValues(Stream.of(identityAttributeValues).map(c -> (AttributeNameAndValue)((AttributeNameAndValue.Builder)AttributeNameAndValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIdentityAttributeValues(Collection<AttributeNameAndValue.BuilderImpl> identityAttributeValues) {
            this.identityAttributeValues = AttributeNameAndValueListCopier.copyFromBuilder(identityAttributeValues);
        }

        public TypedLinkSpecifier build() {
            return new TypedLinkSpecifier(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TypedLinkSpecifier> {
        public Builder typedLinkFacet(TypedLinkSchemaAndFacetName var1);

        default public Builder typedLinkFacet(Consumer<TypedLinkSchemaAndFacetName.Builder> typedLinkFacet) {
            return this.typedLinkFacet((TypedLinkSchemaAndFacetName)((TypedLinkSchemaAndFacetName.Builder)TypedLinkSchemaAndFacetName.builder().applyMutation(typedLinkFacet)).build());
        }

        public Builder sourceObjectReference(ObjectReference var1);

        default public Builder sourceObjectReference(Consumer<ObjectReference.Builder> sourceObjectReference) {
            return this.sourceObjectReference((ObjectReference)((ObjectReference.Builder)ObjectReference.builder().applyMutation(sourceObjectReference)).build());
        }

        public Builder targetObjectReference(ObjectReference var1);

        default public Builder targetObjectReference(Consumer<ObjectReference.Builder> targetObjectReference) {
            return this.targetObjectReference((ObjectReference)((ObjectReference.Builder)ObjectReference.builder().applyMutation(targetObjectReference)).build());
        }

        public Builder identityAttributeValues(Collection<AttributeNameAndValue> var1);

        public Builder identityAttributeValues(AttributeNameAndValue ... var1);

        public Builder identityAttributeValues(Consumer<AttributeNameAndValue.Builder> ... var1);
    }
}

