/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.BatchReadOperation;
import software.amazon.awssdk.services.clouddirectory.model.BatchReadOperationListCopier;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryRequest;
import software.amazon.awssdk.services.clouddirectory.model.ConsistencyLevel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchReadRequest
extends CloudDirectoryRequest
implements ToCopyableBuilder<Builder, BatchReadRequest> {
    private static final SdkField<String> DIRECTORY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BatchReadRequest.getter(BatchReadRequest::directoryArn)).setter(BatchReadRequest.setter(Builder::directoryArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-data-partition").build()}).build();
    private static final SdkField<List<BatchReadOperation>> OPERATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BatchReadRequest.getter(BatchReadRequest::operations)).setter(BatchReadRequest.setter(Builder::operations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchReadOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONSISTENCY_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BatchReadRequest.getter(BatchReadRequest::consistencyLevelAsString)).setter(BatchReadRequest.setter(Builder::consistencyLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-consistency-level").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ARN_FIELD, OPERATIONS_FIELD, CONSISTENCY_LEVEL_FIELD));
    private final String directoryArn;
    private final List<BatchReadOperation> operations;
    private final String consistencyLevel;

    private BatchReadRequest(BuilderImpl builder) {
        super(builder);
        this.directoryArn = builder.directoryArn;
        this.operations = builder.operations;
        this.consistencyLevel = builder.consistencyLevel;
    }

    public String directoryArn() {
        return this.directoryArn;
    }

    public boolean hasOperations() {
        return this.operations != null && !(this.operations instanceof SdkAutoConstructList);
    }

    public List<BatchReadOperation> operations() {
        return this.operations;
    }

    public ConsistencyLevel consistencyLevel() {
        return ConsistencyLevel.fromValue(this.consistencyLevel);
    }

    public String consistencyLevelAsString() {
        return this.consistencyLevel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.operations());
        hashCode = 31 * hashCode + Objects.hashCode(this.consistencyLevelAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchReadRequest)) {
            return false;
        }
        BatchReadRequest other = (BatchReadRequest)((Object)obj);
        return Objects.equals(this.directoryArn(), other.directoryArn()) && Objects.equals(this.operations(), other.operations()) && Objects.equals(this.consistencyLevelAsString(), other.consistencyLevelAsString());
    }

    public String toString() {
        return ToString.builder((String)"BatchReadRequest").add("DirectoryArn", (Object)this.directoryArn()).add("Operations", this.operations()).add("ConsistencyLevel", (Object)this.consistencyLevelAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryArn": {
                return Optional.ofNullable(clazz.cast(this.directoryArn()));
            }
            case "Operations": {
                return Optional.ofNullable(clazz.cast(this.operations()));
            }
            case "ConsistencyLevel": {
                return Optional.ofNullable(clazz.cast(this.consistencyLevelAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchReadRequest, T> g) {
        return obj -> g.apply((BatchReadRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudDirectoryRequest.BuilderImpl
    implements Builder {
        private String directoryArn;
        private List<BatchReadOperation> operations = DefaultSdkAutoConstructList.getInstance();
        private String consistencyLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchReadRequest model) {
            super(model);
            this.directoryArn(model.directoryArn);
            this.operations(model.operations);
            this.consistencyLevel(model.consistencyLevel);
        }

        public final String getDirectoryArn() {
            return this.directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        public final Collection<BatchReadOperation.Builder> getOperations() {
            return this.operations != null ? (Collection)this.operations.stream().map(BatchReadOperation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder operations(Collection<BatchReadOperation> operations) {
            this.operations = BatchReadOperationListCopier.copy(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(BatchReadOperation ... operations) {
            this.operations(Arrays.asList(operations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(Consumer<BatchReadOperation.Builder> ... operations) {
            this.operations(Stream.of(operations).map(c -> (BatchReadOperation)((BatchReadOperation.Builder)BatchReadOperation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOperations(Collection<BatchReadOperation.BuilderImpl> operations) {
            this.operations = BatchReadOperationListCopier.copyFromBuilder(operations);
        }

        public final String getConsistencyLevel() {
            return this.consistencyLevel;
        }

        @Override
        public final Builder consistencyLevel(String consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
            return this;
        }

        @Override
        public final Builder consistencyLevel(ConsistencyLevel consistencyLevel) {
            this.consistencyLevel(consistencyLevel == null ? null : consistencyLevel.toString());
            return this;
        }

        public final void setConsistencyLevel(String consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchReadRequest build() {
            return new BatchReadRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudDirectoryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchReadRequest> {
        public Builder directoryArn(String var1);

        public Builder operations(Collection<BatchReadOperation> var1);

        public Builder operations(BatchReadOperation ... var1);

        public Builder operations(Consumer<BatchReadOperation.Builder> ... var1);

        public Builder consistencyLevel(String var1);

        public Builder consistencyLevel(ConsistencyLevel var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

