/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryRequest;
import software.amazon.awssdk.services.clouddirectory.model.ConsistencyLevel;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListObjectParentsRequest
extends CloudDirectoryRequest
implements ToCopyableBuilder<Builder, ListObjectParentsRequest> {
    private static final SdkField<String> DIRECTORY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListObjectParentsRequest.getter(ListObjectParentsRequest::directoryArn)).setter(ListObjectParentsRequest.setter(Builder::directoryArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-data-partition").build()}).build();
    private static final SdkField<ObjectReference> OBJECT_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ListObjectParentsRequest.getter(ListObjectParentsRequest::objectReference)).setter(ListObjectParentsRequest.setter(Builder::objectReference)).constructor(ObjectReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectReference").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListObjectParentsRequest.getter(ListObjectParentsRequest::nextToken)).setter(ListObjectParentsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ListObjectParentsRequest.getter(ListObjectParentsRequest::maxResults)).setter(ListObjectParentsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> CONSISTENCY_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListObjectParentsRequest.getter(ListObjectParentsRequest::consistencyLevelAsString)).setter(ListObjectParentsRequest.setter(Builder::consistencyLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-consistency-level").build()}).build();
    private static final SdkField<Boolean> INCLUDE_ALL_LINKS_TO_EACH_PARENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ListObjectParentsRequest.getter(ListObjectParentsRequest::includeAllLinksToEachParent)).setter(ListObjectParentsRequest.setter(Builder::includeAllLinksToEachParent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeAllLinksToEachParent").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ARN_FIELD, OBJECT_REFERENCE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, CONSISTENCY_LEVEL_FIELD, INCLUDE_ALL_LINKS_TO_EACH_PARENT_FIELD));
    private final String directoryArn;
    private final ObjectReference objectReference;
    private final String nextToken;
    private final Integer maxResults;
    private final String consistencyLevel;
    private final Boolean includeAllLinksToEachParent;

    private ListObjectParentsRequest(BuilderImpl builder) {
        super(builder);
        this.directoryArn = builder.directoryArn;
        this.objectReference = builder.objectReference;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.consistencyLevel = builder.consistencyLevel;
        this.includeAllLinksToEachParent = builder.includeAllLinksToEachParent;
    }

    public String directoryArn() {
        return this.directoryArn;
    }

    public ObjectReference objectReference() {
        return this.objectReference;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public ConsistencyLevel consistencyLevel() {
        return ConsistencyLevel.fromValue(this.consistencyLevel);
    }

    public String consistencyLevelAsString() {
        return this.consistencyLevel;
    }

    public Boolean includeAllLinksToEachParent() {
        return this.includeAllLinksToEachParent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.consistencyLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeAllLinksToEachParent());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListObjectParentsRequest)) {
            return false;
        }
        ListObjectParentsRequest other = (ListObjectParentsRequest)((Object)obj);
        return Objects.equals(this.directoryArn(), other.directoryArn()) && Objects.equals(this.objectReference(), other.objectReference()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.consistencyLevelAsString(), other.consistencyLevelAsString()) && Objects.equals(this.includeAllLinksToEachParent(), other.includeAllLinksToEachParent());
    }

    public String toString() {
        return ToString.builder((String)"ListObjectParentsRequest").add("DirectoryArn", (Object)this.directoryArn()).add("ObjectReference", (Object)this.objectReference()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("ConsistencyLevel", (Object)this.consistencyLevelAsString()).add("IncludeAllLinksToEachParent", (Object)this.includeAllLinksToEachParent()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryArn": {
                return Optional.ofNullable(clazz.cast(this.directoryArn()));
            }
            case "ObjectReference": {
                return Optional.ofNullable(clazz.cast(this.objectReference()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "ConsistencyLevel": {
                return Optional.ofNullable(clazz.cast(this.consistencyLevelAsString()));
            }
            case "IncludeAllLinksToEachParent": {
                return Optional.ofNullable(clazz.cast(this.includeAllLinksToEachParent()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListObjectParentsRequest, T> g) {
        return obj -> g.apply((ListObjectParentsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudDirectoryRequest.BuilderImpl
    implements Builder {
        private String directoryArn;
        private ObjectReference objectReference;
        private String nextToken;
        private Integer maxResults;
        private String consistencyLevel;
        private Boolean includeAllLinksToEachParent;

        private BuilderImpl() {
        }

        private BuilderImpl(ListObjectParentsRequest model) {
            super(model);
            this.directoryArn(model.directoryArn);
            this.objectReference(model.objectReference);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.consistencyLevel(model.consistencyLevel);
            this.includeAllLinksToEachParent(model.includeAllLinksToEachParent);
        }

        public final String getDirectoryArn() {
            return this.directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        public final ObjectReference.Builder getObjectReference() {
            return this.objectReference != null ? this.objectReference.toBuilder() : null;
        }

        @Override
        public final Builder objectReference(ObjectReference objectReference) {
            this.objectReference = objectReference;
            return this;
        }

        public final void setObjectReference(ObjectReference.BuilderImpl objectReference) {
            this.objectReference = objectReference != null ? objectReference.build() : null;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getConsistencyLevel() {
            return this.consistencyLevel;
        }

        @Override
        public final Builder consistencyLevel(String consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
            return this;
        }

        @Override
        public final Builder consistencyLevel(ConsistencyLevel consistencyLevel) {
            this.consistencyLevel(consistencyLevel == null ? null : consistencyLevel.toString());
            return this;
        }

        public final void setConsistencyLevel(String consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
        }

        public final Boolean getIncludeAllLinksToEachParent() {
            return this.includeAllLinksToEachParent;
        }

        @Override
        public final Builder includeAllLinksToEachParent(Boolean includeAllLinksToEachParent) {
            this.includeAllLinksToEachParent = includeAllLinksToEachParent;
            return this;
        }

        public final void setIncludeAllLinksToEachParent(Boolean includeAllLinksToEachParent) {
            this.includeAllLinksToEachParent = includeAllLinksToEachParent;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListObjectParentsRequest build() {
            return new ListObjectParentsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudDirectoryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListObjectParentsRequest> {
        public Builder directoryArn(String var1);

        public Builder objectReference(ObjectReference var1);

        default public Builder objectReference(Consumer<ObjectReference.Builder> objectReference) {
            return this.objectReference((ObjectReference)((ObjectReference.Builder)ObjectReference.builder().applyMutation(objectReference)).build());
        }

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder consistencyLevel(String var1);

        public Builder consistencyLevel(ConsistencyLevel var1);

        public Builder includeAllLinksToEachParent(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

