/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryRequest;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetachPolicyRequest
extends CloudDirectoryRequest
implements ToCopyableBuilder<Builder, DetachPolicyRequest> {
    private static final SdkField<String> DIRECTORY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DetachPolicyRequest.getter(DetachPolicyRequest::directoryArn)).setter(DetachPolicyRequest.setter(Builder::directoryArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-data-partition").build()}).build();
    private static final SdkField<ObjectReference> POLICY_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DetachPolicyRequest.getter(DetachPolicyRequest::policyReference)).setter(DetachPolicyRequest.setter(Builder::policyReference)).constructor(ObjectReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyReference").build()}).build();
    private static final SdkField<ObjectReference> OBJECT_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DetachPolicyRequest.getter(DetachPolicyRequest::objectReference)).setter(DetachPolicyRequest.setter(Builder::objectReference)).constructor(ObjectReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectReference").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ARN_FIELD, POLICY_REFERENCE_FIELD, OBJECT_REFERENCE_FIELD));
    private final String directoryArn;
    private final ObjectReference policyReference;
    private final ObjectReference objectReference;

    private DetachPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.directoryArn = builder.directoryArn;
        this.policyReference = builder.policyReference;
        this.objectReference = builder.objectReference;
    }

    public String directoryArn() {
        return this.directoryArn;
    }

    public ObjectReference policyReference() {
        return this.policyReference;
    }

    public ObjectReference objectReference() {
        return this.objectReference;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectReference());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetachPolicyRequest)) {
            return false;
        }
        DetachPolicyRequest other = (DetachPolicyRequest)((Object)obj);
        return Objects.equals(this.directoryArn(), other.directoryArn()) && Objects.equals(this.policyReference(), other.policyReference()) && Objects.equals(this.objectReference(), other.objectReference());
    }

    public String toString() {
        return ToString.builder((String)"DetachPolicyRequest").add("DirectoryArn", (Object)this.directoryArn()).add("PolicyReference", (Object)this.policyReference()).add("ObjectReference", (Object)this.objectReference()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryArn": {
                return Optional.ofNullable(clazz.cast(this.directoryArn()));
            }
            case "PolicyReference": {
                return Optional.ofNullable(clazz.cast(this.policyReference()));
            }
            case "ObjectReference": {
                return Optional.ofNullable(clazz.cast(this.objectReference()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetachPolicyRequest, T> g) {
        return obj -> g.apply((DetachPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudDirectoryRequest.BuilderImpl
    implements Builder {
        private String directoryArn;
        private ObjectReference policyReference;
        private ObjectReference objectReference;

        private BuilderImpl() {
        }

        private BuilderImpl(DetachPolicyRequest model) {
            super(model);
            this.directoryArn(model.directoryArn);
            this.policyReference(model.policyReference);
            this.objectReference(model.objectReference);
        }

        public final String getDirectoryArn() {
            return this.directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        public final ObjectReference.Builder getPolicyReference() {
            return this.policyReference != null ? this.policyReference.toBuilder() : null;
        }

        @Override
        public final Builder policyReference(ObjectReference policyReference) {
            this.policyReference = policyReference;
            return this;
        }

        public final void setPolicyReference(ObjectReference.BuilderImpl policyReference) {
            this.policyReference = policyReference != null ? policyReference.build() : null;
        }

        public final ObjectReference.Builder getObjectReference() {
            return this.objectReference != null ? this.objectReference.toBuilder() : null;
        }

        @Override
        public final Builder objectReference(ObjectReference objectReference) {
            this.objectReference = objectReference;
            return this;
        }

        public final void setObjectReference(ObjectReference.BuilderImpl objectReference) {
            this.objectReference = objectReference != null ? objectReference.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DetachPolicyRequest build() {
            return new DetachPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudDirectoryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DetachPolicyRequest> {
        public Builder directoryArn(String var1);

        public Builder policyReference(ObjectReference var1);

        default public Builder policyReference(Consumer<ObjectReference.Builder> policyReference) {
            return this.policyReference((ObjectReference)((ObjectReference.Builder)ObjectReference.builder().applyMutation(policyReference)).build());
        }

        public Builder objectReference(ObjectReference var1);

        default public Builder objectReference(Consumer<ObjectReference.Builder> objectReference) {
            return this.objectReference((ObjectReference)((ObjectReference.Builder)ObjectReference.builder().applyMutation(objectReference)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

