/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns the path to the <code>ObjectIdentifiers</code> that is associated with the directory.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PathToObjectIdentifiers implements SdkPojo, Serializable,
        ToCopyableBuilder<PathToObjectIdentifiers.Builder, PathToObjectIdentifiers> {
    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PathToObjectIdentifiers::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()).build();

    private static final SdkField<List<String>> OBJECT_IDENTIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(PathToObjectIdentifiers::objectIdentifiers))
            .setter(setter(Builder::objectIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATH_FIELD,
            OBJECT_IDENTIFIERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String path;

    private final List<String> objectIdentifiers;

    private PathToObjectIdentifiers(BuilderImpl builder) {
        this.path = builder.path;
        this.objectIdentifiers = builder.objectIdentifiers;
    }

    /**
     * <p>
     * The path that is used to identify the object starting from directory root.
     * </p>
     * 
     * @return The path that is used to identify the object starting from directory root.
     */
    public String path() {
        return path;
    }

    /**
     * Returns true if the ObjectIdentifiers property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasObjectIdentifiers() {
        return objectIdentifiers != null && !(objectIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lists <code>ObjectIdentifiers</code> starting from directory root to the object in the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasObjectIdentifiers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Lists <code>ObjectIdentifiers</code> starting from directory root to the object in the request.
     */
    public List<String> objectIdentifiers() {
        return objectIdentifiers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(objectIdentifiers());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PathToObjectIdentifiers)) {
            return false;
        }
        PathToObjectIdentifiers other = (PathToObjectIdentifiers) obj;
        return Objects.equals(path(), other.path()) && Objects.equals(objectIdentifiers(), other.objectIdentifiers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PathToObjectIdentifiers").add("Path", path()).add("ObjectIdentifiers", objectIdentifiers())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Path":
            return Optional.ofNullable(clazz.cast(path()));
        case "ObjectIdentifiers":
            return Optional.ofNullable(clazz.cast(objectIdentifiers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PathToObjectIdentifiers, T> g) {
        return obj -> g.apply((PathToObjectIdentifiers) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PathToObjectIdentifiers> {
        /**
         * <p>
         * The path that is used to identify the object starting from directory root.
         * </p>
         * 
         * @param path
         *        The path that is used to identify the object starting from directory root.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * <p>
         * Lists <code>ObjectIdentifiers</code> starting from directory root to the object in the request.
         * </p>
         * 
         * @param objectIdentifiers
         *        Lists <code>ObjectIdentifiers</code> starting from directory root to the object in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectIdentifiers(Collection<String> objectIdentifiers);

        /**
         * <p>
         * Lists <code>ObjectIdentifiers</code> starting from directory root to the object in the request.
         * </p>
         * 
         * @param objectIdentifiers
         *        Lists <code>ObjectIdentifiers</code> starting from directory root to the object in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectIdentifiers(String... objectIdentifiers);
    }

    static final class BuilderImpl implements Builder {
        private String path;

        private List<String> objectIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PathToObjectIdentifiers model) {
            path(model.path);
            objectIdentifiers(model.objectIdentifiers);
        }

        public final String getPath() {
            return path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final Collection<String> getObjectIdentifiers() {
            return objectIdentifiers;
        }

        @Override
        public final Builder objectIdentifiers(Collection<String> objectIdentifiers) {
            this.objectIdentifiers = ObjectIdentifierListCopier.copy(objectIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectIdentifiers(String... objectIdentifiers) {
            objectIdentifiers(Arrays.asList(objectIdentifiers));
            return this;
        }

        public final void setObjectIdentifiers(Collection<String> objectIdentifiers) {
            this.objectIdentifiers = ObjectIdentifierListCopier.copy(objectIdentifiers);
        }

        @Override
        public PathToObjectIdentifiers build() {
            return new PathToObjectIdentifiers(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
