/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A range of attributes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ObjectAttributeRange implements SdkPojo, Serializable,
        ToCopyableBuilder<ObjectAttributeRange.Builder, ObjectAttributeRange> {
    private static final SdkField<AttributeKey> ATTRIBUTE_KEY_FIELD = SdkField.<AttributeKey> builder(MarshallingType.SDK_POJO)
            .getter(getter(ObjectAttributeRange::attributeKey)).setter(setter(Builder::attributeKey))
            .constructor(AttributeKey::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeKey").build()).build();

    private static final SdkField<TypedAttributeValueRange> RANGE_FIELD = SdkField
            .<TypedAttributeValueRange> builder(MarshallingType.SDK_POJO).getter(getter(ObjectAttributeRange::range))
            .setter(setter(Builder::range)).constructor(TypedAttributeValueRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Range").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_KEY_FIELD,
            RANGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final AttributeKey attributeKey;

    private final TypedAttributeValueRange range;

    private ObjectAttributeRange(BuilderImpl builder) {
        this.attributeKey = builder.attributeKey;
        this.range = builder.range;
    }

    /**
     * <p>
     * The key of the attribute that the attribute range covers.
     * </p>
     * 
     * @return The key of the attribute that the attribute range covers.
     */
    public AttributeKey attributeKey() {
        return attributeKey;
    }

    /**
     * <p>
     * The range of attribute values being selected.
     * </p>
     * 
     * @return The range of attribute values being selected.
     */
    public TypedAttributeValueRange range() {
        return range;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributeKey());
        hashCode = 31 * hashCode + Objects.hashCode(range());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObjectAttributeRange)) {
            return false;
        }
        ObjectAttributeRange other = (ObjectAttributeRange) obj;
        return Objects.equals(attributeKey(), other.attributeKey()) && Objects.equals(range(), other.range());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ObjectAttributeRange").add("AttributeKey", attributeKey()).add("Range", range()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttributeKey":
            return Optional.ofNullable(clazz.cast(attributeKey()));
        case "Range":
            return Optional.ofNullable(clazz.cast(range()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ObjectAttributeRange, T> g) {
        return obj -> g.apply((ObjectAttributeRange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ObjectAttributeRange> {
        /**
         * <p>
         * The key of the attribute that the attribute range covers.
         * </p>
         * 
         * @param attributeKey
         *        The key of the attribute that the attribute range covers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeKey(AttributeKey attributeKey);

        /**
         * <p>
         * The key of the attribute that the attribute range covers.
         * </p>
         * This is a convenience that creates an instance of the {@link AttributeKey.Builder} avoiding the need to
         * create one manually via {@link AttributeKey#builder()}.
         *
         * When the {@link Consumer} completes, {@link AttributeKey.Builder#build()} is called immediately and its
         * result is passed to {@link #attributeKey(AttributeKey)}.
         * 
         * @param attributeKey
         *        a consumer that will call methods on {@link AttributeKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributeKey(AttributeKey)
         */
        default Builder attributeKey(Consumer<AttributeKey.Builder> attributeKey) {
            return attributeKey(AttributeKey.builder().applyMutation(attributeKey).build());
        }

        /**
         * <p>
         * The range of attribute values being selected.
         * </p>
         * 
         * @param range
         *        The range of attribute values being selected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder range(TypedAttributeValueRange range);

        /**
         * <p>
         * The range of attribute values being selected.
         * </p>
         * This is a convenience that creates an instance of the {@link TypedAttributeValueRange.Builder} avoiding the
         * need to create one manually via {@link TypedAttributeValueRange#builder()}.
         *
         * When the {@link Consumer} completes, {@link TypedAttributeValueRange.Builder#build()} is called immediately
         * and its result is passed to {@link #range(TypedAttributeValueRange)}.
         * 
         * @param range
         *        a consumer that will call methods on {@link TypedAttributeValueRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #range(TypedAttributeValueRange)
         */
        default Builder range(Consumer<TypedAttributeValueRange.Builder> range) {
            return range(TypedAttributeValueRange.builder().applyMutation(range).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AttributeKey attributeKey;

        private TypedAttributeValueRange range;

        private BuilderImpl() {
        }

        private BuilderImpl(ObjectAttributeRange model) {
            attributeKey(model.attributeKey);
            range(model.range);
        }

        public final AttributeKey.Builder getAttributeKey() {
            return attributeKey != null ? attributeKey.toBuilder() : null;
        }

        @Override
        public final Builder attributeKey(AttributeKey attributeKey) {
            this.attributeKey = attributeKey;
            return this;
        }

        public final void setAttributeKey(AttributeKey.BuilderImpl attributeKey) {
            this.attributeKey = attributeKey != null ? attributeKey.build() : null;
        }

        public final TypedAttributeValueRange.Builder getRange() {
            return range != null ? range.toBuilder() : null;
        }

        @Override
        public final Builder range(TypedAttributeValueRange range) {
            this.range = range;
            return this;
        }

        public final void setRange(TypedAttributeValueRange.BuilderImpl range) {
            this.range = range != null ? range.build() : null;
        }

        @Override
        public ObjectAttributeRange build() {
            return new ObjectAttributeRange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
