/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The action to take on the object attribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ObjectAttributeAction implements SdkPojo, Serializable,
        ToCopyableBuilder<ObjectAttributeAction.Builder, ObjectAttributeAction> {
    private static final SdkField<String> OBJECT_ATTRIBUTE_ACTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ObjectAttributeAction::objectAttributeActionTypeAsString))
            .setter(setter(Builder::objectAttributeActionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectAttributeActionType").build())
            .build();

    private static final SdkField<TypedAttributeValue> OBJECT_ATTRIBUTE_UPDATE_VALUE_FIELD = SdkField
            .<TypedAttributeValue> builder(MarshallingType.SDK_POJO)
            .getter(getter(ObjectAttributeAction::objectAttributeUpdateValue))
            .setter(setter(Builder::objectAttributeUpdateValue))
            .constructor(TypedAttributeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectAttributeUpdateValue").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            OBJECT_ATTRIBUTE_ACTION_TYPE_FIELD, OBJECT_ATTRIBUTE_UPDATE_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String objectAttributeActionType;

    private final TypedAttributeValue objectAttributeUpdateValue;

    private ObjectAttributeAction(BuilderImpl builder) {
        this.objectAttributeActionType = builder.objectAttributeActionType;
        this.objectAttributeUpdateValue = builder.objectAttributeUpdateValue;
    }

    /**
     * <p>
     * A type that can be either <code>Update</code> or <code>Delete</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #objectAttributeActionType} will return {@link UpdateActionType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #objectAttributeActionTypeAsString}.
     * </p>
     * 
     * @return A type that can be either <code>Update</code> or <code>Delete</code>.
     * @see UpdateActionType
     */
    public UpdateActionType objectAttributeActionType() {
        return UpdateActionType.fromValue(objectAttributeActionType);
    }

    /**
     * <p>
     * A type that can be either <code>Update</code> or <code>Delete</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #objectAttributeActionType} will return {@link UpdateActionType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #objectAttributeActionTypeAsString}.
     * </p>
     * 
     * @return A type that can be either <code>Update</code> or <code>Delete</code>.
     * @see UpdateActionType
     */
    public String objectAttributeActionTypeAsString() {
        return objectAttributeActionType;
    }

    /**
     * <p>
     * The value that you want to update to.
     * </p>
     * 
     * @return The value that you want to update to.
     */
    public TypedAttributeValue objectAttributeUpdateValue() {
        return objectAttributeUpdateValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(objectAttributeActionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(objectAttributeUpdateValue());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObjectAttributeAction)) {
            return false;
        }
        ObjectAttributeAction other = (ObjectAttributeAction) obj;
        return Objects.equals(objectAttributeActionTypeAsString(), other.objectAttributeActionTypeAsString())
                && Objects.equals(objectAttributeUpdateValue(), other.objectAttributeUpdateValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ObjectAttributeAction").add("ObjectAttributeActionType", objectAttributeActionTypeAsString())
                .add("ObjectAttributeUpdateValue", objectAttributeUpdateValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ObjectAttributeActionType":
            return Optional.ofNullable(clazz.cast(objectAttributeActionTypeAsString()));
        case "ObjectAttributeUpdateValue":
            return Optional.ofNullable(clazz.cast(objectAttributeUpdateValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ObjectAttributeAction, T> g) {
        return obj -> g.apply((ObjectAttributeAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ObjectAttributeAction> {
        /**
         * <p>
         * A type that can be either <code>Update</code> or <code>Delete</code>.
         * </p>
         * 
         * @param objectAttributeActionType
         *        A type that can be either <code>Update</code> or <code>Delete</code>.
         * @see UpdateActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateActionType
         */
        Builder objectAttributeActionType(String objectAttributeActionType);

        /**
         * <p>
         * A type that can be either <code>Update</code> or <code>Delete</code>.
         * </p>
         * 
         * @param objectAttributeActionType
         *        A type that can be either <code>Update</code> or <code>Delete</code>.
         * @see UpdateActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateActionType
         */
        Builder objectAttributeActionType(UpdateActionType objectAttributeActionType);

        /**
         * <p>
         * The value that you want to update to.
         * </p>
         * 
         * @param objectAttributeUpdateValue
         *        The value that you want to update to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectAttributeUpdateValue(TypedAttributeValue objectAttributeUpdateValue);

        /**
         * <p>
         * The value that you want to update to.
         * </p>
         * This is a convenience that creates an instance of the {@link TypedAttributeValue.Builder} avoiding the need
         * to create one manually via {@link TypedAttributeValue#builder()}.
         *
         * When the {@link Consumer} completes, {@link TypedAttributeValue.Builder#build()} is called immediately and
         * its result is passed to {@link #objectAttributeUpdateValue(TypedAttributeValue)}.
         * 
         * @param objectAttributeUpdateValue
         *        a consumer that will call methods on {@link TypedAttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #objectAttributeUpdateValue(TypedAttributeValue)
         */
        default Builder objectAttributeUpdateValue(Consumer<TypedAttributeValue.Builder> objectAttributeUpdateValue) {
            return objectAttributeUpdateValue(TypedAttributeValue.builder().applyMutation(objectAttributeUpdateValue).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String objectAttributeActionType;

        private TypedAttributeValue objectAttributeUpdateValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ObjectAttributeAction model) {
            objectAttributeActionType(model.objectAttributeActionType);
            objectAttributeUpdateValue(model.objectAttributeUpdateValue);
        }

        public final String getObjectAttributeActionType() {
            return objectAttributeActionType;
        }

        @Override
        public final Builder objectAttributeActionType(String objectAttributeActionType) {
            this.objectAttributeActionType = objectAttributeActionType;
            return this;
        }

        @Override
        public final Builder objectAttributeActionType(UpdateActionType objectAttributeActionType) {
            this.objectAttributeActionType(objectAttributeActionType == null ? null : objectAttributeActionType.toString());
            return this;
        }

        public final void setObjectAttributeActionType(String objectAttributeActionType) {
            this.objectAttributeActionType = objectAttributeActionType;
        }

        public final TypedAttributeValue.Builder getObjectAttributeUpdateValue() {
            return objectAttributeUpdateValue != null ? objectAttributeUpdateValue.toBuilder() : null;
        }

        @Override
        public final Builder objectAttributeUpdateValue(TypedAttributeValue objectAttributeUpdateValue) {
            this.objectAttributeUpdateValue = objectAttributeUpdateValue;
            return this;
        }

        public final void setObjectAttributeUpdateValue(TypedAttributeValue.BuilderImpl objectAttributeUpdateValue) {
            this.objectAttributeUpdateValue = objectAttributeUpdateValue != null ? objectAttributeUpdateValue.build() : null;
        }

        @Override
        public ObjectAttributeAction build() {
            return new ObjectAttributeAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
