/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListObjectChildrenResponse extends CloudDirectoryResponse implements
        ToCopyableBuilder<ListObjectChildrenResponse.Builder, ListObjectChildrenResponse> {
    private static final SdkField<Map<String, String>> CHILDREN_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(ListObjectChildrenResponse::children))
            .setter(setter(Builder::children))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Children").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListObjectChildrenResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHILDREN_FIELD,
            NEXT_TOKEN_FIELD));

    private final Map<String, String> children;

    private final String nextToken;

    private ListObjectChildrenResponse(BuilderImpl builder) {
        super(builder);
        this.children = builder.children;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Children property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasChildren() {
        return children != null && !(children instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Children structure, which is a map with key as the <code>LinkName</code> and <code>ObjectIdentifier</code> as the
     * value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasChildren()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Children structure, which is a map with key as the <code>LinkName</code> and
     *         <code>ObjectIdentifier</code> as the value.
     */
    public Map<String, String> children() {
        return children;
    }

    /**
     * <p>
     * The pagination token.
     * </p>
     * 
     * @return The pagination token.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(children());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListObjectChildrenResponse)) {
            return false;
        }
        ListObjectChildrenResponse other = (ListObjectChildrenResponse) obj;
        return Objects.equals(children(), other.children()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListObjectChildrenResponse").add("Children", children()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Children":
            return Optional.ofNullable(clazz.cast(children()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListObjectChildrenResponse, T> g) {
        return obj -> g.apply((ListObjectChildrenResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudDirectoryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListObjectChildrenResponse> {
        /**
         * <p>
         * Children structure, which is a map with key as the <code>LinkName</code> and <code>ObjectIdentifier</code> as
         * the value.
         * </p>
         * 
         * @param children
         *        Children structure, which is a map with key as the <code>LinkName</code> and
         *        <code>ObjectIdentifier</code> as the value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder children(Map<String, String> children);

        /**
         * <p>
         * The pagination token.
         * </p>
         * 
         * @param nextToken
         *        The pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudDirectoryResponse.BuilderImpl implements Builder {
        private Map<String, String> children = DefaultSdkAutoConstructMap.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListObjectChildrenResponse model) {
            super(model);
            children(model.children);
            nextToken(model.nextToken);
        }

        public final Map<String, String> getChildren() {
            return children;
        }

        @Override
        public final Builder children(Map<String, String> children) {
            this.children = LinkNameToObjectIdentifierMapCopier.copy(children);
            return this;
        }

        public final void setChildren(Map<String, String> children) {
            this.children = LinkNameToObjectIdentifierMapCopier.copy(children);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListObjectChildrenResponse build() {
            return new ListObjectChildrenResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
