/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFacetAttributesResponse extends CloudDirectoryResponse implements
        ToCopyableBuilder<ListFacetAttributesResponse.Builder, ListFacetAttributesResponse> {
    private static final SdkField<List<FacetAttribute>> ATTRIBUTES_FIELD = SdkField
            .<List<FacetAttribute>> builder(MarshallingType.LIST)
            .getter(getter(ListFacetAttributesResponse::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FacetAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(FacetAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListFacetAttributesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<FacetAttribute> attributes;

    private final String nextToken;

    private ListFacetAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.attributes = builder.attributes;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Attributes property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The attributes attached to the facet.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The attributes attached to the facet.
     */
    public List<FacetAttribute> attributes() {
        return attributes;
    }

    /**
     * <p>
     * The pagination token.
     * </p>
     * 
     * @return The pagination token.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFacetAttributesResponse)) {
            return false;
        }
        ListFacetAttributesResponse other = (ListFacetAttributesResponse) obj;
        return Objects.equals(attributes(), other.attributes()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListFacetAttributesResponse").add("Attributes", attributes()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFacetAttributesResponse, T> g) {
        return obj -> g.apply((ListFacetAttributesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudDirectoryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListFacetAttributesResponse> {
        /**
         * <p>
         * The attributes attached to the facet.
         * </p>
         * 
         * @param attributes
         *        The attributes attached to the facet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Collection<FacetAttribute> attributes);

        /**
         * <p>
         * The attributes attached to the facet.
         * </p>
         * 
         * @param attributes
         *        The attributes attached to the facet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(FacetAttribute... attributes);

        /**
         * <p>
         * The attributes attached to the facet.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FacetAttribute>.Builder} avoiding the need
         * to create one manually via {@link List<FacetAttribute>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FacetAttribute>.Builder#build()} is called immediately and
         * its result is passed to {@link #attributes(List<FacetAttribute>)}.
         * 
         * @param attributes
         *        a consumer that will call methods on {@link List<FacetAttribute>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributes(List<FacetAttribute>)
         */
        Builder attributes(Consumer<FacetAttribute.Builder>... attributes);

        /**
         * <p>
         * The pagination token.
         * </p>
         * 
         * @param nextToken
         *        The pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudDirectoryResponse.BuilderImpl implements Builder {
        private List<FacetAttribute> attributes = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFacetAttributesResponse model) {
            super(model);
            attributes(model.attributes);
            nextToken(model.nextToken);
        }

        public final Collection<FacetAttribute.Builder> getAttributes() {
            return attributes != null ? attributes.stream().map(FacetAttribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributes(Collection<FacetAttribute> attributes) {
            this.attributes = FacetAttributeListCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(FacetAttribute... attributes) {
            attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<FacetAttribute.Builder>... attributes) {
            attributes(Stream.of(attributes).map(c -> FacetAttribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAttributes(Collection<FacetAttribute.BuilderImpl> attributes) {
            this.attributes = FacetAttributeListCopier.copyFromBuilder(attributes);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListFacetAttributesResponse build() {
            return new ListFacetAttributesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
