/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetachFromIndexResponse extends CloudDirectoryResponse implements
        ToCopyableBuilder<DetachFromIndexResponse.Builder, DetachFromIndexResponse> {
    private static final SdkField<String> DETACHED_OBJECT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DetachFromIndexResponse::detachedObjectIdentifier)).setter(setter(Builder::detachedObjectIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetachedObjectIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DETACHED_OBJECT_IDENTIFIER_FIELD));

    private final String detachedObjectIdentifier;

    private DetachFromIndexResponse(BuilderImpl builder) {
        super(builder);
        this.detachedObjectIdentifier = builder.detachedObjectIdentifier;
    }

    /**
     * <p>
     * The <code>ObjectIdentifier</code> of the object that was detached from the index.
     * </p>
     * 
     * @return The <code>ObjectIdentifier</code> of the object that was detached from the index.
     */
    public String detachedObjectIdentifier() {
        return detachedObjectIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(detachedObjectIdentifier());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetachFromIndexResponse)) {
            return false;
        }
        DetachFromIndexResponse other = (DetachFromIndexResponse) obj;
        return Objects.equals(detachedObjectIdentifier(), other.detachedObjectIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DetachFromIndexResponse").add("DetachedObjectIdentifier", detachedObjectIdentifier()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DetachedObjectIdentifier":
            return Optional.ofNullable(clazz.cast(detachedObjectIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetachFromIndexResponse, T> g) {
        return obj -> g.apply((DetachFromIndexResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudDirectoryResponse.Builder, SdkPojo, CopyableBuilder<Builder, DetachFromIndexResponse> {
        /**
         * <p>
         * The <code>ObjectIdentifier</code> of the object that was detached from the index.
         * </p>
         * 
         * @param detachedObjectIdentifier
         *        The <code>ObjectIdentifier</code> of the object that was detached from the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detachedObjectIdentifier(String detachedObjectIdentifier);
    }

    static final class BuilderImpl extends CloudDirectoryResponse.BuilderImpl implements Builder {
        private String detachedObjectIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(DetachFromIndexResponse model) {
            super(model);
            detachedObjectIdentifier(model.detachedObjectIdentifier);
        }

        public final String getDetachedObjectIdentifier() {
            return detachedObjectIdentifier;
        }

        @Override
        public final Builder detachedObjectIdentifier(String detachedObjectIdentifier) {
            this.detachedObjectIdentifier = detachedObjectIdentifier;
            return this;
        }

        public final void setDetachedObjectIdentifier(String detachedObjectIdentifier) {
            this.detachedObjectIdentifier = detachedObjectIdentifier;
        }

        @Override
        public DetachFromIndexResponse build() {
            return new DetachFromIndexResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
