/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFacetRequest extends CloudDirectoryRequest implements
        ToCopyableBuilder<CreateFacetRequest.Builder, CreateFacetRequest> {
    private static final SdkField<String> SCHEMA_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateFacetRequest::schemaArn)).setter(setter(Builder::schemaArn))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-data-partition").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateFacetRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<FacetAttribute>> ATTRIBUTES_FIELD = SdkField
            .<List<FacetAttribute>> builder(MarshallingType.LIST)
            .getter(getter(CreateFacetRequest::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FacetAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(FacetAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> OBJECT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateFacetRequest::objectTypeAsString)).setter(setter(Builder::objectType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectType").build()).build();

    private static final SdkField<String> FACET_STYLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateFacetRequest::facetStyleAsString)).setter(setter(Builder::facetStyle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FacetStyle").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_ARN_FIELD, NAME_FIELD,
            ATTRIBUTES_FIELD, OBJECT_TYPE_FIELD, FACET_STYLE_FIELD));

    private final String schemaArn;

    private final String name;

    private final List<FacetAttribute> attributes;

    private final String objectType;

    private final String facetStyle;

    private CreateFacetRequest(BuilderImpl builder) {
        super(builder);
        this.schemaArn = builder.schemaArn;
        this.name = builder.name;
        this.attributes = builder.attributes;
        this.objectType = builder.objectType;
        this.facetStyle = builder.facetStyle;
    }

    /**
     * <p>
     * The schema ARN in which the new <a>Facet</a> will be created. For more information, see <a>arns</a>.
     * </p>
     * 
     * @return The schema ARN in which the new <a>Facet</a> will be created. For more information, see <a>arns</a>.
     */
    public String schemaArn() {
        return schemaArn;
    }

    /**
     * <p>
     * The name of the <a>Facet</a>, which is unique for a given schema.
     * </p>
     * 
     * @return The name of the <a>Facet</a>, which is unique for a given schema.
     */
    public String name() {
        return name;
    }

    /**
     * Returns true if the Attributes property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The attributes that are associated with the <a>Facet</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The attributes that are associated with the <a>Facet</a>.
     */
    public List<FacetAttribute> attributes() {
        return attributes;
    }

    /**
     * <p>
     * Specifies whether a given object created from this facet is of type node, leaf node, policy or index.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Node: Can have multiple children but one parent.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * Leaf node: Cannot have children but can have multiple parents.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * Policy: Allows you to store a policy document and policy type. For more information, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies"
     * >Policies</a>.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * Index: Can be created with the Index API.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #objectType} will
     * return {@link ObjectType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #objectTypeAsString}.
     * </p>
     * 
     * @return Specifies whether a given object created from this facet is of type node, leaf node, policy or index.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Node: Can have multiple children but one parent.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         Leaf node: Cannot have children but can have multiple parents.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         Policy: Allows you to store a policy document and policy type. For more information, see <a href=
     *         "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies"
     *         >Policies</a>.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         Index: Can be created with the Index API.
     *         </p>
     *         </li>
     * @see ObjectType
     */
    public ObjectType objectType() {
        return ObjectType.fromValue(objectType);
    }

    /**
     * <p>
     * Specifies whether a given object created from this facet is of type node, leaf node, policy or index.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Node: Can have multiple children but one parent.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * Leaf node: Cannot have children but can have multiple parents.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * Policy: Allows you to store a policy document and policy type. For more information, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies"
     * >Policies</a>.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * Index: Can be created with the Index API.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #objectType} will
     * return {@link ObjectType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #objectTypeAsString}.
     * </p>
     * 
     * @return Specifies whether a given object created from this facet is of type node, leaf node, policy or index.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Node: Can have multiple children but one parent.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         Leaf node: Cannot have children but can have multiple parents.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         Policy: Allows you to store a policy document and policy type. For more information, see <a href=
     *         "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies"
     *         >Policies</a>.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         Index: Can be created with the Index API.
     *         </p>
     *         </li>
     * @see ObjectType
     */
    public String objectTypeAsString() {
        return objectType;
    }

    /**
     * <p>
     * There are two different styles that you can define on any given facet, <code>Static</code> and
     * <code>Dynamic</code>. For static facets, all attributes must be defined in the schema. For dynamic facets,
     * attributes can be defined during data plane operations.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #facetStyle} will
     * return {@link FacetStyle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #facetStyleAsString}.
     * </p>
     * 
     * @return There are two different styles that you can define on any given facet, <code>Static</code> and
     *         <code>Dynamic</code>. For static facets, all attributes must be defined in the schema. For dynamic
     *         facets, attributes can be defined during data plane operations.
     * @see FacetStyle
     */
    public FacetStyle facetStyle() {
        return FacetStyle.fromValue(facetStyle);
    }

    /**
     * <p>
     * There are two different styles that you can define on any given facet, <code>Static</code> and
     * <code>Dynamic</code>. For static facets, all attributes must be defined in the schema. For dynamic facets,
     * attributes can be defined during data plane operations.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #facetStyle} will
     * return {@link FacetStyle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #facetStyleAsString}.
     * </p>
     * 
     * @return There are two different styles that you can define on any given facet, <code>Static</code> and
     *         <code>Dynamic</code>. For static facets, all attributes must be defined in the schema. For dynamic
     *         facets, attributes can be defined during data plane operations.
     * @see FacetStyle
     */
    public String facetStyleAsString() {
        return facetStyle;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(schemaArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        hashCode = 31 * hashCode + Objects.hashCode(objectTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(facetStyleAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFacetRequest)) {
            return false;
        }
        CreateFacetRequest other = (CreateFacetRequest) obj;
        return Objects.equals(schemaArn(), other.schemaArn()) && Objects.equals(name(), other.name())
                && Objects.equals(attributes(), other.attributes())
                && Objects.equals(objectTypeAsString(), other.objectTypeAsString())
                && Objects.equals(facetStyleAsString(), other.facetStyleAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateFacetRequest").add("SchemaArn", schemaArn()).add("Name", name())
                .add("Attributes", attributes()).add("ObjectType", objectTypeAsString()).add("FacetStyle", facetStyleAsString())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SchemaArn":
            return Optional.ofNullable(clazz.cast(schemaArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "ObjectType":
            return Optional.ofNullable(clazz.cast(objectTypeAsString()));
        case "FacetStyle":
            return Optional.ofNullable(clazz.cast(facetStyleAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFacetRequest, T> g) {
        return obj -> g.apply((CreateFacetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudDirectoryRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateFacetRequest> {
        /**
         * <p>
         * The schema ARN in which the new <a>Facet</a> will be created. For more information, see <a>arns</a>.
         * </p>
         * 
         * @param schemaArn
         *        The schema ARN in which the new <a>Facet</a> will be created. For more information, see <a>arns</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaArn(String schemaArn);

        /**
         * <p>
         * The name of the <a>Facet</a>, which is unique for a given schema.
         * </p>
         * 
         * @param name
         *        The name of the <a>Facet</a>, which is unique for a given schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The attributes that are associated with the <a>Facet</a>.
         * </p>
         * 
         * @param attributes
         *        The attributes that are associated with the <a>Facet</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Collection<FacetAttribute> attributes);

        /**
         * <p>
         * The attributes that are associated with the <a>Facet</a>.
         * </p>
         * 
         * @param attributes
         *        The attributes that are associated with the <a>Facet</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(FacetAttribute... attributes);

        /**
         * <p>
         * The attributes that are associated with the <a>Facet</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FacetAttribute>.Builder} avoiding the need
         * to create one manually via {@link List<FacetAttribute>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FacetAttribute>.Builder#build()} is called immediately and
         * its result is passed to {@link #attributes(List<FacetAttribute>)}.
         * 
         * @param attributes
         *        a consumer that will call methods on {@link List<FacetAttribute>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributes(List<FacetAttribute>)
         */
        Builder attributes(Consumer<FacetAttribute.Builder>... attributes);

        /**
         * <p>
         * Specifies whether a given object created from this facet is of type node, leaf node, policy or index.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Node: Can have multiple children but one parent.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * Leaf node: Cannot have children but can have multiple parents.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * Policy: Allows you to store a policy document and policy type. For more information, see <a href=
         * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies"
         * >Policies</a>.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * Index: Can be created with the Index API.
         * </p>
         * </li>
         * </ul>
         * 
         * @param objectType
         *        Specifies whether a given object created from this facet is of type node, leaf node, policy or
         *        index.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Node: Can have multiple children but one parent.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        Leaf node: Cannot have children but can have multiple parents.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        Policy: Allows you to store a policy document and policy type. For more information, see <a href=
         *        "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies"
         *        >Policies</a>.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        Index: Can be created with the Index API.
         *        </p>
         *        </li>
         * @see ObjectType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectType
         */
        Builder objectType(String objectType);

        /**
         * <p>
         * Specifies whether a given object created from this facet is of type node, leaf node, policy or index.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Node: Can have multiple children but one parent.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * Leaf node: Cannot have children but can have multiple parents.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * Policy: Allows you to store a policy document and policy type. For more information, see <a href=
         * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies"
         * >Policies</a>.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * Index: Can be created with the Index API.
         * </p>
         * </li>
         * </ul>
         * 
         * @param objectType
         *        Specifies whether a given object created from this facet is of type node, leaf node, policy or
         *        index.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Node: Can have multiple children but one parent.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        Leaf node: Cannot have children but can have multiple parents.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        Policy: Allows you to store a policy document and policy type. For more information, see <a href=
         *        "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies"
         *        >Policies</a>.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        Index: Can be created with the Index API.
         *        </p>
         *        </li>
         * @see ObjectType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectType
         */
        Builder objectType(ObjectType objectType);

        /**
         * <p>
         * There are two different styles that you can define on any given facet, <code>Static</code> and
         * <code>Dynamic</code>. For static facets, all attributes must be defined in the schema. For dynamic facets,
         * attributes can be defined during data plane operations.
         * </p>
         * 
         * @param facetStyle
         *        There are two different styles that you can define on any given facet, <code>Static</code> and
         *        <code>Dynamic</code>. For static facets, all attributes must be defined in the schema. For dynamic
         *        facets, attributes can be defined during data plane operations.
         * @see FacetStyle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FacetStyle
         */
        Builder facetStyle(String facetStyle);

        /**
         * <p>
         * There are two different styles that you can define on any given facet, <code>Static</code> and
         * <code>Dynamic</code>. For static facets, all attributes must be defined in the schema. For dynamic facets,
         * attributes can be defined during data plane operations.
         * </p>
         * 
         * @param facetStyle
         *        There are two different styles that you can define on any given facet, <code>Static</code> and
         *        <code>Dynamic</code>. For static facets, all attributes must be defined in the schema. For dynamic
         *        facets, attributes can be defined during data plane operations.
         * @see FacetStyle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FacetStyle
         */
        Builder facetStyle(FacetStyle facetStyle);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudDirectoryRequest.BuilderImpl implements Builder {
        private String schemaArn;

        private String name;

        private List<FacetAttribute> attributes = DefaultSdkAutoConstructList.getInstance();

        private String objectType;

        private String facetStyle;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFacetRequest model) {
            super(model);
            schemaArn(model.schemaArn);
            name(model.name);
            attributes(model.attributes);
            objectType(model.objectType);
            facetStyle(model.facetStyle);
        }

        public final String getSchemaArn() {
            return schemaArn;
        }

        @Override
        public final Builder schemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
            return this;
        }

        public final void setSchemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<FacetAttribute.Builder> getAttributes() {
            return attributes != null ? attributes.stream().map(FacetAttribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributes(Collection<FacetAttribute> attributes) {
            this.attributes = FacetAttributeListCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(FacetAttribute... attributes) {
            attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<FacetAttribute.Builder>... attributes) {
            attributes(Stream.of(attributes).map(c -> FacetAttribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAttributes(Collection<FacetAttribute.BuilderImpl> attributes) {
            this.attributes = FacetAttributeListCopier.copyFromBuilder(attributes);
        }

        public final String getObjectType() {
            return objectType;
        }

        @Override
        public final Builder objectType(String objectType) {
            this.objectType = objectType;
            return this;
        }

        @Override
        public final Builder objectType(ObjectType objectType) {
            this.objectType(objectType == null ? null : objectType.toString());
            return this;
        }

        public final void setObjectType(String objectType) {
            this.objectType = objectType;
        }

        public final String getFacetStyle() {
            return facetStyle;
        }

        @Override
        public final Builder facetStyle(String facetStyle) {
            this.facetStyle = facetStyle;
            return this;
        }

        @Override
        public final Builder facetStyle(FacetStyle facetStyle) {
            this.facetStyle(facetStyle == null ? null : facetStyle.toString());
            return this;
        }

        public final void setFacetStyle(String facetStyle) {
            this.facetStyle = facetStyle;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFacetRequest build() {
            return new CreateFacetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
