/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchWriteRequest extends CloudDirectoryRequest implements
        ToCopyableBuilder<BatchWriteRequest.Builder, BatchWriteRequest> {
    private static final SdkField<String> DIRECTORY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BatchWriteRequest::directoryArn)).setter(setter(Builder::directoryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-data-partition").build())
            .build();

    private static final SdkField<List<BatchWriteOperation>> OPERATIONS_FIELD = SdkField
            .<List<BatchWriteOperation>> builder(MarshallingType.LIST)
            .getter(getter(BatchWriteRequest::operations))
            .setter(setter(Builder::operations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchWriteOperation> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchWriteOperation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ARN_FIELD,
            OPERATIONS_FIELD));

    private final String directoryArn;

    private final List<BatchWriteOperation> operations;

    private BatchWriteRequest(BuilderImpl builder) {
        super(builder);
        this.directoryArn = builder.directoryArn;
        this.operations = builder.operations;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that is associated with the <a>Directory</a>. For more information, see
     * <a>arns</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that is associated with the <a>Directory</a>. For more information, see
     *         <a>arns</a>.
     */
    public String directoryArn() {
        return directoryArn;
    }

    /**
     * Returns true if the Operations property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasOperations() {
        return operations != null && !(operations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of operations that are part of the batch.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOperations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of operations that are part of the batch.
     */
    public List<BatchWriteOperation> operations() {
        return operations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(operations());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchWriteRequest)) {
            return false;
        }
        BatchWriteRequest other = (BatchWriteRequest) obj;
        return Objects.equals(directoryArn(), other.directoryArn()) && Objects.equals(operations(), other.operations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchWriteRequest").add("DirectoryArn", directoryArn()).add("Operations", operations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryArn":
            return Optional.ofNullable(clazz.cast(directoryArn()));
        case "Operations":
            return Optional.ofNullable(clazz.cast(operations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchWriteRequest, T> g) {
        return obj -> g.apply((BatchWriteRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudDirectoryRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchWriteRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that is associated with the <a>Directory</a>. For more information, see
         * <a>arns</a>.
         * </p>
         * 
         * @param directoryArn
         *        The Amazon Resource Name (ARN) that is associated with the <a>Directory</a>. For more information, see
         *        <a>arns</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryArn(String directoryArn);

        /**
         * <p>
         * A list of operations that are part of the batch.
         * </p>
         * 
         * @param operations
         *        A list of operations that are part of the batch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operations(Collection<BatchWriteOperation> operations);

        /**
         * <p>
         * A list of operations that are part of the batch.
         * </p>
         * 
         * @param operations
         *        A list of operations that are part of the batch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operations(BatchWriteOperation... operations);

        /**
         * <p>
         * A list of operations that are part of the batch.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BatchWriteOperation>.Builder} avoiding the
         * need to create one manually via {@link List<BatchWriteOperation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BatchWriteOperation>.Builder#build()} is called immediately
         * and its result is passed to {@link #operations(List<BatchWriteOperation>)}.
         * 
         * @param operations
         *        a consumer that will call methods on {@link List<BatchWriteOperation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #operations(List<BatchWriteOperation>)
         */
        Builder operations(Consumer<BatchWriteOperation.Builder>... operations);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudDirectoryRequest.BuilderImpl implements Builder {
        private String directoryArn;

        private List<BatchWriteOperation> operations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchWriteRequest model) {
            super(model);
            directoryArn(model.directoryArn);
            operations(model.operations);
        }

        public final String getDirectoryArn() {
            return directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        public final Collection<BatchWriteOperation.Builder> getOperations() {
            return operations != null ? operations.stream().map(BatchWriteOperation::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder operations(Collection<BatchWriteOperation> operations) {
            this.operations = BatchWriteOperationListCopier.copy(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(BatchWriteOperation... operations) {
            operations(Arrays.asList(operations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(Consumer<BatchWriteOperation.Builder>... operations) {
            operations(Stream.of(operations).map(c -> BatchWriteOperation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setOperations(Collection<BatchWriteOperation.BuilderImpl> operations) {
            this.operations = BatchWriteOperationListCopier.copyFromBuilder(operations);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchWriteRequest build() {
            return new BatchWriteRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
