/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Lists all policies from the root of the Directory to the object specified inside a <a>BatchRead</a> operation. For
 * more information, see <a>LookupPolicy</a> and <a>BatchReadRequest$Operations</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchLookupPolicy implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchLookupPolicy.Builder, BatchLookupPolicy> {
    private static final SdkField<ObjectReference> OBJECT_REFERENCE_FIELD = SdkField
            .<ObjectReference> builder(MarshallingType.SDK_POJO).getter(getter(BatchLookupPolicy::objectReference))
            .setter(setter(Builder::objectReference)).constructor(ObjectReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectReference").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BatchLookupPolicy::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(BatchLookupPolicy::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_REFERENCE_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final ObjectReference objectReference;

    private final String nextToken;

    private final Integer maxResults;

    private BatchLookupPolicy(BuilderImpl builder) {
        this.objectReference = builder.objectReference;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * Reference that identifies the object whose policies will be looked up.
     * </p>
     * 
     * @return Reference that identifies the object whose policies will be looked up.
     */
    public ObjectReference objectReference() {
        return objectReference;
    }

    /**
     * <p>
     * The pagination token.
     * </p>
     * 
     * @return The pagination token.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to retrieve.
     * </p>
     * 
     * @return The maximum number of results to retrieve.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(objectReference());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchLookupPolicy)) {
            return false;
        }
        BatchLookupPolicy other = (BatchLookupPolicy) obj;
        return Objects.equals(objectReference(), other.objectReference()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchLookupPolicy").add("ObjectReference", objectReference()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ObjectReference":
            return Optional.ofNullable(clazz.cast(objectReference()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchLookupPolicy, T> g) {
        return obj -> g.apply((BatchLookupPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchLookupPolicy> {
        /**
         * <p>
         * Reference that identifies the object whose policies will be looked up.
         * </p>
         * 
         * @param objectReference
         *        Reference that identifies the object whose policies will be looked up.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectReference(ObjectReference objectReference);

        /**
         * <p>
         * Reference that identifies the object whose policies will be looked up.
         * </p>
         * This is a convenience that creates an instance of the {@link ObjectReference.Builder} avoiding the need to
         * create one manually via {@link ObjectReference#builder()}.
         *
         * When the {@link Consumer} completes, {@link ObjectReference.Builder#build()} is called immediately and its
         * result is passed to {@link #objectReference(ObjectReference)}.
         * 
         * @param objectReference
         *        a consumer that will call methods on {@link ObjectReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #objectReference(ObjectReference)
         */
        default Builder objectReference(Consumer<ObjectReference.Builder> objectReference) {
            return objectReference(ObjectReference.builder().applyMutation(objectReference).build());
        }

        /**
         * <p>
         * The pagination token.
         * </p>
         * 
         * @param nextToken
         *        The pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to retrieve.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);
    }

    static final class BuilderImpl implements Builder {
        private ObjectReference objectReference;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchLookupPolicy model) {
            objectReference(model.objectReference);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final ObjectReference.Builder getObjectReference() {
            return objectReference != null ? objectReference.toBuilder() : null;
        }

        @Override
        public final Builder objectReference(ObjectReference objectReference) {
            this.objectReference = objectReference;
            return this;
        }

        public final void setObjectReference(ObjectReference.BuilderImpl objectReference) {
            this.objectReference = objectReference != null ? objectReference.build() : null;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public BatchLookupPolicy build() {
            return new BatchLookupPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
