/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <a>ListPolicyAttachments</a> response operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchListPolicyAttachmentsResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchListPolicyAttachmentsResponse.Builder, BatchListPolicyAttachmentsResponse> {
    private static final SdkField<List<String>> OBJECT_IDENTIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(BatchListPolicyAttachmentsResponse::objectIdentifiers))
            .setter(setter(Builder::objectIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BatchListPolicyAttachmentsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_IDENTIFIERS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> objectIdentifiers;

    private final String nextToken;

    private BatchListPolicyAttachmentsResponse(BuilderImpl builder) {
        this.objectIdentifiers = builder.objectIdentifiers;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ObjectIdentifiers property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasObjectIdentifiers() {
        return objectIdentifiers != null && !(objectIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>ObjectIdentifiers</code> to which the policy is attached.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasObjectIdentifiers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of <code>ObjectIdentifiers</code> to which the policy is attached.
     */
    public List<String> objectIdentifiers() {
        return objectIdentifiers;
    }

    /**
     * <p>
     * The pagination token.
     * </p>
     * 
     * @return The pagination token.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(objectIdentifiers());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchListPolicyAttachmentsResponse)) {
            return false;
        }
        BatchListPolicyAttachmentsResponse other = (BatchListPolicyAttachmentsResponse) obj;
        return Objects.equals(objectIdentifiers(), other.objectIdentifiers()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchListPolicyAttachmentsResponse").add("ObjectIdentifiers", objectIdentifiers())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ObjectIdentifiers":
            return Optional.ofNullable(clazz.cast(objectIdentifiers()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchListPolicyAttachmentsResponse, T> g) {
        return obj -> g.apply((BatchListPolicyAttachmentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchListPolicyAttachmentsResponse> {
        /**
         * <p>
         * A list of <code>ObjectIdentifiers</code> to which the policy is attached.
         * </p>
         * 
         * @param objectIdentifiers
         *        A list of <code>ObjectIdentifiers</code> to which the policy is attached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectIdentifiers(Collection<String> objectIdentifiers);

        /**
         * <p>
         * A list of <code>ObjectIdentifiers</code> to which the policy is attached.
         * </p>
         * 
         * @param objectIdentifiers
         *        A list of <code>ObjectIdentifiers</code> to which the policy is attached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectIdentifiers(String... objectIdentifiers);

        /**
         * <p>
         * The pagination token.
         * </p>
         * 
         * @param nextToken
         *        The pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<String> objectIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchListPolicyAttachmentsResponse model) {
            objectIdentifiers(model.objectIdentifiers);
            nextToken(model.nextToken);
        }

        public final Collection<String> getObjectIdentifiers() {
            return objectIdentifiers;
        }

        @Override
        public final Builder objectIdentifiers(Collection<String> objectIdentifiers) {
            this.objectIdentifiers = ObjectIdentifierListCopier.copy(objectIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectIdentifiers(String... objectIdentifiers) {
            objectIdentifiers(Arrays.asList(objectIdentifiers));
            return this;
        }

        public final void setObjectIdentifiers(Collection<String> objectIdentifiers) {
            this.objectIdentifiers = ObjectIdentifierListCopier.copy(objectIdentifiers);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public BatchListPolicyAttachmentsResponse build() {
            return new BatchListPolicyAttachmentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
