/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Lists objects attached to the specified index inside a <a>BatchRead</a> operation. For more information, see
 * <a>ListIndex</a> and <a>BatchReadRequest$Operations</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchListIndex implements SdkPojo, Serializable, ToCopyableBuilder<BatchListIndex.Builder, BatchListIndex> {
    private static final SdkField<List<ObjectAttributeRange>> RANGES_ON_INDEXED_VALUES_FIELD = SdkField
            .<List<ObjectAttributeRange>> builder(MarshallingType.LIST)
            .getter(getter(BatchListIndex::rangesOnIndexedValues))
            .setter(setter(Builder::rangesOnIndexedValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RangesOnIndexedValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ObjectAttributeRange> builder(MarshallingType.SDK_POJO)
                                            .constructor(ObjectAttributeRange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ObjectReference> INDEX_REFERENCE_FIELD = SdkField
            .<ObjectReference> builder(MarshallingType.SDK_POJO).getter(getter(BatchListIndex::indexReference))
            .setter(setter(Builder::indexReference)).constructor(ObjectReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexReference").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(BatchListIndex::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BatchListIndex::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RANGES_ON_INDEXED_VALUES_FIELD, INDEX_REFERENCE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ObjectAttributeRange> rangesOnIndexedValues;

    private final ObjectReference indexReference;

    private final Integer maxResults;

    private final String nextToken;

    private BatchListIndex(BuilderImpl builder) {
        this.rangesOnIndexedValues = builder.rangesOnIndexedValues;
        this.indexReference = builder.indexReference;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the RangesOnIndexedValues property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasRangesOnIndexedValues() {
        return rangesOnIndexedValues != null && !(rangesOnIndexedValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the ranges of indexed values that you want to query.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRangesOnIndexedValues()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies the ranges of indexed values that you want to query.
     */
    public List<ObjectAttributeRange> rangesOnIndexedValues() {
        return rangesOnIndexedValues;
    }

    /**
     * <p>
     * The reference to the index to list.
     * </p>
     * 
     * @return The reference to the index to list.
     */
    public ObjectReference indexReference() {
        return indexReference;
    }

    /**
     * <p>
     * The maximum number of results to retrieve.
     * </p>
     * 
     * @return The maximum number of results to retrieve.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The pagination token.
     * </p>
     * 
     * @return The pagination token.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rangesOnIndexedValues());
        hashCode = 31 * hashCode + Objects.hashCode(indexReference());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchListIndex)) {
            return false;
        }
        BatchListIndex other = (BatchListIndex) obj;
        return Objects.equals(rangesOnIndexedValues(), other.rangesOnIndexedValues())
                && Objects.equals(indexReference(), other.indexReference()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchListIndex").add("RangesOnIndexedValues", rangesOnIndexedValues())
                .add("IndexReference", indexReference()).add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RangesOnIndexedValues":
            return Optional.ofNullable(clazz.cast(rangesOnIndexedValues()));
        case "IndexReference":
            return Optional.ofNullable(clazz.cast(indexReference()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchListIndex, T> g) {
        return obj -> g.apply((BatchListIndex) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchListIndex> {
        /**
         * <p>
         * Specifies the ranges of indexed values that you want to query.
         * </p>
         * 
         * @param rangesOnIndexedValues
         *        Specifies the ranges of indexed values that you want to query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rangesOnIndexedValues(Collection<ObjectAttributeRange> rangesOnIndexedValues);

        /**
         * <p>
         * Specifies the ranges of indexed values that you want to query.
         * </p>
         * 
         * @param rangesOnIndexedValues
         *        Specifies the ranges of indexed values that you want to query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rangesOnIndexedValues(ObjectAttributeRange... rangesOnIndexedValues);

        /**
         * <p>
         * Specifies the ranges of indexed values that you want to query.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ObjectAttributeRange>.Builder} avoiding the
         * need to create one manually via {@link List<ObjectAttributeRange>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ObjectAttributeRange>.Builder#build()} is called immediately
         * and its result is passed to {@link #rangesOnIndexedValues(List<ObjectAttributeRange>)}.
         * 
         * @param rangesOnIndexedValues
         *        a consumer that will call methods on {@link List<ObjectAttributeRange>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rangesOnIndexedValues(List<ObjectAttributeRange>)
         */
        Builder rangesOnIndexedValues(Consumer<ObjectAttributeRange.Builder>... rangesOnIndexedValues);

        /**
         * <p>
         * The reference to the index to list.
         * </p>
         * 
         * @param indexReference
         *        The reference to the index to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexReference(ObjectReference indexReference);

        /**
         * <p>
         * The reference to the index to list.
         * </p>
         * This is a convenience that creates an instance of the {@link ObjectReference.Builder} avoiding the need to
         * create one manually via {@link ObjectReference#builder()}.
         *
         * When the {@link Consumer} completes, {@link ObjectReference.Builder#build()} is called immediately and its
         * result is passed to {@link #indexReference(ObjectReference)}.
         * 
         * @param indexReference
         *        a consumer that will call methods on {@link ObjectReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #indexReference(ObjectReference)
         */
        default Builder indexReference(Consumer<ObjectReference.Builder> indexReference) {
            return indexReference(ObjectReference.builder().applyMutation(indexReference).build());
        }

        /**
         * <p>
         * The maximum number of results to retrieve.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The pagination token.
         * </p>
         * 
         * @param nextToken
         *        The pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<ObjectAttributeRange> rangesOnIndexedValues = DefaultSdkAutoConstructList.getInstance();

        private ObjectReference indexReference;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchListIndex model) {
            rangesOnIndexedValues(model.rangesOnIndexedValues);
            indexReference(model.indexReference);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<ObjectAttributeRange.Builder> getRangesOnIndexedValues() {
            return rangesOnIndexedValues != null ? rangesOnIndexedValues.stream().map(ObjectAttributeRange::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rangesOnIndexedValues(Collection<ObjectAttributeRange> rangesOnIndexedValues) {
            this.rangesOnIndexedValues = ObjectAttributeRangeListCopier.copy(rangesOnIndexedValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rangesOnIndexedValues(ObjectAttributeRange... rangesOnIndexedValues) {
            rangesOnIndexedValues(Arrays.asList(rangesOnIndexedValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rangesOnIndexedValues(Consumer<ObjectAttributeRange.Builder>... rangesOnIndexedValues) {
            rangesOnIndexedValues(Stream.of(rangesOnIndexedValues)
                    .map(c -> ObjectAttributeRange.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRangesOnIndexedValues(Collection<ObjectAttributeRange.BuilderImpl> rangesOnIndexedValues) {
            this.rangesOnIndexedValues = ObjectAttributeRangeListCopier.copyFromBuilder(rangesOnIndexedValues);
        }

        public final ObjectReference.Builder getIndexReference() {
            return indexReference != null ? indexReference.toBuilder() : null;
        }

        @Override
        public final Builder indexReference(ObjectReference indexReference) {
            this.indexReference = indexReference;
            return this;
        }

        public final void setIndexReference(ObjectReference.BuilderImpl indexReference) {
            this.indexReference = indexReference != null ? indexReference.build() : null;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public BatchListIndex build() {
            return new BatchListIndex(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
