/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <a>DetachObject</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDetachObject implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchDetachObject.Builder, BatchDetachObject> {
    private static final SdkField<ObjectReference> PARENT_REFERENCE_FIELD = SdkField
            .<ObjectReference> builder(MarshallingType.SDK_POJO).getter(getter(BatchDetachObject::parentReference))
            .setter(setter(Builder::parentReference)).constructor(ObjectReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentReference").build()).build();

    private static final SdkField<String> LINK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BatchDetachObject::linkName)).setter(setter(Builder::linkName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkName").build()).build();

    private static final SdkField<String> BATCH_REFERENCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BatchDetachObject::batchReferenceName)).setter(setter(Builder::batchReferenceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchReferenceName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARENT_REFERENCE_FIELD,
            LINK_NAME_FIELD, BATCH_REFERENCE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final ObjectReference parentReference;

    private final String linkName;

    private final String batchReferenceName;

    private BatchDetachObject(BuilderImpl builder) {
        this.parentReference = builder.parentReference;
        this.linkName = builder.linkName;
        this.batchReferenceName = builder.batchReferenceName;
    }

    /**
     * <p>
     * Parent reference from which the object with the specified link name is detached.
     * </p>
     * 
     * @return Parent reference from which the object with the specified link name is detached.
     */
    public ObjectReference parentReference() {
        return parentReference;
    }

    /**
     * <p>
     * The name of the link.
     * </p>
     * 
     * @return The name of the link.
     */
    public String linkName() {
        return linkName;
    }

    /**
     * <p>
     * The batch reference name. See <a
     * href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/transaction_support.html">Transaction
     * Support</a> for more information.
     * </p>
     * 
     * @return The batch reference name. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/transaction_support.html"
     *         >Transaction Support</a> for more information.
     */
    public String batchReferenceName() {
        return batchReferenceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(parentReference());
        hashCode = 31 * hashCode + Objects.hashCode(linkName());
        hashCode = 31 * hashCode + Objects.hashCode(batchReferenceName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDetachObject)) {
            return false;
        }
        BatchDetachObject other = (BatchDetachObject) obj;
        return Objects.equals(parentReference(), other.parentReference()) && Objects.equals(linkName(), other.linkName())
                && Objects.equals(batchReferenceName(), other.batchReferenceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchDetachObject").add("ParentReference", parentReference()).add("LinkName", linkName())
                .add("BatchReferenceName", batchReferenceName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ParentReference":
            return Optional.ofNullable(clazz.cast(parentReference()));
        case "LinkName":
            return Optional.ofNullable(clazz.cast(linkName()));
        case "BatchReferenceName":
            return Optional.ofNullable(clazz.cast(batchReferenceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDetachObject, T> g) {
        return obj -> g.apply((BatchDetachObject) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchDetachObject> {
        /**
         * <p>
         * Parent reference from which the object with the specified link name is detached.
         * </p>
         * 
         * @param parentReference
         *        Parent reference from which the object with the specified link name is detached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentReference(ObjectReference parentReference);

        /**
         * <p>
         * Parent reference from which the object with the specified link name is detached.
         * </p>
         * This is a convenience that creates an instance of the {@link ObjectReference.Builder} avoiding the need to
         * create one manually via {@link ObjectReference#builder()}.
         *
         * When the {@link Consumer} completes, {@link ObjectReference.Builder#build()} is called immediately and its
         * result is passed to {@link #parentReference(ObjectReference)}.
         * 
         * @param parentReference
         *        a consumer that will call methods on {@link ObjectReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parentReference(ObjectReference)
         */
        default Builder parentReference(Consumer<ObjectReference.Builder> parentReference) {
            return parentReference(ObjectReference.builder().applyMutation(parentReference).build());
        }

        /**
         * <p>
         * The name of the link.
         * </p>
         * 
         * @param linkName
         *        The name of the link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkName(String linkName);

        /**
         * <p>
         * The batch reference name. See <a
         * href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/transaction_support.html">Transaction
         * Support</a> for more information.
         * </p>
         * 
         * @param batchReferenceName
         *        The batch reference name. See <a
         *        href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/transaction_support.html"
         *        >Transaction Support</a> for more information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchReferenceName(String batchReferenceName);
    }

    static final class BuilderImpl implements Builder {
        private ObjectReference parentReference;

        private String linkName;

        private String batchReferenceName;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDetachObject model) {
            parentReference(model.parentReference);
            linkName(model.linkName);
            batchReferenceName(model.batchReferenceName);
        }

        public final ObjectReference.Builder getParentReference() {
            return parentReference != null ? parentReference.toBuilder() : null;
        }

        @Override
        public final Builder parentReference(ObjectReference parentReference) {
            this.parentReference = parentReference;
            return this;
        }

        public final void setParentReference(ObjectReference.BuilderImpl parentReference) {
            this.parentReference = parentReference != null ? parentReference.build() : null;
        }

        public final String getLinkName() {
            return linkName;
        }

        @Override
        public final Builder linkName(String linkName) {
            this.linkName = linkName;
            return this;
        }

        public final void setLinkName(String linkName) {
            this.linkName = linkName;
        }

        public final String getBatchReferenceName() {
            return batchReferenceName;
        }

        @Override
        public final Builder batchReferenceName(String batchReferenceName) {
            this.batchReferenceName = batchReferenceName;
            return this;
        }

        public final void setBatchReferenceName(String batchReferenceName) {
            this.batchReferenceName = batchReferenceName;
        }

        @Override
        public BatchDetachObject build() {
            return new BatchDetachObject(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
