/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.ObjectIdentifierListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchListPolicyAttachmentsResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchListPolicyAttachmentsResponse> {
    private static final SdkField<List<String>> OBJECT_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BatchListPolicyAttachmentsResponse.getter(BatchListPolicyAttachmentsResponse::objectIdentifiers)).setter(BatchListPolicyAttachmentsResponse.setter(Builder::objectIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BatchListPolicyAttachmentsResponse.getter(BatchListPolicyAttachmentsResponse::nextToken)).setter(BatchListPolicyAttachmentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_IDENTIFIERS_FIELD, NEXT_TOKEN_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> objectIdentifiers;
    private final String nextToken;

    private BatchListPolicyAttachmentsResponse(BuilderImpl builder) {
        this.objectIdentifiers = builder.objectIdentifiers;
        this.nextToken = builder.nextToken;
    }

    public boolean hasObjectIdentifiers() {
        return this.objectIdentifiers != null && !(this.objectIdentifiers instanceof SdkAutoConstructList);
    }

    public List<String> objectIdentifiers() {
        return this.objectIdentifiers;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.objectIdentifiers());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchListPolicyAttachmentsResponse)) {
            return false;
        }
        BatchListPolicyAttachmentsResponse other = (BatchListPolicyAttachmentsResponse)obj;
        return Objects.equals(this.objectIdentifiers(), other.objectIdentifiers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"BatchListPolicyAttachmentsResponse").add("ObjectIdentifiers", this.objectIdentifiers()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ObjectIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.objectIdentifiers()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchListPolicyAttachmentsResponse, T> g) {
        return obj -> g.apply((BatchListPolicyAttachmentsResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> objectIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchListPolicyAttachmentsResponse model) {
            this.objectIdentifiers(model.objectIdentifiers);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getObjectIdentifiers() {
            return this.objectIdentifiers;
        }

        @Override
        public final Builder objectIdentifiers(Collection<String> objectIdentifiers) {
            this.objectIdentifiers = ObjectIdentifierListCopier.copy(objectIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectIdentifiers(String ... objectIdentifiers) {
            this.objectIdentifiers(Arrays.asList(objectIdentifiers));
            return this;
        }

        public final void setObjectIdentifiers(Collection<String> objectIdentifiers) {
            this.objectIdentifiers = ObjectIdentifierListCopier.copy(objectIdentifiers);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public BatchListPolicyAttachmentsResponse build() {
            return new BatchListPolicyAttachmentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchListPolicyAttachmentsResponse> {
        public Builder objectIdentifiers(Collection<String> var1);

        public Builder objectIdentifiers(String ... var1);

        public Builder nextToken(String var1);
    }
}

