/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.services.clouddirectory.model.SchemaFacet;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchListObjectAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchListObjectAttributes> {
    private static final SdkField<ObjectReference> OBJECT_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(BatchListObjectAttributes.getter(BatchListObjectAttributes::objectReference)).setter(BatchListObjectAttributes.setter(Builder::objectReference)).constructor(ObjectReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectReference").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BatchListObjectAttributes.getter(BatchListObjectAttributes::nextToken)).setter(BatchListObjectAttributes.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(BatchListObjectAttributes.getter(BatchListObjectAttributes::maxResults)).setter(BatchListObjectAttributes.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<SchemaFacet> FACET_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(BatchListObjectAttributes.getter(BatchListObjectAttributes::facetFilter)).setter(BatchListObjectAttributes.setter(Builder::facetFilter)).constructor(SchemaFacet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FacetFilter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_REFERENCE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, FACET_FILTER_FIELD));
    private static final long serialVersionUID = 1L;
    private final ObjectReference objectReference;
    private final String nextToken;
    private final Integer maxResults;
    private final SchemaFacet facetFilter;

    private BatchListObjectAttributes(BuilderImpl builder) {
        this.objectReference = builder.objectReference;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.facetFilter = builder.facetFilter;
    }

    public ObjectReference objectReference() {
        return this.objectReference;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public SchemaFacet facetFilter() {
        return this.facetFilter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.objectReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.facetFilter());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchListObjectAttributes)) {
            return false;
        }
        BatchListObjectAttributes other = (BatchListObjectAttributes)obj;
        return Objects.equals(this.objectReference(), other.objectReference()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.facetFilter(), other.facetFilter());
    }

    public String toString() {
        return ToString.builder((String)"BatchListObjectAttributes").add("ObjectReference", (Object)this.objectReference()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("FacetFilter", (Object)this.facetFilter()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ObjectReference": {
                return Optional.ofNullable(clazz.cast(this.objectReference()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "FacetFilter": {
                return Optional.ofNullable(clazz.cast(this.facetFilter()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchListObjectAttributes, T> g) {
        return obj -> g.apply((BatchListObjectAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ObjectReference objectReference;
        private String nextToken;
        private Integer maxResults;
        private SchemaFacet facetFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchListObjectAttributes model) {
            this.objectReference(model.objectReference);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.facetFilter(model.facetFilter);
        }

        public final ObjectReference.Builder getObjectReference() {
            return this.objectReference != null ? this.objectReference.toBuilder() : null;
        }

        @Override
        public final Builder objectReference(ObjectReference objectReference) {
            this.objectReference = objectReference;
            return this;
        }

        public final void setObjectReference(ObjectReference.BuilderImpl objectReference) {
            this.objectReference = objectReference != null ? objectReference.build() : null;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final SchemaFacet.Builder getFacetFilter() {
            return this.facetFilter != null ? this.facetFilter.toBuilder() : null;
        }

        @Override
        public final Builder facetFilter(SchemaFacet facetFilter) {
            this.facetFilter = facetFilter;
            return this;
        }

        public final void setFacetFilter(SchemaFacet.BuilderImpl facetFilter) {
            this.facetFilter = facetFilter != null ? facetFilter.build() : null;
        }

        public BatchListObjectAttributes build() {
            return new BatchListObjectAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchListObjectAttributes> {
        public Builder objectReference(ObjectReference var1);

        default public Builder objectReference(Consumer<ObjectReference.Builder> objectReference) {
            return this.objectReference((ObjectReference)((ObjectReference.Builder)ObjectReference.builder().applyMutation(objectReference)).build());
        }

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder facetFilter(SchemaFacet var1);

        default public Builder facetFilter(Consumer<SchemaFacet.Builder> facetFilter) {
            return this.facetFilter((SchemaFacet)((SchemaFacet.Builder)SchemaFacet.builder().applyMutation(facetFilter)).build());
        }
    }
}

