/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A range of attribute values. For more information, see <a
 * href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_range_filters.html">Range
 * Filters</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TypedAttributeValueRange implements SdkPojo, Serializable,
        ToCopyableBuilder<TypedAttributeValueRange.Builder, TypedAttributeValueRange> {
    private static final SdkField<String> START_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TypedAttributeValueRange::startModeAsString)).setter(setter(Builder::startMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartMode").build()).build();

    private static final SdkField<TypedAttributeValue> START_VALUE_FIELD = SdkField
            .<TypedAttributeValue> builder(MarshallingType.SDK_POJO).getter(getter(TypedAttributeValueRange::startValue))
            .setter(setter(Builder::startValue)).constructor(TypedAttributeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartValue").build()).build();

    private static final SdkField<String> END_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TypedAttributeValueRange::endModeAsString)).setter(setter(Builder::endMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndMode").build()).build();

    private static final SdkField<TypedAttributeValue> END_VALUE_FIELD = SdkField
            .<TypedAttributeValue> builder(MarshallingType.SDK_POJO).getter(getter(TypedAttributeValueRange::endValue))
            .setter(setter(Builder::endValue)).constructor(TypedAttributeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_MODE_FIELD,
            START_VALUE_FIELD, END_MODE_FIELD, END_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String startMode;

    private final TypedAttributeValue startValue;

    private final String endMode;

    private final TypedAttributeValue endValue;

    private TypedAttributeValueRange(BuilderImpl builder) {
        this.startMode = builder.startMode;
        this.startValue = builder.startValue;
        this.endMode = builder.endMode;
        this.endValue = builder.endValue;
    }

    /**
     * <p>
     * The inclusive or exclusive range start.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #startMode} will
     * return {@link RangeMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #startModeAsString}.
     * </p>
     * 
     * @return The inclusive or exclusive range start.
     * @see RangeMode
     */
    public RangeMode startMode() {
        return RangeMode.fromValue(startMode);
    }

    /**
     * <p>
     * The inclusive or exclusive range start.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #startMode} will
     * return {@link RangeMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #startModeAsString}.
     * </p>
     * 
     * @return The inclusive or exclusive range start.
     * @see RangeMode
     */
    public String startModeAsString() {
        return startMode;
    }

    /**
     * <p>
     * The value to start the range at.
     * </p>
     * 
     * @return The value to start the range at.
     */
    public TypedAttributeValue startValue() {
        return startValue;
    }

    /**
     * <p>
     * The inclusive or exclusive range end.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endMode} will
     * return {@link RangeMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #endModeAsString}.
     * </p>
     * 
     * @return The inclusive or exclusive range end.
     * @see RangeMode
     */
    public RangeMode endMode() {
        return RangeMode.fromValue(endMode);
    }

    /**
     * <p>
     * The inclusive or exclusive range end.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endMode} will
     * return {@link RangeMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #endModeAsString}.
     * </p>
     * 
     * @return The inclusive or exclusive range end.
     * @see RangeMode
     */
    public String endModeAsString() {
        return endMode;
    }

    /**
     * <p>
     * The attribute value to terminate the range at.
     * </p>
     * 
     * @return The attribute value to terminate the range at.
     */
    public TypedAttributeValue endValue() {
        return endValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startValue());
        hashCode = 31 * hashCode + Objects.hashCode(endModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(endValue());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypedAttributeValueRange)) {
            return false;
        }
        TypedAttributeValueRange other = (TypedAttributeValueRange) obj;
        return Objects.equals(startModeAsString(), other.startModeAsString()) && Objects.equals(startValue(), other.startValue())
                && Objects.equals(endModeAsString(), other.endModeAsString()) && Objects.equals(endValue(), other.endValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TypedAttributeValueRange").add("StartMode", startModeAsString()).add("StartValue", startValue())
                .add("EndMode", endModeAsString()).add("EndValue", endValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartMode":
            return Optional.ofNullable(clazz.cast(startModeAsString()));
        case "StartValue":
            return Optional.ofNullable(clazz.cast(startValue()));
        case "EndMode":
            return Optional.ofNullable(clazz.cast(endModeAsString()));
        case "EndValue":
            return Optional.ofNullable(clazz.cast(endValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TypedAttributeValueRange, T> g) {
        return obj -> g.apply((TypedAttributeValueRange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TypedAttributeValueRange> {
        /**
         * <p>
         * The inclusive or exclusive range start.
         * </p>
         * 
         * @param startMode
         *        The inclusive or exclusive range start.
         * @see RangeMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RangeMode
         */
        Builder startMode(String startMode);

        /**
         * <p>
         * The inclusive or exclusive range start.
         * </p>
         * 
         * @param startMode
         *        The inclusive or exclusive range start.
         * @see RangeMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RangeMode
         */
        Builder startMode(RangeMode startMode);

        /**
         * <p>
         * The value to start the range at.
         * </p>
         * 
         * @param startValue
         *        The value to start the range at.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startValue(TypedAttributeValue startValue);

        /**
         * <p>
         * The value to start the range at.
         * </p>
         * This is a convenience that creates an instance of the {@link TypedAttributeValue.Builder} avoiding the need
         * to create one manually via {@link TypedAttributeValue#builder()}.
         *
         * When the {@link Consumer} completes, {@link TypedAttributeValue.Builder#build()} is called immediately and
         * its result is passed to {@link #startValue(TypedAttributeValue)}.
         * 
         * @param startValue
         *        a consumer that will call methods on {@link TypedAttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #startValue(TypedAttributeValue)
         */
        default Builder startValue(Consumer<TypedAttributeValue.Builder> startValue) {
            return startValue(TypedAttributeValue.builder().applyMutation(startValue).build());
        }

        /**
         * <p>
         * The inclusive or exclusive range end.
         * </p>
         * 
         * @param endMode
         *        The inclusive or exclusive range end.
         * @see RangeMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RangeMode
         */
        Builder endMode(String endMode);

        /**
         * <p>
         * The inclusive or exclusive range end.
         * </p>
         * 
         * @param endMode
         *        The inclusive or exclusive range end.
         * @see RangeMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RangeMode
         */
        Builder endMode(RangeMode endMode);

        /**
         * <p>
         * The attribute value to terminate the range at.
         * </p>
         * 
         * @param endValue
         *        The attribute value to terminate the range at.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endValue(TypedAttributeValue endValue);

        /**
         * <p>
         * The attribute value to terminate the range at.
         * </p>
         * This is a convenience that creates an instance of the {@link TypedAttributeValue.Builder} avoiding the need
         * to create one manually via {@link TypedAttributeValue#builder()}.
         *
         * When the {@link Consumer} completes, {@link TypedAttributeValue.Builder#build()} is called immediately and
         * its result is passed to {@link #endValue(TypedAttributeValue)}.
         * 
         * @param endValue
         *        a consumer that will call methods on {@link TypedAttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endValue(TypedAttributeValue)
         */
        default Builder endValue(Consumer<TypedAttributeValue.Builder> endValue) {
            return endValue(TypedAttributeValue.builder().applyMutation(endValue).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String startMode;

        private TypedAttributeValue startValue;

        private String endMode;

        private TypedAttributeValue endValue;

        private BuilderImpl() {
        }

        private BuilderImpl(TypedAttributeValueRange model) {
            startMode(model.startMode);
            startValue(model.startValue);
            endMode(model.endMode);
            endValue(model.endValue);
        }

        public final String getStartModeAsString() {
            return startMode;
        }

        @Override
        public final Builder startMode(String startMode) {
            this.startMode = startMode;
            return this;
        }

        @Override
        public final Builder startMode(RangeMode startMode) {
            this.startMode(startMode == null ? null : startMode.toString());
            return this;
        }

        public final void setStartMode(String startMode) {
            this.startMode = startMode;
        }

        public final TypedAttributeValue.Builder getStartValue() {
            return startValue != null ? startValue.toBuilder() : null;
        }

        @Override
        public final Builder startValue(TypedAttributeValue startValue) {
            this.startValue = startValue;
            return this;
        }

        public final void setStartValue(TypedAttributeValue.BuilderImpl startValue) {
            this.startValue = startValue != null ? startValue.build() : null;
        }

        public final String getEndModeAsString() {
            return endMode;
        }

        @Override
        public final Builder endMode(String endMode) {
            this.endMode = endMode;
            return this;
        }

        @Override
        public final Builder endMode(RangeMode endMode) {
            this.endMode(endMode == null ? null : endMode.toString());
            return this;
        }

        public final void setEndMode(String endMode) {
            this.endMode = endMode;
        }

        public final TypedAttributeValue.Builder getEndValue() {
            return endValue != null ? endValue.toBuilder() : null;
        }

        @Override
        public final Builder endValue(TypedAttributeValue endValue) {
            this.endValue = endValue;
            return this;
        }

        public final void setEndValue(TypedAttributeValue.BuilderImpl endValue) {
            this.endValue = endValue != null ? endValue.build() : null;
        }

        @Override
        public TypedAttributeValueRange build() {
            return new TypedAttributeValueRange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
