/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RemoveFacetFromObjectRequest extends CloudDirectoryRequest implements
        ToCopyableBuilder<RemoveFacetFromObjectRequest.Builder, RemoveFacetFromObjectRequest> {
    private static final SdkField<String> DIRECTORY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RemoveFacetFromObjectRequest::directoryArn)).setter(setter(Builder::directoryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-data-partition").build())
            .build();

    private static final SdkField<SchemaFacet> SCHEMA_FACET_FIELD = SdkField.<SchemaFacet> builder(MarshallingType.SDK_POJO)
            .getter(getter(RemoveFacetFromObjectRequest::schemaFacet)).setter(setter(Builder::schemaFacet))
            .constructor(SchemaFacet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaFacet").build()).build();

    private static final SdkField<ObjectReference> OBJECT_REFERENCE_FIELD = SdkField
            .<ObjectReference> builder(MarshallingType.SDK_POJO).getter(getter(RemoveFacetFromObjectRequest::objectReference))
            .setter(setter(Builder::objectReference)).constructor(ObjectReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectReference").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ARN_FIELD,
            SCHEMA_FACET_FIELD, OBJECT_REFERENCE_FIELD));

    private final String directoryArn;

    private final SchemaFacet schemaFacet;

    private final ObjectReference objectReference;

    private RemoveFacetFromObjectRequest(BuilderImpl builder) {
        super(builder);
        this.directoryArn = builder.directoryArn;
        this.schemaFacet = builder.schemaFacet;
        this.objectReference = builder.objectReference;
    }

    /**
     * <p>
     * The ARN of the directory in which the object resides.
     * </p>
     * 
     * @return The ARN of the directory in which the object resides.
     */
    public String directoryArn() {
        return directoryArn;
    }

    /**
     * <p>
     * The facet to remove. See <a>SchemaFacet</a> for details.
     * </p>
     * 
     * @return The facet to remove. See <a>SchemaFacet</a> for details.
     */
    public SchemaFacet schemaFacet() {
        return schemaFacet;
    }

    /**
     * <p>
     * A reference to the object to remove the facet from.
     * </p>
     * 
     * @return A reference to the object to remove the facet from.
     */
    public ObjectReference objectReference() {
        return objectReference;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(schemaFacet());
        hashCode = 31 * hashCode + Objects.hashCode(objectReference());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveFacetFromObjectRequest)) {
            return false;
        }
        RemoveFacetFromObjectRequest other = (RemoveFacetFromObjectRequest) obj;
        return Objects.equals(directoryArn(), other.directoryArn()) && Objects.equals(schemaFacet(), other.schemaFacet())
                && Objects.equals(objectReference(), other.objectReference());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RemoveFacetFromObjectRequest").add("DirectoryArn", directoryArn())
                .add("SchemaFacet", schemaFacet()).add("ObjectReference", objectReference()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryArn":
            return Optional.ofNullable(clazz.cast(directoryArn()));
        case "SchemaFacet":
            return Optional.ofNullable(clazz.cast(schemaFacet()));
        case "ObjectReference":
            return Optional.ofNullable(clazz.cast(objectReference()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemoveFacetFromObjectRequest, T> g) {
        return obj -> g.apply((RemoveFacetFromObjectRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudDirectoryRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, RemoveFacetFromObjectRequest> {
        /**
         * <p>
         * The ARN of the directory in which the object resides.
         * </p>
         * 
         * @param directoryArn
         *        The ARN of the directory in which the object resides.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryArn(String directoryArn);

        /**
         * <p>
         * The facet to remove. See <a>SchemaFacet</a> for details.
         * </p>
         * 
         * @param schemaFacet
         *        The facet to remove. See <a>SchemaFacet</a> for details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaFacet(SchemaFacet schemaFacet);

        /**
         * <p>
         * The facet to remove. See <a>SchemaFacet</a> for details.
         * </p>
         * This is a convenience that creates an instance of the {@link SchemaFacet.Builder} avoiding the need to create
         * one manually via {@link SchemaFacet#builder()}.
         *
         * When the {@link Consumer} completes, {@link SchemaFacet.Builder#build()} is called immediately and its result
         * is passed to {@link #schemaFacet(SchemaFacet)}.
         * 
         * @param schemaFacet
         *        a consumer that will call methods on {@link SchemaFacet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schemaFacet(SchemaFacet)
         */
        default Builder schemaFacet(Consumer<SchemaFacet.Builder> schemaFacet) {
            return schemaFacet(SchemaFacet.builder().applyMutation(schemaFacet).build());
        }

        /**
         * <p>
         * A reference to the object to remove the facet from.
         * </p>
         * 
         * @param objectReference
         *        A reference to the object to remove the facet from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectReference(ObjectReference objectReference);

        /**
         * <p>
         * A reference to the object to remove the facet from.
         * </p>
         * This is a convenience that creates an instance of the {@link ObjectReference.Builder} avoiding the need to
         * create one manually via {@link ObjectReference#builder()}.
         *
         * When the {@link Consumer} completes, {@link ObjectReference.Builder#build()} is called immediately and its
         * result is passed to {@link #objectReference(ObjectReference)}.
         * 
         * @param objectReference
         *        a consumer that will call methods on {@link ObjectReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #objectReference(ObjectReference)
         */
        default Builder objectReference(Consumer<ObjectReference.Builder> objectReference) {
            return objectReference(ObjectReference.builder().applyMutation(objectReference).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudDirectoryRequest.BuilderImpl implements Builder {
        private String directoryArn;

        private SchemaFacet schemaFacet;

        private ObjectReference objectReference;

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveFacetFromObjectRequest model) {
            super(model);
            directoryArn(model.directoryArn);
            schemaFacet(model.schemaFacet);
            objectReference(model.objectReference);
        }

        public final String getDirectoryArn() {
            return directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        public final SchemaFacet.Builder getSchemaFacet() {
            return schemaFacet != null ? schemaFacet.toBuilder() : null;
        }

        @Override
        public final Builder schemaFacet(SchemaFacet schemaFacet) {
            this.schemaFacet = schemaFacet;
            return this;
        }

        public final void setSchemaFacet(SchemaFacet.BuilderImpl schemaFacet) {
            this.schemaFacet = schemaFacet != null ? schemaFacet.build() : null;
        }

        public final ObjectReference.Builder getObjectReference() {
            return objectReference != null ? objectReference.toBuilder() : null;
        }

        @Override
        public final Builder objectReference(ObjectReference objectReference) {
            this.objectReference = objectReference;
            return this;
        }

        public final void setObjectReference(ObjectReference.BuilderImpl objectReference) {
            this.objectReference = objectReference != null ? objectReference.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RemoveFacetFromObjectRequest build() {
            return new RemoveFacetFromObjectRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
