/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PublishSchemaResponse extends CloudDirectoryResponse implements
        ToCopyableBuilder<PublishSchemaResponse.Builder, PublishSchemaResponse> {
    private static final SdkField<String> PUBLISHED_SCHEMA_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PublishSchemaResponse::publishedSchemaArn)).setter(setter(Builder::publishedSchemaArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublishedSchemaArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PUBLISHED_SCHEMA_ARN_FIELD));

    private final String publishedSchemaArn;

    private PublishSchemaResponse(BuilderImpl builder) {
        super(builder);
        this.publishedSchemaArn = builder.publishedSchemaArn;
    }

    /**
     * <p>
     * The ARN that is associated with the published schema. For more information, see <a>arns</a>.
     * </p>
     * 
     * @return The ARN that is associated with the published schema. For more information, see <a>arns</a>.
     */
    public String publishedSchemaArn() {
        return publishedSchemaArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(publishedSchemaArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublishSchemaResponse)) {
            return false;
        }
        PublishSchemaResponse other = (PublishSchemaResponse) obj;
        return Objects.equals(publishedSchemaArn(), other.publishedSchemaArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PublishSchemaResponse").add("PublishedSchemaArn", publishedSchemaArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PublishedSchemaArn":
            return Optional.ofNullable(clazz.cast(publishedSchemaArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PublishSchemaResponse, T> g) {
        return obj -> g.apply((PublishSchemaResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudDirectoryResponse.Builder, SdkPojo, CopyableBuilder<Builder, PublishSchemaResponse> {
        /**
         * <p>
         * The ARN that is associated with the published schema. For more information, see <a>arns</a>.
         * </p>
         * 
         * @param publishedSchemaArn
         *        The ARN that is associated with the published schema. For more information, see <a>arns</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publishedSchemaArn(String publishedSchemaArn);
    }

    static final class BuilderImpl extends CloudDirectoryResponse.BuilderImpl implements Builder {
        private String publishedSchemaArn;

        private BuilderImpl() {
        }

        private BuilderImpl(PublishSchemaResponse model) {
            super(model);
            publishedSchemaArn(model.publishedSchemaArn);
        }

        public final String getPublishedSchemaArn() {
            return publishedSchemaArn;
        }

        @Override
        public final Builder publishedSchemaArn(String publishedSchemaArn) {
            this.publishedSchemaArn = publishedSchemaArn;
            return this;
        }

        public final void setPublishedSchemaArn(String publishedSchemaArn) {
            this.publishedSchemaArn = publishedSchemaArn;
        }

        @Override
        public PublishSchemaResponse build() {
            return new PublishSchemaResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
