/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A pair of ObjectIdentifier and LinkName.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ObjectIdentifierAndLinkNameTuple implements SdkPojo, Serializable,
        ToCopyableBuilder<ObjectIdentifierAndLinkNameTuple.Builder, ObjectIdentifierAndLinkNameTuple> {
    private static final SdkField<String> OBJECT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ObjectIdentifierAndLinkNameTuple::objectIdentifier)).setter(setter(Builder::objectIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectIdentifier").build()).build();

    private static final SdkField<String> LINK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ObjectIdentifierAndLinkNameTuple::linkName)).setter(setter(Builder::linkName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_IDENTIFIER_FIELD,
            LINK_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String objectIdentifier;

    private final String linkName;

    private ObjectIdentifierAndLinkNameTuple(BuilderImpl builder) {
        this.objectIdentifier = builder.objectIdentifier;
        this.linkName = builder.linkName;
    }

    /**
     * <p>
     * The ID that is associated with the object.
     * </p>
     * 
     * @return The ID that is associated with the object.
     */
    public String objectIdentifier() {
        return objectIdentifier;
    }

    /**
     * <p>
     * The name of the link between the parent and the child object.
     * </p>
     * 
     * @return The name of the link between the parent and the child object.
     */
    public String linkName() {
        return linkName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(objectIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(linkName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObjectIdentifierAndLinkNameTuple)) {
            return false;
        }
        ObjectIdentifierAndLinkNameTuple other = (ObjectIdentifierAndLinkNameTuple) obj;
        return Objects.equals(objectIdentifier(), other.objectIdentifier()) && Objects.equals(linkName(), other.linkName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ObjectIdentifierAndLinkNameTuple").add("ObjectIdentifier", objectIdentifier())
                .add("LinkName", linkName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ObjectIdentifier":
            return Optional.ofNullable(clazz.cast(objectIdentifier()));
        case "LinkName":
            return Optional.ofNullable(clazz.cast(linkName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ObjectIdentifierAndLinkNameTuple, T> g) {
        return obj -> g.apply((ObjectIdentifierAndLinkNameTuple) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ObjectIdentifierAndLinkNameTuple> {
        /**
         * <p>
         * The ID that is associated with the object.
         * </p>
         * 
         * @param objectIdentifier
         *        The ID that is associated with the object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectIdentifier(String objectIdentifier);

        /**
         * <p>
         * The name of the link between the parent and the child object.
         * </p>
         * 
         * @param linkName
         *        The name of the link between the parent and the child object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkName(String linkName);
    }

    static final class BuilderImpl implements Builder {
        private String objectIdentifier;

        private String linkName;

        private BuilderImpl() {
        }

        private BuilderImpl(ObjectIdentifierAndLinkNameTuple model) {
            objectIdentifier(model.objectIdentifier);
            linkName(model.linkName);
        }

        public final String getObjectIdentifier() {
            return objectIdentifier;
        }

        @Override
        public final Builder objectIdentifier(String objectIdentifier) {
            this.objectIdentifier = objectIdentifier;
            return this;
        }

        public final void setObjectIdentifier(String objectIdentifier) {
            this.objectIdentifier = objectIdentifier;
        }

        public final String getLinkName() {
            return linkName;
        }

        @Override
        public final Builder linkName(String linkName) {
            this.linkName = linkName;
            return this;
        }

        public final void setLinkName(String linkName) {
            this.linkName = linkName;
        }

        @Override
        public ObjectIdentifierAndLinkNameTuple build() {
            return new ObjectIdentifierAndLinkNameTuple(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
