/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Structure that contains attribute update information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ObjectAttributeUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<ObjectAttributeUpdate.Builder, ObjectAttributeUpdate> {
    private static final SdkField<AttributeKey> OBJECT_ATTRIBUTE_KEY_FIELD = SdkField
            .<AttributeKey> builder(MarshallingType.SDK_POJO).getter(getter(ObjectAttributeUpdate::objectAttributeKey))
            .setter(setter(Builder::objectAttributeKey)).constructor(AttributeKey::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectAttributeKey").build())
            .build();

    private static final SdkField<ObjectAttributeAction> OBJECT_ATTRIBUTE_ACTION_FIELD = SdkField
            .<ObjectAttributeAction> builder(MarshallingType.SDK_POJO)
            .getter(getter(ObjectAttributeUpdate::objectAttributeAction)).setter(setter(Builder::objectAttributeAction))
            .constructor(ObjectAttributeAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectAttributeAction").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_ATTRIBUTE_KEY_FIELD,
            OBJECT_ATTRIBUTE_ACTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final AttributeKey objectAttributeKey;

    private final ObjectAttributeAction objectAttributeAction;

    private ObjectAttributeUpdate(BuilderImpl builder) {
        this.objectAttributeKey = builder.objectAttributeKey;
        this.objectAttributeAction = builder.objectAttributeAction;
    }

    /**
     * <p>
     * The key of the attribute being updated.
     * </p>
     * 
     * @return The key of the attribute being updated.
     */
    public AttributeKey objectAttributeKey() {
        return objectAttributeKey;
    }

    /**
     * <p>
     * The action to perform as part of the attribute update.
     * </p>
     * 
     * @return The action to perform as part of the attribute update.
     */
    public ObjectAttributeAction objectAttributeAction() {
        return objectAttributeAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(objectAttributeKey());
        hashCode = 31 * hashCode + Objects.hashCode(objectAttributeAction());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObjectAttributeUpdate)) {
            return false;
        }
        ObjectAttributeUpdate other = (ObjectAttributeUpdate) obj;
        return Objects.equals(objectAttributeKey(), other.objectAttributeKey())
                && Objects.equals(objectAttributeAction(), other.objectAttributeAction());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ObjectAttributeUpdate").add("ObjectAttributeKey", objectAttributeKey())
                .add("ObjectAttributeAction", objectAttributeAction()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ObjectAttributeKey":
            return Optional.ofNullable(clazz.cast(objectAttributeKey()));
        case "ObjectAttributeAction":
            return Optional.ofNullable(clazz.cast(objectAttributeAction()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ObjectAttributeUpdate, T> g) {
        return obj -> g.apply((ObjectAttributeUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ObjectAttributeUpdate> {
        /**
         * <p>
         * The key of the attribute being updated.
         * </p>
         * 
         * @param objectAttributeKey
         *        The key of the attribute being updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectAttributeKey(AttributeKey objectAttributeKey);

        /**
         * <p>
         * The key of the attribute being updated.
         * </p>
         * This is a convenience that creates an instance of the {@link AttributeKey.Builder} avoiding the need to
         * create one manually via {@link AttributeKey#builder()}.
         *
         * When the {@link Consumer} completes, {@link AttributeKey.Builder#build()} is called immediately and its
         * result is passed to {@link #objectAttributeKey(AttributeKey)}.
         * 
         * @param objectAttributeKey
         *        a consumer that will call methods on {@link AttributeKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #objectAttributeKey(AttributeKey)
         */
        default Builder objectAttributeKey(Consumer<AttributeKey.Builder> objectAttributeKey) {
            return objectAttributeKey(AttributeKey.builder().applyMutation(objectAttributeKey).build());
        }

        /**
         * <p>
         * The action to perform as part of the attribute update.
         * </p>
         * 
         * @param objectAttributeAction
         *        The action to perform as part of the attribute update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectAttributeAction(ObjectAttributeAction objectAttributeAction);

        /**
         * <p>
         * The action to perform as part of the attribute update.
         * </p>
         * This is a convenience that creates an instance of the {@link ObjectAttributeAction.Builder} avoiding the need
         * to create one manually via {@link ObjectAttributeAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link ObjectAttributeAction.Builder#build()} is called immediately and
         * its result is passed to {@link #objectAttributeAction(ObjectAttributeAction)}.
         * 
         * @param objectAttributeAction
         *        a consumer that will call methods on {@link ObjectAttributeAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #objectAttributeAction(ObjectAttributeAction)
         */
        default Builder objectAttributeAction(Consumer<ObjectAttributeAction.Builder> objectAttributeAction) {
            return objectAttributeAction(ObjectAttributeAction.builder().applyMutation(objectAttributeAction).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AttributeKey objectAttributeKey;

        private ObjectAttributeAction objectAttributeAction;

        private BuilderImpl() {
        }

        private BuilderImpl(ObjectAttributeUpdate model) {
            objectAttributeKey(model.objectAttributeKey);
            objectAttributeAction(model.objectAttributeAction);
        }

        public final AttributeKey.Builder getObjectAttributeKey() {
            return objectAttributeKey != null ? objectAttributeKey.toBuilder() : null;
        }

        @Override
        public final Builder objectAttributeKey(AttributeKey objectAttributeKey) {
            this.objectAttributeKey = objectAttributeKey;
            return this;
        }

        public final void setObjectAttributeKey(AttributeKey.BuilderImpl objectAttributeKey) {
            this.objectAttributeKey = objectAttributeKey != null ? objectAttributeKey.build() : null;
        }

        public final ObjectAttributeAction.Builder getObjectAttributeAction() {
            return objectAttributeAction != null ? objectAttributeAction.toBuilder() : null;
        }

        @Override
        public final Builder objectAttributeAction(ObjectAttributeAction objectAttributeAction) {
            this.objectAttributeAction = objectAttributeAction;
            return this;
        }

        public final void setObjectAttributeAction(ObjectAttributeAction.BuilderImpl objectAttributeAction) {
            this.objectAttributeAction = objectAttributeAction != null ? objectAttributeAction.build() : null;
        }

        @Override
        public ObjectAttributeUpdate build() {
            return new ObjectAttributeUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
