/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListObjectParentPathsResponse extends CloudDirectoryResponse implements
        ToCopyableBuilder<ListObjectParentPathsResponse.Builder, ListObjectParentPathsResponse> {
    private static final SdkField<List<PathToObjectIdentifiers>> PATH_TO_OBJECT_IDENTIFIERS_LIST_FIELD = SdkField
            .<List<PathToObjectIdentifiers>> builder(MarshallingType.LIST)
            .getter(getter(ListObjectParentPathsResponse::pathToObjectIdentifiersList))
            .setter(setter(Builder::pathToObjectIdentifiersList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PathToObjectIdentifiersList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PathToObjectIdentifiers> builder(MarshallingType.SDK_POJO)
                                            .constructor(PathToObjectIdentifiers::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListObjectParentPathsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PATH_TO_OBJECT_IDENTIFIERS_LIST_FIELD, NEXT_TOKEN_FIELD));

    private final List<PathToObjectIdentifiers> pathToObjectIdentifiersList;

    private final String nextToken;

    private ListObjectParentPathsResponse(BuilderImpl builder) {
        super(builder);
        this.pathToObjectIdentifiersList = builder.pathToObjectIdentifiersList;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the PathToObjectIdentifiersList property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasPathToObjectIdentifiersList() {
        return pathToObjectIdentifiersList != null && !(pathToObjectIdentifiersList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns the path to the <code>ObjectIdentifiers</code> that are associated with the directory.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPathToObjectIdentifiersList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Returns the path to the <code>ObjectIdentifiers</code> that are associated with the directory.
     */
    public List<PathToObjectIdentifiers> pathToObjectIdentifiersList() {
        return pathToObjectIdentifiersList;
    }

    /**
     * <p>
     * The pagination token.
     * </p>
     * 
     * @return The pagination token.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pathToObjectIdentifiersList());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListObjectParentPathsResponse)) {
            return false;
        }
        ListObjectParentPathsResponse other = (ListObjectParentPathsResponse) obj;
        return Objects.equals(pathToObjectIdentifiersList(), other.pathToObjectIdentifiersList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListObjectParentPathsResponse")
                .add("PathToObjectIdentifiersList", pathToObjectIdentifiersList()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PathToObjectIdentifiersList":
            return Optional.ofNullable(clazz.cast(pathToObjectIdentifiersList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListObjectParentPathsResponse, T> g) {
        return obj -> g.apply((ListObjectParentPathsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudDirectoryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListObjectParentPathsResponse> {
        /**
         * <p>
         * Returns the path to the <code>ObjectIdentifiers</code> that are associated with the directory.
         * </p>
         * 
         * @param pathToObjectIdentifiersList
         *        Returns the path to the <code>ObjectIdentifiers</code> that are associated with the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pathToObjectIdentifiersList(Collection<PathToObjectIdentifiers> pathToObjectIdentifiersList);

        /**
         * <p>
         * Returns the path to the <code>ObjectIdentifiers</code> that are associated with the directory.
         * </p>
         * 
         * @param pathToObjectIdentifiersList
         *        Returns the path to the <code>ObjectIdentifiers</code> that are associated with the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pathToObjectIdentifiersList(PathToObjectIdentifiers... pathToObjectIdentifiersList);

        /**
         * <p>
         * Returns the path to the <code>ObjectIdentifiers</code> that are associated with the directory.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PathToObjectIdentifiers>.Builder} avoiding
         * the need to create one manually via {@link List<PathToObjectIdentifiers>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PathToObjectIdentifiers>.Builder#build()} is called
         * immediately and its result is passed to {@link #pathToObjectIdentifiersList(List<PathToObjectIdentifiers>)}.
         * 
         * @param pathToObjectIdentifiersList
         *        a consumer that will call methods on {@link List<PathToObjectIdentifiers>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pathToObjectIdentifiersList(List<PathToObjectIdentifiers>)
         */
        Builder pathToObjectIdentifiersList(Consumer<PathToObjectIdentifiers.Builder>... pathToObjectIdentifiersList);

        /**
         * <p>
         * The pagination token.
         * </p>
         * 
         * @param nextToken
         *        The pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudDirectoryResponse.BuilderImpl implements Builder {
        private List<PathToObjectIdentifiers> pathToObjectIdentifiersList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListObjectParentPathsResponse model) {
            super(model);
            pathToObjectIdentifiersList(model.pathToObjectIdentifiersList);
            nextToken(model.nextToken);
        }

        public final Collection<PathToObjectIdentifiers.Builder> getPathToObjectIdentifiersList() {
            return pathToObjectIdentifiersList != null ? pathToObjectIdentifiersList.stream()
                    .map(PathToObjectIdentifiers::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder pathToObjectIdentifiersList(Collection<PathToObjectIdentifiers> pathToObjectIdentifiersList) {
            this.pathToObjectIdentifiersList = PathToObjectIdentifiersListCopier.copy(pathToObjectIdentifiersList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pathToObjectIdentifiersList(PathToObjectIdentifiers... pathToObjectIdentifiersList) {
            pathToObjectIdentifiersList(Arrays.asList(pathToObjectIdentifiersList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pathToObjectIdentifiersList(Consumer<PathToObjectIdentifiers.Builder>... pathToObjectIdentifiersList) {
            pathToObjectIdentifiersList(Stream.of(pathToObjectIdentifiersList)
                    .map(c -> PathToObjectIdentifiers.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPathToObjectIdentifiersList(
                Collection<PathToObjectIdentifiers.BuilderImpl> pathToObjectIdentifiersList) {
            this.pathToObjectIdentifiersList = PathToObjectIdentifiersListCopier.copyFromBuilder(pathToObjectIdentifiersList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListObjectParentPathsResponse build() {
            return new ListObjectParentPathsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
