/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListIncomingTypedLinksResponse extends CloudDirectoryResponse implements
        ToCopyableBuilder<ListIncomingTypedLinksResponse.Builder, ListIncomingTypedLinksResponse> {
    private static final SdkField<List<TypedLinkSpecifier>> LINK_SPECIFIERS_FIELD = SdkField
            .<List<TypedLinkSpecifier>> builder(MarshallingType.LIST)
            .getter(getter(ListIncomingTypedLinksResponse::linkSpecifiers))
            .setter(setter(Builder::linkSpecifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkSpecifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TypedLinkSpecifier> builder(MarshallingType.SDK_POJO)
                                            .constructor(TypedLinkSpecifier::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListIncomingTypedLinksResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LINK_SPECIFIERS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<TypedLinkSpecifier> linkSpecifiers;

    private final String nextToken;

    private ListIncomingTypedLinksResponse(BuilderImpl builder) {
        super(builder);
        this.linkSpecifiers = builder.linkSpecifiers;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the LinkSpecifiers property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasLinkSpecifiers() {
        return linkSpecifiers != null && !(linkSpecifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns one or more typed link specifiers as output.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLinkSpecifiers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Returns one or more typed link specifiers as output.
     */
    public List<TypedLinkSpecifier> linkSpecifiers() {
        return linkSpecifiers;
    }

    /**
     * <p>
     * The pagination token.
     * </p>
     * 
     * @return The pagination token.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(linkSpecifiers());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIncomingTypedLinksResponse)) {
            return false;
        }
        ListIncomingTypedLinksResponse other = (ListIncomingTypedLinksResponse) obj;
        return Objects.equals(linkSpecifiers(), other.linkSpecifiers()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListIncomingTypedLinksResponse").add("LinkSpecifiers", linkSpecifiers())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LinkSpecifiers":
            return Optional.ofNullable(clazz.cast(linkSpecifiers()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListIncomingTypedLinksResponse, T> g) {
        return obj -> g.apply((ListIncomingTypedLinksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudDirectoryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListIncomingTypedLinksResponse> {
        /**
         * <p>
         * Returns one or more typed link specifiers as output.
         * </p>
         * 
         * @param linkSpecifiers
         *        Returns one or more typed link specifiers as output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkSpecifiers(Collection<TypedLinkSpecifier> linkSpecifiers);

        /**
         * <p>
         * Returns one or more typed link specifiers as output.
         * </p>
         * 
         * @param linkSpecifiers
         *        Returns one or more typed link specifiers as output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkSpecifiers(TypedLinkSpecifier... linkSpecifiers);

        /**
         * <p>
         * Returns one or more typed link specifiers as output.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TypedLinkSpecifier>.Builder} avoiding the
         * need to create one manually via {@link List<TypedLinkSpecifier>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TypedLinkSpecifier>.Builder#build()} is called immediately
         * and its result is passed to {@link #linkSpecifiers(List<TypedLinkSpecifier>)}.
         * 
         * @param linkSpecifiers
         *        a consumer that will call methods on {@link List<TypedLinkSpecifier>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #linkSpecifiers(List<TypedLinkSpecifier>)
         */
        Builder linkSpecifiers(Consumer<TypedLinkSpecifier.Builder>... linkSpecifiers);

        /**
         * <p>
         * The pagination token.
         * </p>
         * 
         * @param nextToken
         *        The pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudDirectoryResponse.BuilderImpl implements Builder {
        private List<TypedLinkSpecifier> linkSpecifiers = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIncomingTypedLinksResponse model) {
            super(model);
            linkSpecifiers(model.linkSpecifiers);
            nextToken(model.nextToken);
        }

        public final Collection<TypedLinkSpecifier.Builder> getLinkSpecifiers() {
            return linkSpecifiers != null ? linkSpecifiers.stream().map(TypedLinkSpecifier::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder linkSpecifiers(Collection<TypedLinkSpecifier> linkSpecifiers) {
            this.linkSpecifiers = TypedLinkSpecifierListCopier.copy(linkSpecifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder linkSpecifiers(TypedLinkSpecifier... linkSpecifiers) {
            linkSpecifiers(Arrays.asList(linkSpecifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder linkSpecifiers(Consumer<TypedLinkSpecifier.Builder>... linkSpecifiers) {
            linkSpecifiers(Stream.of(linkSpecifiers).map(c -> TypedLinkSpecifier.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setLinkSpecifiers(Collection<TypedLinkSpecifier.BuilderImpl> linkSpecifiers) {
            this.linkSpecifiers = TypedLinkSpecifierListCopier.copyFromBuilder(linkSpecifiers);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListIncomingTypedLinksResponse build() {
            return new ListIncomingTypedLinksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
