/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListIncomingTypedLinksRequest extends CloudDirectoryRequest implements
        ToCopyableBuilder<ListIncomingTypedLinksRequest.Builder, ListIncomingTypedLinksRequest> {
    private static final SdkField<String> DIRECTORY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListIncomingTypedLinksRequest::directoryArn)).setter(setter(Builder::directoryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-data-partition").build())
            .build();

    private static final SdkField<ObjectReference> OBJECT_REFERENCE_FIELD = SdkField
            .<ObjectReference> builder(MarshallingType.SDK_POJO).getter(getter(ListIncomingTypedLinksRequest::objectReference))
            .setter(setter(Builder::objectReference)).constructor(ObjectReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectReference").build()).build();

    private static final SdkField<List<TypedLinkAttributeRange>> FILTER_ATTRIBUTE_RANGES_FIELD = SdkField
            .<List<TypedLinkAttributeRange>> builder(MarshallingType.LIST)
            .getter(getter(ListIncomingTypedLinksRequest::filterAttributeRanges))
            .setter(setter(Builder::filterAttributeRanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterAttributeRanges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TypedLinkAttributeRange> builder(MarshallingType.SDK_POJO)
                                            .constructor(TypedLinkAttributeRange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TypedLinkSchemaAndFacetName> FILTER_TYPED_LINK_FIELD = SdkField
            .<TypedLinkSchemaAndFacetName> builder(MarshallingType.SDK_POJO)
            .getter(getter(ListIncomingTypedLinksRequest::filterTypedLink)).setter(setter(Builder::filterTypedLink))
            .constructor(TypedLinkSchemaAndFacetName::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterTypedLink").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListIncomingTypedLinksRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListIncomingTypedLinksRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> CONSISTENCY_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListIncomingTypedLinksRequest::consistencyLevelAsString)).setter(setter(Builder::consistencyLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsistencyLevel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ARN_FIELD,
            OBJECT_REFERENCE_FIELD, FILTER_ATTRIBUTE_RANGES_FIELD, FILTER_TYPED_LINK_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD,
            CONSISTENCY_LEVEL_FIELD));

    private final String directoryArn;

    private final ObjectReference objectReference;

    private final List<TypedLinkAttributeRange> filterAttributeRanges;

    private final TypedLinkSchemaAndFacetName filterTypedLink;

    private final String nextToken;

    private final Integer maxResults;

    private final String consistencyLevel;

    private ListIncomingTypedLinksRequest(BuilderImpl builder) {
        super(builder);
        this.directoryArn = builder.directoryArn;
        this.objectReference = builder.objectReference;
        this.filterAttributeRanges = builder.filterAttributeRanges;
        this.filterTypedLink = builder.filterTypedLink;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.consistencyLevel = builder.consistencyLevel;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the directory where you want to list the typed links.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the directory where you want to list the typed links.
     */
    public String directoryArn() {
        return directoryArn;
    }

    /**
     * <p>
     * Reference that identifies the object whose attributes will be listed.
     * </p>
     * 
     * @return Reference that identifies the object whose attributes will be listed.
     */
    public ObjectReference objectReference() {
        return objectReference;
    }

    /**
     * Returns true if the FilterAttributeRanges property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasFilterAttributeRanges() {
        return filterAttributeRanges != null && !(filterAttributeRanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides range filters for multiple attributes. When providing ranges to typed link selection, any inexact ranges
     * must be specified at the end. Any attributes that do not have a range specified are presumed to match the entire
     * range.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilterAttributeRanges()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Provides range filters for multiple attributes. When providing ranges to typed link selection, any
     *         inexact ranges must be specified at the end. Any attributes that do not have a range specified are
     *         presumed to match the entire range.
     */
    public List<TypedLinkAttributeRange> filterAttributeRanges() {
        return filterAttributeRanges;
    }

    /**
     * <p>
     * Filters are interpreted in the order of the attributes on the typed link facet, not the order in which they are
     * supplied to any API calls.
     * </p>
     * 
     * @return Filters are interpreted in the order of the attributes on the typed link facet, not the order in which
     *         they are supplied to any API calls.
     */
    public TypedLinkSchemaAndFacetName filterTypedLink() {
        return filterTypedLink;
    }

    /**
     * <p>
     * The pagination token.
     * </p>
     * 
     * @return The pagination token.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to retrieve.
     * </p>
     * 
     * @return The maximum number of results to retrieve.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The consistency level to execute the request at.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #consistencyLevel}
     * will return {@link ConsistencyLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #consistencyLevelAsString}.
     * </p>
     * 
     * @return The consistency level to execute the request at.
     * @see ConsistencyLevel
     */
    public ConsistencyLevel consistencyLevel() {
        return ConsistencyLevel.fromValue(consistencyLevel);
    }

    /**
     * <p>
     * The consistency level to execute the request at.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #consistencyLevel}
     * will return {@link ConsistencyLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #consistencyLevelAsString}.
     * </p>
     * 
     * @return The consistency level to execute the request at.
     * @see ConsistencyLevel
     */
    public String consistencyLevelAsString() {
        return consistencyLevel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(objectReference());
        hashCode = 31 * hashCode + Objects.hashCode(filterAttributeRanges());
        hashCode = 31 * hashCode + Objects.hashCode(filterTypedLink());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(consistencyLevelAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIncomingTypedLinksRequest)) {
            return false;
        }
        ListIncomingTypedLinksRequest other = (ListIncomingTypedLinksRequest) obj;
        return Objects.equals(directoryArn(), other.directoryArn()) && Objects.equals(objectReference(), other.objectReference())
                && Objects.equals(filterAttributeRanges(), other.filterAttributeRanges())
                && Objects.equals(filterTypedLink(), other.filterTypedLink()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(consistencyLevelAsString(), other.consistencyLevelAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListIncomingTypedLinksRequest").add("DirectoryArn", directoryArn())
                .add("ObjectReference", objectReference()).add("FilterAttributeRanges", filterAttributeRanges())
                .add("FilterTypedLink", filterTypedLink()).add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("ConsistencyLevel", consistencyLevelAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryArn":
            return Optional.ofNullable(clazz.cast(directoryArn()));
        case "ObjectReference":
            return Optional.ofNullable(clazz.cast(objectReference()));
        case "FilterAttributeRanges":
            return Optional.ofNullable(clazz.cast(filterAttributeRanges()));
        case "FilterTypedLink":
            return Optional.ofNullable(clazz.cast(filterTypedLink()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "ConsistencyLevel":
            return Optional.ofNullable(clazz.cast(consistencyLevelAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListIncomingTypedLinksRequest, T> g) {
        return obj -> g.apply((ListIncomingTypedLinksRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudDirectoryRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListIncomingTypedLinksRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the directory where you want to list the typed links.
         * </p>
         * 
         * @param directoryArn
         *        The Amazon Resource Name (ARN) of the directory where you want to list the typed links.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryArn(String directoryArn);

        /**
         * <p>
         * Reference that identifies the object whose attributes will be listed.
         * </p>
         * 
         * @param objectReference
         *        Reference that identifies the object whose attributes will be listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectReference(ObjectReference objectReference);

        /**
         * <p>
         * Reference that identifies the object whose attributes will be listed.
         * </p>
         * This is a convenience that creates an instance of the {@link ObjectReference.Builder} avoiding the need to
         * create one manually via {@link ObjectReference#builder()}.
         *
         * When the {@link Consumer} completes, {@link ObjectReference.Builder#build()} is called immediately and its
         * result is passed to {@link #objectReference(ObjectReference)}.
         * 
         * @param objectReference
         *        a consumer that will call methods on {@link ObjectReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #objectReference(ObjectReference)
         */
        default Builder objectReference(Consumer<ObjectReference.Builder> objectReference) {
            return objectReference(ObjectReference.builder().applyMutation(objectReference).build());
        }

        /**
         * <p>
         * Provides range filters for multiple attributes. When providing ranges to typed link selection, any inexact
         * ranges must be specified at the end. Any attributes that do not have a range specified are presumed to match
         * the entire range.
         * </p>
         * 
         * @param filterAttributeRanges
         *        Provides range filters for multiple attributes. When providing ranges to typed link selection, any
         *        inexact ranges must be specified at the end. Any attributes that do not have a range specified are
         *        presumed to match the entire range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterAttributeRanges(Collection<TypedLinkAttributeRange> filterAttributeRanges);

        /**
         * <p>
         * Provides range filters for multiple attributes. When providing ranges to typed link selection, any inexact
         * ranges must be specified at the end. Any attributes that do not have a range specified are presumed to match
         * the entire range.
         * </p>
         * 
         * @param filterAttributeRanges
         *        Provides range filters for multiple attributes. When providing ranges to typed link selection, any
         *        inexact ranges must be specified at the end. Any attributes that do not have a range specified are
         *        presumed to match the entire range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterAttributeRanges(TypedLinkAttributeRange... filterAttributeRanges);

        /**
         * <p>
         * Provides range filters for multiple attributes. When providing ranges to typed link selection, any inexact
         * ranges must be specified at the end. Any attributes that do not have a range specified are presumed to match
         * the entire range.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TypedLinkAttributeRange>.Builder} avoiding
         * the need to create one manually via {@link List<TypedLinkAttributeRange>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TypedLinkAttributeRange>.Builder#build()} is called
         * immediately and its result is passed to {@link #filterAttributeRanges(List<TypedLinkAttributeRange>)}.
         * 
         * @param filterAttributeRanges
         *        a consumer that will call methods on {@link List<TypedLinkAttributeRange>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterAttributeRanges(List<TypedLinkAttributeRange>)
         */
        Builder filterAttributeRanges(Consumer<TypedLinkAttributeRange.Builder>... filterAttributeRanges);

        /**
         * <p>
         * Filters are interpreted in the order of the attributes on the typed link facet, not the order in which they
         * are supplied to any API calls.
         * </p>
         * 
         * @param filterTypedLink
         *        Filters are interpreted in the order of the attributes on the typed link facet, not the order in which
         *        they are supplied to any API calls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterTypedLink(TypedLinkSchemaAndFacetName filterTypedLink);

        /**
         * <p>
         * Filters are interpreted in the order of the attributes on the typed link facet, not the order in which they
         * are supplied to any API calls.
         * </p>
         * This is a convenience that creates an instance of the {@link TypedLinkSchemaAndFacetName.Builder} avoiding
         * the need to create one manually via {@link TypedLinkSchemaAndFacetName#builder()}.
         *
         * When the {@link Consumer} completes, {@link TypedLinkSchemaAndFacetName.Builder#build()} is called
         * immediately and its result is passed to {@link #filterTypedLink(TypedLinkSchemaAndFacetName)}.
         * 
         * @param filterTypedLink
         *        a consumer that will call methods on {@link TypedLinkSchemaAndFacetName.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterTypedLink(TypedLinkSchemaAndFacetName)
         */
        default Builder filterTypedLink(Consumer<TypedLinkSchemaAndFacetName.Builder> filterTypedLink) {
            return filterTypedLink(TypedLinkSchemaAndFacetName.builder().applyMutation(filterTypedLink).build());
        }

        /**
         * <p>
         * The pagination token.
         * </p>
         * 
         * @param nextToken
         *        The pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to retrieve.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The consistency level to execute the request at.
         * </p>
         * 
         * @param consistencyLevel
         *        The consistency level to execute the request at.
         * @see ConsistencyLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConsistencyLevel
         */
        Builder consistencyLevel(String consistencyLevel);

        /**
         * <p>
         * The consistency level to execute the request at.
         * </p>
         * 
         * @param consistencyLevel
         *        The consistency level to execute the request at.
         * @see ConsistencyLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConsistencyLevel
         */
        Builder consistencyLevel(ConsistencyLevel consistencyLevel);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudDirectoryRequest.BuilderImpl implements Builder {
        private String directoryArn;

        private ObjectReference objectReference;

        private List<TypedLinkAttributeRange> filterAttributeRanges = DefaultSdkAutoConstructList.getInstance();

        private TypedLinkSchemaAndFacetName filterTypedLink;

        private String nextToken;

        private Integer maxResults;

        private String consistencyLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIncomingTypedLinksRequest model) {
            super(model);
            directoryArn(model.directoryArn);
            objectReference(model.objectReference);
            filterAttributeRanges(model.filterAttributeRanges);
            filterTypedLink(model.filterTypedLink);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            consistencyLevel(model.consistencyLevel);
        }

        public final String getDirectoryArn() {
            return directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        public final ObjectReference.Builder getObjectReference() {
            return objectReference != null ? objectReference.toBuilder() : null;
        }

        @Override
        public final Builder objectReference(ObjectReference objectReference) {
            this.objectReference = objectReference;
            return this;
        }

        public final void setObjectReference(ObjectReference.BuilderImpl objectReference) {
            this.objectReference = objectReference != null ? objectReference.build() : null;
        }

        public final Collection<TypedLinkAttributeRange.Builder> getFilterAttributeRanges() {
            return filterAttributeRanges != null ? filterAttributeRanges.stream().map(TypedLinkAttributeRange::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filterAttributeRanges(Collection<TypedLinkAttributeRange> filterAttributeRanges) {
            this.filterAttributeRanges = TypedLinkAttributeRangeListCopier.copy(filterAttributeRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterAttributeRanges(TypedLinkAttributeRange... filterAttributeRanges) {
            filterAttributeRanges(Arrays.asList(filterAttributeRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterAttributeRanges(Consumer<TypedLinkAttributeRange.Builder>... filterAttributeRanges) {
            filterAttributeRanges(Stream.of(filterAttributeRanges)
                    .map(c -> TypedLinkAttributeRange.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilterAttributeRanges(Collection<TypedLinkAttributeRange.BuilderImpl> filterAttributeRanges) {
            this.filterAttributeRanges = TypedLinkAttributeRangeListCopier.copyFromBuilder(filterAttributeRanges);
        }

        public final TypedLinkSchemaAndFacetName.Builder getFilterTypedLink() {
            return filterTypedLink != null ? filterTypedLink.toBuilder() : null;
        }

        @Override
        public final Builder filterTypedLink(TypedLinkSchemaAndFacetName filterTypedLink) {
            this.filterTypedLink = filterTypedLink;
            return this;
        }

        public final void setFilterTypedLink(TypedLinkSchemaAndFacetName.BuilderImpl filterTypedLink) {
            this.filterTypedLink = filterTypedLink != null ? filterTypedLink.build() : null;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getConsistencyLevelAsString() {
            return consistencyLevel;
        }

        @Override
        public final Builder consistencyLevel(String consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
            return this;
        }

        @Override
        public final Builder consistencyLevel(ConsistencyLevel consistencyLevel) {
            this.consistencyLevel(consistencyLevel == null ? null : consistencyLevel.toString());
            return this;
        }

        public final void setConsistencyLevel(String consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListIncomingTypedLinksRequest build() {
            return new ListIncomingTypedLinksRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
