/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The action to take on a typed link attribute value. Updates are only supported for attributes which don’t contribute
 * to link identity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LinkAttributeAction implements SdkPojo, Serializable,
        ToCopyableBuilder<LinkAttributeAction.Builder, LinkAttributeAction> {
    private static final SdkField<String> ATTRIBUTE_ACTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LinkAttributeAction::attributeActionTypeAsString)).setter(setter(Builder::attributeActionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeActionType").build())
            .build();

    private static final SdkField<TypedAttributeValue> ATTRIBUTE_UPDATE_VALUE_FIELD = SdkField
            .<TypedAttributeValue> builder(MarshallingType.SDK_POJO).getter(getter(LinkAttributeAction::attributeUpdateValue))
            .setter(setter(Builder::attributeUpdateValue)).constructor(TypedAttributeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeUpdateValue").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_ACTION_TYPE_FIELD,
            ATTRIBUTE_UPDATE_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String attributeActionType;

    private final TypedAttributeValue attributeUpdateValue;

    private LinkAttributeAction(BuilderImpl builder) {
        this.attributeActionType = builder.attributeActionType;
        this.attributeUpdateValue = builder.attributeUpdateValue;
    }

    /**
     * <p>
     * A type that can be either <code>UPDATE_OR_CREATE</code> or <code>DELETE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #attributeActionType} will return {@link UpdateActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #attributeActionTypeAsString}.
     * </p>
     * 
     * @return A type that can be either <code>UPDATE_OR_CREATE</code> or <code>DELETE</code>.
     * @see UpdateActionType
     */
    public UpdateActionType attributeActionType() {
        return UpdateActionType.fromValue(attributeActionType);
    }

    /**
     * <p>
     * A type that can be either <code>UPDATE_OR_CREATE</code> or <code>DELETE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #attributeActionType} will return {@link UpdateActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #attributeActionTypeAsString}.
     * </p>
     * 
     * @return A type that can be either <code>UPDATE_OR_CREATE</code> or <code>DELETE</code>.
     * @see UpdateActionType
     */
    public String attributeActionTypeAsString() {
        return attributeActionType;
    }

    /**
     * <p>
     * The value that you want to update to.
     * </p>
     * 
     * @return The value that you want to update to.
     */
    public TypedAttributeValue attributeUpdateValue() {
        return attributeUpdateValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributeActionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(attributeUpdateValue());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LinkAttributeAction)) {
            return false;
        }
        LinkAttributeAction other = (LinkAttributeAction) obj;
        return Objects.equals(attributeActionTypeAsString(), other.attributeActionTypeAsString())
                && Objects.equals(attributeUpdateValue(), other.attributeUpdateValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("LinkAttributeAction").add("AttributeActionType", attributeActionTypeAsString())
                .add("AttributeUpdateValue", attributeUpdateValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttributeActionType":
            return Optional.ofNullable(clazz.cast(attributeActionTypeAsString()));
        case "AttributeUpdateValue":
            return Optional.ofNullable(clazz.cast(attributeUpdateValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LinkAttributeAction, T> g) {
        return obj -> g.apply((LinkAttributeAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LinkAttributeAction> {
        /**
         * <p>
         * A type that can be either <code>UPDATE_OR_CREATE</code> or <code>DELETE</code>.
         * </p>
         * 
         * @param attributeActionType
         *        A type that can be either <code>UPDATE_OR_CREATE</code> or <code>DELETE</code>.
         * @see UpdateActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateActionType
         */
        Builder attributeActionType(String attributeActionType);

        /**
         * <p>
         * A type that can be either <code>UPDATE_OR_CREATE</code> or <code>DELETE</code>.
         * </p>
         * 
         * @param attributeActionType
         *        A type that can be either <code>UPDATE_OR_CREATE</code> or <code>DELETE</code>.
         * @see UpdateActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateActionType
         */
        Builder attributeActionType(UpdateActionType attributeActionType);

        /**
         * <p>
         * The value that you want to update to.
         * </p>
         * 
         * @param attributeUpdateValue
         *        The value that you want to update to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeUpdateValue(TypedAttributeValue attributeUpdateValue);

        /**
         * <p>
         * The value that you want to update to.
         * </p>
         * This is a convenience that creates an instance of the {@link TypedAttributeValue.Builder} avoiding the need
         * to create one manually via {@link TypedAttributeValue#builder()}.
         *
         * When the {@link Consumer} completes, {@link TypedAttributeValue.Builder#build()} is called immediately and
         * its result is passed to {@link #attributeUpdateValue(TypedAttributeValue)}.
         * 
         * @param attributeUpdateValue
         *        a consumer that will call methods on {@link TypedAttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributeUpdateValue(TypedAttributeValue)
         */
        default Builder attributeUpdateValue(Consumer<TypedAttributeValue.Builder> attributeUpdateValue) {
            return attributeUpdateValue(TypedAttributeValue.builder().applyMutation(attributeUpdateValue).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String attributeActionType;

        private TypedAttributeValue attributeUpdateValue;

        private BuilderImpl() {
        }

        private BuilderImpl(LinkAttributeAction model) {
            attributeActionType(model.attributeActionType);
            attributeUpdateValue(model.attributeUpdateValue);
        }

        public final String getAttributeActionTypeAsString() {
            return attributeActionType;
        }

        @Override
        public final Builder attributeActionType(String attributeActionType) {
            this.attributeActionType = attributeActionType;
            return this;
        }

        @Override
        public final Builder attributeActionType(UpdateActionType attributeActionType) {
            this.attributeActionType(attributeActionType == null ? null : attributeActionType.toString());
            return this;
        }

        public final void setAttributeActionType(String attributeActionType) {
            this.attributeActionType = attributeActionType;
        }

        public final TypedAttributeValue.Builder getAttributeUpdateValue() {
            return attributeUpdateValue != null ? attributeUpdateValue.toBuilder() : null;
        }

        @Override
        public final Builder attributeUpdateValue(TypedAttributeValue attributeUpdateValue) {
            this.attributeUpdateValue = attributeUpdateValue;
            return this;
        }

        public final void setAttributeUpdateValue(TypedAttributeValue.BuilderImpl attributeUpdateValue) {
            this.attributeUpdateValue = attributeUpdateValue != null ? attributeUpdateValue.build() : null;
        }

        @Override
        public LinkAttributeAction build() {
            return new LinkAttributeAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
