/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTypedLinkFacetInformationResponse extends CloudDirectoryResponse implements
        ToCopyableBuilder<GetTypedLinkFacetInformationResponse.Builder, GetTypedLinkFacetInformationResponse> {
    private static final SdkField<List<String>> IDENTITY_ATTRIBUTE_ORDER_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(GetTypedLinkFacetInformationResponse::identityAttributeOrder))
            .setter(setter(Builder::identityAttributeOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityAttributeOrder").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(IDENTITY_ATTRIBUTE_ORDER_FIELD));

    private final List<String> identityAttributeOrder;

    private GetTypedLinkFacetInformationResponse(BuilderImpl builder) {
        super(builder);
        this.identityAttributeOrder = builder.identityAttributeOrder;
    }

    /**
     * Returns true if the IdentityAttributeOrder property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasIdentityAttributeOrder() {
        return identityAttributeOrder != null && !(identityAttributeOrder instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The order of identity attributes for the facet, from most significant to least significant. The ability to filter
     * typed links considers the order that the attributes are defined on the typed link facet. When providing ranges to
     * typed link selection, any inexact ranges must be specified at the end. Any attributes that do not have a range
     * specified are presumed to match the entire range. Filters are interpreted in the order of the attributes on the
     * typed link facet, not the order in which they are supplied to any API calls. For more information about identity
     * attributes, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     * >Typed Links</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIdentityAttributeOrder()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The order of identity attributes for the facet, from most significant to least significant. The ability
     *         to filter typed links considers the order that the attributes are defined on the typed link facet. When
     *         providing ranges to typed link selection, any inexact ranges must be specified at the end. Any attributes
     *         that do not have a range specified are presumed to match the entire range. Filters are interpreted in the
     *         order of the attributes on the typed link facet, not the order in which they are supplied to any API
     *         calls. For more information about identity attributes, see <a href=
     *         "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     *         >Typed Links</a>.
     */
    public List<String> identityAttributeOrder() {
        return identityAttributeOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identityAttributeOrder());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTypedLinkFacetInformationResponse)) {
            return false;
        }
        GetTypedLinkFacetInformationResponse other = (GetTypedLinkFacetInformationResponse) obj;
        return Objects.equals(identityAttributeOrder(), other.identityAttributeOrder());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetTypedLinkFacetInformationResponse").add("IdentityAttributeOrder", identityAttributeOrder())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityAttributeOrder":
            return Optional.ofNullable(clazz.cast(identityAttributeOrder()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTypedLinkFacetInformationResponse, T> g) {
        return obj -> g.apply((GetTypedLinkFacetInformationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudDirectoryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetTypedLinkFacetInformationResponse> {
        /**
         * <p>
         * The order of identity attributes for the facet, from most significant to least significant. The ability to
         * filter typed links considers the order that the attributes are defined on the typed link facet. When
         * providing ranges to typed link selection, any inexact ranges must be specified at the end. Any attributes
         * that do not have a range specified are presumed to match the entire range. Filters are interpreted in the
         * order of the attributes on the typed link facet, not the order in which they are supplied to any API calls.
         * For more information about identity attributes, see <a href=
         * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
         * >Typed Links</a>.
         * </p>
         * 
         * @param identityAttributeOrder
         *        The order of identity attributes for the facet, from most significant to least significant. The
         *        ability to filter typed links considers the order that the attributes are defined on the typed link
         *        facet. When providing ranges to typed link selection, any inexact ranges must be specified at the end.
         *        Any attributes that do not have a range specified are presumed to match the entire range. Filters are
         *        interpreted in the order of the attributes on the typed link facet, not the order in which they are
         *        supplied to any API calls. For more information about identity attributes, see <a href=
         *        "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
         *        >Typed Links</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityAttributeOrder(Collection<String> identityAttributeOrder);

        /**
         * <p>
         * The order of identity attributes for the facet, from most significant to least significant. The ability to
         * filter typed links considers the order that the attributes are defined on the typed link facet. When
         * providing ranges to typed link selection, any inexact ranges must be specified at the end. Any attributes
         * that do not have a range specified are presumed to match the entire range. Filters are interpreted in the
         * order of the attributes on the typed link facet, not the order in which they are supplied to any API calls.
         * For more information about identity attributes, see <a href=
         * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
         * >Typed Links</a>.
         * </p>
         * 
         * @param identityAttributeOrder
         *        The order of identity attributes for the facet, from most significant to least significant. The
         *        ability to filter typed links considers the order that the attributes are defined on the typed link
         *        facet. When providing ranges to typed link selection, any inexact ranges must be specified at the end.
         *        Any attributes that do not have a range specified are presumed to match the entire range. Filters are
         *        interpreted in the order of the attributes on the typed link facet, not the order in which they are
         *        supplied to any API calls. For more information about identity attributes, see <a href=
         *        "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
         *        >Typed Links</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityAttributeOrder(String... identityAttributeOrder);
    }

    static final class BuilderImpl extends CloudDirectoryResponse.BuilderImpl implements Builder {
        private List<String> identityAttributeOrder = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetTypedLinkFacetInformationResponse model) {
            super(model);
            identityAttributeOrder(model.identityAttributeOrder);
        }

        public final Collection<String> getIdentityAttributeOrder() {
            return identityAttributeOrder;
        }

        @Override
        public final Builder identityAttributeOrder(Collection<String> identityAttributeOrder) {
            this.identityAttributeOrder = AttributeNameListCopier.copy(identityAttributeOrder);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityAttributeOrder(String... identityAttributeOrder) {
            identityAttributeOrder(Arrays.asList(identityAttributeOrder));
            return this;
        }

        public final void setIdentityAttributeOrder(Collection<String> identityAttributeOrder) {
            this.identityAttributeOrder = AttributeNameListCopier.copy(identityAttributeOrder);
        }

        @Override
        public GetTypedLinkFacetInformationResponse build() {
            return new GetTypedLinkFacetInformationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
