/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAppliedSchemaVersionResponse extends CloudDirectoryResponse implements
        ToCopyableBuilder<GetAppliedSchemaVersionResponse.Builder, GetAppliedSchemaVersionResponse> {
    private static final SdkField<String> APPLIED_SCHEMA_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetAppliedSchemaVersionResponse::appliedSchemaArn)).setter(setter(Builder::appliedSchemaArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppliedSchemaArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLIED_SCHEMA_ARN_FIELD));

    private final String appliedSchemaArn;

    private GetAppliedSchemaVersionResponse(BuilderImpl builder) {
        super(builder);
        this.appliedSchemaArn = builder.appliedSchemaArn;
    }

    /**
     * <p>
     * Current applied schema ARN, including the minor version in use if one was provided.
     * </p>
     * 
     * @return Current applied schema ARN, including the minor version in use if one was provided.
     */
    public String appliedSchemaArn() {
        return appliedSchemaArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appliedSchemaArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAppliedSchemaVersionResponse)) {
            return false;
        }
        GetAppliedSchemaVersionResponse other = (GetAppliedSchemaVersionResponse) obj;
        return Objects.equals(appliedSchemaArn(), other.appliedSchemaArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetAppliedSchemaVersionResponse").add("AppliedSchemaArn", appliedSchemaArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppliedSchemaArn":
            return Optional.ofNullable(clazz.cast(appliedSchemaArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAppliedSchemaVersionResponse, T> g) {
        return obj -> g.apply((GetAppliedSchemaVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudDirectoryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAppliedSchemaVersionResponse> {
        /**
         * <p>
         * Current applied schema ARN, including the minor version in use if one was provided.
         * </p>
         * 
         * @param appliedSchemaArn
         *        Current applied schema ARN, including the minor version in use if one was provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appliedSchemaArn(String appliedSchemaArn);
    }

    static final class BuilderImpl extends CloudDirectoryResponse.BuilderImpl implements Builder {
        private String appliedSchemaArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAppliedSchemaVersionResponse model) {
            super(model);
            appliedSchemaArn(model.appliedSchemaArn);
        }

        public final String getAppliedSchemaArn() {
            return appliedSchemaArn;
        }

        @Override
        public final Builder appliedSchemaArn(String appliedSchemaArn) {
            this.appliedSchemaArn = appliedSchemaArn;
            return this;
        }

        public final void setAppliedSchemaArn(String appliedSchemaArn) {
            this.appliedSchemaArn = appliedSchemaArn;
        }

        @Override
        public GetAppliedSchemaVersionResponse build() {
            return new GetAppliedSchemaVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
