/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDirectoryResponse extends CloudDirectoryResponse implements
        ToCopyableBuilder<CreateDirectoryResponse.Builder, CreateDirectoryResponse> {
    private static final SdkField<String> DIRECTORY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDirectoryResponse::directoryArn)).setter(setter(Builder::directoryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDirectoryResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> OBJECT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDirectoryResponse::objectIdentifier)).setter(setter(Builder::objectIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectIdentifier").build()).build();

    private static final SdkField<String> APPLIED_SCHEMA_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDirectoryResponse::appliedSchemaArn)).setter(setter(Builder::appliedSchemaArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppliedSchemaArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ARN_FIELD,
            NAME_FIELD, OBJECT_IDENTIFIER_FIELD, APPLIED_SCHEMA_ARN_FIELD));

    private final String directoryArn;

    private final String name;

    private final String objectIdentifier;

    private final String appliedSchemaArn;

    private CreateDirectoryResponse(BuilderImpl builder) {
        super(builder);
        this.directoryArn = builder.directoryArn;
        this.name = builder.name;
        this.objectIdentifier = builder.objectIdentifier;
        this.appliedSchemaArn = builder.appliedSchemaArn;
    }

    /**
     * <p>
     * The ARN that is associated with the <a>Directory</a>. For more information, see <a>arns</a>.
     * </p>
     * 
     * @return The ARN that is associated with the <a>Directory</a>. For more information, see <a>arns</a>.
     */
    public String directoryArn() {
        return directoryArn;
    }

    /**
     * <p>
     * The name of the <a>Directory</a>.
     * </p>
     * 
     * @return The name of the <a>Directory</a>.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The root object node of the created directory.
     * </p>
     * 
     * @return The root object node of the created directory.
     */
    public String objectIdentifier() {
        return objectIdentifier;
    }

    /**
     * <p>
     * The ARN of the published schema in the <a>Directory</a>. Once a published schema is copied into the directory, it
     * has its own ARN, which is referred to applied schema ARN. For more information, see <a>arns</a>.
     * </p>
     * 
     * @return The ARN of the published schema in the <a>Directory</a>. Once a published schema is copied into the
     *         directory, it has its own ARN, which is referred to applied schema ARN. For more information, see
     *         <a>arns</a>.
     */
    public String appliedSchemaArn() {
        return appliedSchemaArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(objectIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(appliedSchemaArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDirectoryResponse)) {
            return false;
        }
        CreateDirectoryResponse other = (CreateDirectoryResponse) obj;
        return Objects.equals(directoryArn(), other.directoryArn()) && Objects.equals(name(), other.name())
                && Objects.equals(objectIdentifier(), other.objectIdentifier())
                && Objects.equals(appliedSchemaArn(), other.appliedSchemaArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateDirectoryResponse").add("DirectoryArn", directoryArn()).add("Name", name())
                .add("ObjectIdentifier", objectIdentifier()).add("AppliedSchemaArn", appliedSchemaArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryArn":
            return Optional.ofNullable(clazz.cast(directoryArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ObjectIdentifier":
            return Optional.ofNullable(clazz.cast(objectIdentifier()));
        case "AppliedSchemaArn":
            return Optional.ofNullable(clazz.cast(appliedSchemaArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDirectoryResponse, T> g) {
        return obj -> g.apply((CreateDirectoryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudDirectoryResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateDirectoryResponse> {
        /**
         * <p>
         * The ARN that is associated with the <a>Directory</a>. For more information, see <a>arns</a>.
         * </p>
         * 
         * @param directoryArn
         *        The ARN that is associated with the <a>Directory</a>. For more information, see <a>arns</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryArn(String directoryArn);

        /**
         * <p>
         * The name of the <a>Directory</a>.
         * </p>
         * 
         * @param name
         *        The name of the <a>Directory</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The root object node of the created directory.
         * </p>
         * 
         * @param objectIdentifier
         *        The root object node of the created directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectIdentifier(String objectIdentifier);

        /**
         * <p>
         * The ARN of the published schema in the <a>Directory</a>. Once a published schema is copied into the
         * directory, it has its own ARN, which is referred to applied schema ARN. For more information, see
         * <a>arns</a>.
         * </p>
         * 
         * @param appliedSchemaArn
         *        The ARN of the published schema in the <a>Directory</a>. Once a published schema is copied into the
         *        directory, it has its own ARN, which is referred to applied schema ARN. For more information, see
         *        <a>arns</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appliedSchemaArn(String appliedSchemaArn);
    }

    static final class BuilderImpl extends CloudDirectoryResponse.BuilderImpl implements Builder {
        private String directoryArn;

        private String name;

        private String objectIdentifier;

        private String appliedSchemaArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDirectoryResponse model) {
            super(model);
            directoryArn(model.directoryArn);
            name(model.name);
            objectIdentifier(model.objectIdentifier);
            appliedSchemaArn(model.appliedSchemaArn);
        }

        public final String getDirectoryArn() {
            return directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getObjectIdentifier() {
            return objectIdentifier;
        }

        @Override
        public final Builder objectIdentifier(String objectIdentifier) {
            this.objectIdentifier = objectIdentifier;
            return this;
        }

        public final void setObjectIdentifier(String objectIdentifier) {
            this.objectIdentifier = objectIdentifier;
        }

        public final String getAppliedSchemaArn() {
            return appliedSchemaArn;
        }

        @Override
        public final Builder appliedSchemaArn(String appliedSchemaArn) {
            this.appliedSchemaArn = appliedSchemaArn;
            return this;
        }

        public final void setAppliedSchemaArn(String appliedSchemaArn) {
            this.appliedSchemaArn = appliedSchemaArn;
        }

        @Override
        public CreateDirectoryResponse build() {
            return new CreateDirectoryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
