/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchWriteResponse extends CloudDirectoryResponse implements
        ToCopyableBuilder<BatchWriteResponse.Builder, BatchWriteResponse> {
    private static final SdkField<List<BatchWriteOperationResponse>> RESPONSES_FIELD = SdkField
            .<List<BatchWriteOperationResponse>> builder(MarshallingType.LIST)
            .getter(getter(BatchWriteResponse::responses))
            .setter(setter(Builder::responses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Responses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchWriteOperationResponse> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchWriteOperationResponse::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESPONSES_FIELD));

    private final List<BatchWriteOperationResponse> responses;

    private BatchWriteResponse(BuilderImpl builder) {
        super(builder);
        this.responses = builder.responses;
    }

    /**
     * Returns true if the Responses property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasResponses() {
        return responses != null && !(responses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of all the responses for each batch write.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResponses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of all the responses for each batch write.
     */
    public List<BatchWriteOperationResponse> responses() {
        return responses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(responses());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchWriteResponse)) {
            return false;
        }
        BatchWriteResponse other = (BatchWriteResponse) obj;
        return Objects.equals(responses(), other.responses());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchWriteResponse").add("Responses", responses()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Responses":
            return Optional.ofNullable(clazz.cast(responses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchWriteResponse, T> g) {
        return obj -> g.apply((BatchWriteResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudDirectoryResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchWriteResponse> {
        /**
         * <p>
         * A list of all the responses for each batch write.
         * </p>
         * 
         * @param responses
         *        A list of all the responses for each batch write.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responses(Collection<BatchWriteOperationResponse> responses);

        /**
         * <p>
         * A list of all the responses for each batch write.
         * </p>
         * 
         * @param responses
         *        A list of all the responses for each batch write.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responses(BatchWriteOperationResponse... responses);

        /**
         * <p>
         * A list of all the responses for each batch write.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BatchWriteOperationResponse>.Builder}
         * avoiding the need to create one manually via {@link List<BatchWriteOperationResponse>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BatchWriteOperationResponse>.Builder#build()} is called
         * immediately and its result is passed to {@link #responses(List<BatchWriteOperationResponse>)}.
         * 
         * @param responses
         *        a consumer that will call methods on {@link List<BatchWriteOperationResponse>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #responses(List<BatchWriteOperationResponse>)
         */
        Builder responses(Consumer<BatchWriteOperationResponse.Builder>... responses);
    }

    static final class BuilderImpl extends CloudDirectoryResponse.BuilderImpl implements Builder {
        private List<BatchWriteOperationResponse> responses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchWriteResponse model) {
            super(model);
            responses(model.responses);
        }

        public final Collection<BatchWriteOperationResponse.Builder> getResponses() {
            return responses != null ? responses.stream().map(BatchWriteOperationResponse::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder responses(Collection<BatchWriteOperationResponse> responses) {
            this.responses = BatchWriteOperationResponseListCopier.copy(responses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responses(BatchWriteOperationResponse... responses) {
            responses(Arrays.asList(responses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responses(Consumer<BatchWriteOperationResponse.Builder>... responses) {
            responses(Stream.of(responses).map(c -> BatchWriteOperationResponse.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setResponses(Collection<BatchWriteOperationResponse.BuilderImpl> responses) {
            this.responses = BatchWriteOperationResponseListCopier.copyFromBuilder(responses);
        }

        @Override
        public BatchWriteResponse build() {
            return new BatchWriteResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
